/*
 * Decompiled with CFR 0.152.
 */
package traceability.presentation.table.images;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class TraceabilityImageCache {
    private static Map<String, Image> imageCache = new HashMap<String, Image>();

    public static Image getImage(String imageName) {
        if (!imageCache.containsKey(imageName)) {
            Image imgInput = null;
            try {
                URL url = new URL(imageName);
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
                imgInput = desc.createImage(false);
            }
            catch (MalformedURLException malformedURLException) {}
            if (imgInput == null) {
                imageCache.put(imageName, null);
                return null;
            }
            imgInput = TraceabilityImageCache.scaleImage(imgInput);
            imageCache.put(imageName, imgInput);
        }
        return imageCache.get(imageName);
    }

    private static Image scaleImage(Image imgInput) {
        float scale = 1.0f;
        ImageData data = imgInput.getImageData();
        int width = 32;
        int height = 32;
        if (width < data.width) {
            scale = (float)width / (float)data.width;
        }
        if (height < data.height) {
            float tmpScale = (float)height / (float)data.height;
            float f = scale = scale < tmpScale ? scale : tmpScale;
        }
        if ((double)scale > 0.0 && scale != 1.0f) {
            int newWidth = Math.round((float)data.width * scale);
            int newHeight = Math.round((float)data.height * scale);
            Image scaledImage = new Image((Device)Display.getCurrent(), width, height);
            GC gcImage = new GC((Drawable)scaledImage);
            gcImage.setAntialias(1);
            gcImage.setAdvanced(true);
            gcImage.setInterpolation(2);
            gcImage.drawImage(imgInput, 0, 0, data.width, data.height, (width - newWidth) / 2, (height - newHeight) / 2, newWidth, newHeight);
            imgInput.dispose();
            imgInput = scaledImage;
        }
        return imgInput;
    }
}

