/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.common.ui.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CheckboxCellEditor
extends CellEditor {
    protected boolean value;
    protected Button checkButton;
    private static final int defaultStyle = 0;

    public CheckboxCellEditor() {
        this.setStyle(0);
    }

    public CheckboxCellEditor(Composite parent) {
        this(parent, 0);
    }

    public CheckboxCellEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected Control createControl(Composite parent) {
        this.checkButton = new Button(parent, 32);
        this.checkButton.pack();
        this.checkButton.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                CheckboxCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                CheckboxCellEditor.this.applyEditorValueAndDeactivate();
            }

            public void widgetSelected(SelectionEvent event) {
                CheckboxCellEditor.this.applyEditorValueAndDeactivate();
            }
        });
        this.checkButton.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.checkButton.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                CheckboxCellEditor.this.focusLost();
            }
        });
        return this.checkButton;
    }

    protected Object doGetValue() {
        return new Boolean(this.value);
    }

    protected void doSetFocus() {
        this.checkButton.setFocus();
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((boolean)(value instanceof Boolean));
        this.value = (Boolean)value;
        this.checkButton.setSelection(this.value);
    }

    void applyEditorValueAndDeactivate() {
        this.value = this.checkButton.getSelection();
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected void focusLost() {
        if (this.isActivated()) {
            this.applyEditorValueAndDeactivate();
        }
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        }
    }
}

