/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor.internal;

import java.util.Iterator;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.ITextEditor;

public class AnnotationCreator
implements IMessageHandler {
    private final ITextEditor fEditor;
    private final String fAnnotationType;

    public AnnotationCreator(ITextEditor textEditor, String annotationType) {
        this.fEditor = textEditor;
        this.fAnnotationType = annotationType == null ? "org.eclipse.imp.editor.parseAnnotation" : annotationType;
    }

    public void startMessageGroup(String groupName) {
    }

    public void endMessageGroup() {
    }

    public void handleSimpleMessage(String message, int startOffset, int endOffset, int startCol, int endCol, int startLine, int endLine) {
        IAnnotationModel model = this.fEditor.getDocumentProvider().getAnnotationModel((Object)this.fEditor.getEditorInput());
        Annotation annotation = new Annotation(this.fAnnotationType, false, message);
        Position pos = new Position(startOffset, endOffset - startOffset + 1);
        model.addAnnotation(annotation, pos);
    }

    public void removeAnnotations() {
        IAnnotationModel model = this.fEditor.getDocumentProvider().getAnnotationModel((Object)this.fEditor.getEditorInput());
        if (model == null) {
            return;
        }
        Iterator i = model.getAnnotationIterator();
        while (i.hasNext()) {
            Annotation a = (Annotation)i.next();
            if (!a.getType().equals(this.fAnnotationType)) continue;
            model.removeAnnotation(a);
        }
    }

    public void clearMessages() {
        this.removeAnnotations();
    }
}

