/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.smapi;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.imp.smapi.LineElem;

public class SmapBuilder {
    public static String get(String filename, String pathPrefix, ArrayList elems, String fileExten) {
        String name = filename;
        boolean path = false;
        if (filename.indexOf("/") != -1) {
            name = filename.substring(filename.lastIndexOf("/") + 1);
            if (pathPrefix != null) {
                filename = filename.substring(pathPrefix.length() + 1);
            }
            filename = SmapBuilder.replaceAll(filename, File.separator);
            path = true;
        }
        String info = "SMAP\n";
        info = String.valueOf(info) + name + ".java\n";
        info = String.valueOf(info) + fileExten + "\n";
        info = String.valueOf(info) + "*S " + fileExten + "\n";
        info = String.valueOf(info) + "*F\n";
        if (path) {
            info = String.valueOf(info) + "+ ";
        }
        info = String.valueOf(info) + "1 " + name + "." + fileExten + "\n";
        if (path) {
            info = String.valueOf(info) + filename + "." + fileExten + "\n";
        }
        info = String.valueOf(info) + "*L\n";
        for (LineElem elem : elems) {
            info = String.valueOf(info) + elem.getOrigSrcStart() + "#1:" + elem.getJavaStart() + "," + elem.getIncr() + "\n";
        }
        info = String.valueOf(info) + "*E\n";
        return info;
    }

    static String replaceAll(String filename, String sep) {
        String ret = "";
        String[] names = filename.split("/");
        int i = 0;
        while (i < names.length) {
            ret = i == 0 ? names[0] : String.valueOf(ret) + sep + names[i];
            ++i;
        }
        return ret;
    }
}

