/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.common.framework.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.qvt.declarative.common.framework.service.Operation;
import org.eclipse.qvt.declarative.common.framework.service.Provider;
import org.eclipse.qvt.declarative.common.framework.service.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExecutionStrategy {
    public static ExecutionStrategy FIRST = new ExecutionStrategy(){

        @Override
        public List<Object> execute(Service service, Operation operation) throws Exception {
            if (!$assertionsDisabled && operation == null) {
                throw new AssertionError((Object)"null operation");
            }
            Provider provider = service.getFirstProvider(operation);
            if (provider != null) {
                Object result = operation.execute(provider);
                if (result instanceof List) {
                    return (List)result;
                }
                return Collections.singletonList(result);
            }
            return null;
        }
    };
    public static ExecutionStrategy DESCENDING = new ExecutionStrategy(){

        @Override
        public List<Object> execute(Service service, Operation operation) throws Exception {
            if (!$assertionsDisabled && operation == null) {
                throw new AssertionError((Object)"null operation");
            }
            List<Provider> providers = service.getProvidersByPriorityDescending(operation);
            ArrayList<Object> result = new ArrayList<Object>();
            for (Provider provider : providers) {
                result.add(operation.execute(provider));
            }
            return result;
        }
    };

    public abstract List<Object> execute(Service var1, Operation var2) throws Exception;
}

