/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.imp;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lpg.lpgjavaruntime.IToken;
import lpg.lpgjavaruntime.PrsStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.imp.core.ErrorHandler;
import org.eclipse.imp.editor.ModelTreeNode;
import org.eclipse.imp.language.Language;
import org.eclipse.imp.language.ServiceFactory;
import org.eclipse.imp.model.ISourceProject;
import org.eclipse.imp.parser.IMessageHandler;
import org.eclipse.imp.parser.IParseController;
import org.eclipse.imp.parser.ISourcePositionLocator;
import org.eclipse.imp.parser.SimpleAnnotationTypeInfo;
import org.eclipse.imp.services.IAnnotationTypeInfo;
import org.eclipse.imp.services.ILanguageSyntaxProperties;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.lpg.AbstractLexer;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.ocl.lpg.ProblemHandler;
import org.eclipse.qvt.declarative.editor.ui.ICreationFactory;
import org.eclipse.qvt.declarative.editor.ui.builder.MarkerProblemHandler;
import org.eclipse.qvt.declarative.editor.ui.builder.ProblemLimit;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonProblemHandler;
import org.eclipse.qvt.declarative.modelregistry.eclipse.EclipseFileHandle;
import org.eclipse.qvt.declarative.modelregistry.eclipse.EclipseProjectHandle;
import org.eclipse.qvt.declarative.modelregistry.environment.AbstractFileHandle;
import org.eclipse.qvt.declarative.parser.environment.ICSTFileEnvironment;
import org.eclipse.qvt.declarative.parser.environment.ICSTRootEnvironment;
import org.eclipse.qvt.declarative.parser.utils.ASTandCST;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonParseController
implements IParseController {
    private static int counter = 0;
    protected final ICreationFactory creationFactory;
    protected final Language fLanguage;
    protected ISourceProject fProject;
    protected IPath fFilePath;
    protected IMessageHandler handler;
    protected ParsedResult fCurrentAst;
    private List<String> keywords = null;
    private boolean[] fIsKeyword;
    private final SimpleAnnotationTypeInfo fSimpleAnnotationTypeInfo = new SimpleAnnotationTypeInfo();
    private final String id;

    public CommonParseController(ICreationFactory creationFactory) {
        this.creationFactory = creationFactory;
        this.fLanguage = creationFactory.getLanguage();
        this.id = String.valueOf(this.getClass().getSimpleName()) + "-" + ++counter;
        System.out.println(String.valueOf(this.id) + " created");
    }

    protected void cacheKeywordsOnce() {
        if (this.keywords == null) {
            try {
                String[] tokenKindNames = this.getParser().orderedTerminalSymbols();
                this.fIsKeyword = new boolean[tokenKindNames.length];
                this.keywords = new ArrayList<String>();
                int[] keywordKinds = this.getKeywordKinds();
                int i = 1;
                while (i < keywordKinds.length) {
                    int index = this.getParser().mapKind(keywordKinds[i]);
                    this.fIsKeyword[index] = true;
                    this.keywords.add(tokenKindNames[index]);
                    ++i;
                }
            }
            catch (NullPointerException nullPointerException) {
                System.err.println(String.valueOf(this.getClass().getSimpleName()) + ".cacheKeywordsOnce():  NullPointerException; trapped and discarded");
            }
        }
    }

    protected ICSTFileEnvironment createEnvironment(AbstractFileHandle fileHandle) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI astURI = fileHandle.getURI().appendFileExtension(this.creationFactory.getXMLExtension());
        return this.creationFactory.createFileEnvironment(fileHandle, (ResourceSet)resourceSet, astURI);
    }

    protected ProblemHandler createProblemHandler(ICSTFileEnvironment environment) {
        if (this.handler instanceof ProblemHandler) {
            ((ProblemHandler)this.handler).setParser(environment.getParser());
            if (this.handler instanceof MarkerProblemHandler) {
                ((MarkerProblemHandler)this.handler).setProblemLimit(new ProblemLimit(50, 50, 50));
            }
            return (ProblemHandler)this.handler;
        }
        CommonProblemHandler commonProblemHandler = new CommonProblemHandler(environment.getParser(), this.handler);
        commonProblemHandler.setProblemLimit(new ProblemLimit(50, 50, 50));
        return commonProblemHandler;
    }

    public Object getASTNode(Object object) {
        if (object instanceof ModelTreeNode) {
            object = ((ModelTreeNode)object).getASTNode();
        }
        if (object instanceof CSTNode) {
            object = ((CSTNode)object).getAst();
        }
        return object;
    }

    public Object getASTorCSTNode(Object object) {
        if (object instanceof ModelTreeNode) {
            object = ((ModelTreeNode)object).getASTNode();
        }
        return object;
    }

    public IAnnotationTypeInfo getAnnotationTypeInfo() {
        return this.fSimpleAnnotationTypeInfo;
    }

    public CSTNode getCSTNode(Object object) {
        if (this.fCurrentAst == null) {
            return null;
        }
        if (object instanceof ModelTreeNode) {
            object = ((ModelTreeNode)object).getASTNode();
        }
        return this.fCurrentAst.getFileEnvironment().getASTMapping(object);
    }

    public ICreationFactory getCreationFactory() {
        return this.creationFactory;
    }

    public ParsedResult getCurrentAst() {
        return this.fCurrentAst;
    }

    protected AbstractFileHandle getFileHandle() {
        IProject rawProject = this.fProject.getRawProject();
        EclipseProjectHandle projectHandle = new EclipseProjectHandle(rawProject);
        EclipseFileHandle fileHandle = projectHandle.getFileHandle(this.fFilePath.toString());
        return fileHandle;
    }

    public IMessageHandler getHandler() {
        return this.handler;
    }

    protected int[] getKeywordKinds() {
        return this.getLexer().getKeywordKinds();
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public ILabelProvider getLabelProvider() {
        return ServiceFactory.getInstance().getLabelProvider(this.fLanguage);
    }

    public Language getLanguage() {
        return this.fLanguage;
    }

    public AbstractLexer getLexer() {
        return this.getParser().getLexer();
    }

    public ISourcePositionLocator getNodeLocator() {
        if (this.fCurrentAst == null) {
            return null;
        }
        return this.creationFactory.createNodeLocator(this.fCurrentAst.getFileEnvironment());
    }

    public AbstractParser getParser() {
        if (this.fCurrentAst == null) {
            return null;
        }
        ICSTFileEnvironment fileEnvironment = this.fCurrentAst.getFileEnvironment();
        return fileEnvironment.getParser();
    }

    public IPath getPath() {
        return this.fFilePath;
    }

    public ISourceProject getProject() {
        return this.fProject;
    }

    public ILanguageSyntaxProperties getSyntaxProperties() {
        return null;
    }

    public Iterator<IToken> getTokenIterator(IRegion region) {
        int regionOffset = region.getOffset();
        int regionLength = region.getLength();
        int regionEnd = regionOffset + regionLength - 1;
        return new Iterator<IToken>(regionOffset, regionEnd){
            final PrsStream stream;
            final int firstTokIdx;
            final int lastTokIdx;
            int curTokIdx;
            IToken[][] precedingAdjuncts;
            int[] nextPrecedingAdjunct;
            IToken[] followingAdjuncts;
            int nextFollowingAdjunct;
            private boolean finalTokenReturned;
            private boolean finalAdjunctsReturned;
            {
                this.stream = CommonParseController.this.getParser();
                this.firstTokIdx = this.getTokenIndexAtCharacter(n);
                int endIdx = this.getTokenIndexAtCharacter(n2);
                char[] streamChars = this.stream != null ? this.stream.getInputChars() : null;
                int streamLen = streamChars != null ? streamChars.length : 0;
                try {
                    if (n2 >= 1 && n2 < streamLen && streamChars[n2] == '\uffff') {
                        --endIdx;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ErrorHandler.logError((String)"SimpleLPGParseController.getTokenIterator(IRegion):  error initializing lastTokIdx", (Throwable)e);
                }
                this.lastTokIdx = endIdx;
                this.curTokIdx = Math.max(1, this.firstTokIdx);
                this.precedingAdjuncts = new IToken[this.lastTokIdx + 1][];
                this.stream.setStreamLength();
                int i = 0;
                while (i < this.precedingAdjuncts.length) {
                    this.precedingAdjuncts[i] = this.stream.getPrecedingAdjuncts(i);
                    ++i;
                }
                this.nextPrecedingAdjunct = new int[this.lastTokIdx + 1];
                i = 0;
                while (i < this.nextPrecedingAdjunct.length) {
                    this.nextPrecedingAdjunct[i] = this.precedingAdjuncts[i].length == 0 ? -1 : 0;
                    ++i;
                }
                this.followingAdjuncts = this.lastTokIdx <= 0 ? new IToken[0] : this.stream.getFollowingAdjuncts(this.lastTokIdx);
                this.nextFollowingAdjunct = this.followingAdjuncts.length == 0 ? -1 : 0;
                this.finalTokenReturned = n2 < 1 || this.lastTokIdx <= 0;
                this.finalAdjunctsReturned = this.followingAdjuncts.length <= 0;
            }

            private int getTokenIndexAtCharacter(int offset) {
                int result = this.stream.getTokenIndexAtCharacter(offset);
                if (result < 0) {
                    result = -result + 1;
                }
                if (result >= this.stream.getTokens().size()) {
                    result = this.stream.getTokens().size() - 1;
                }
                return result;
            }

            @Override
            public boolean hasNext() {
                return !this.finalTokenReturned || !this.finalAdjunctsReturned;
            }

            @Override
            public IToken next() {
                int next = -1;
                if (this.curTokIdx <= this.lastTokIdx) {
                    next = this.nextPrecedingAdjunct[this.curTokIdx];
                    if (next >= 0 && next < this.precedingAdjuncts[this.curTokIdx].length) {
                        int n = this.curTokIdx;
                        int n2 = this.nextPrecedingAdjunct[n];
                        this.nextPrecedingAdjunct[n] = n2 + 1;
                        return this.precedingAdjuncts[this.curTokIdx][n2];
                    }
                    this.finalTokenReturned = this.curTokIdx >= this.lastTokIdx;
                    return this.stream.getIToken(this.curTokIdx++);
                }
                if (this.nextFollowingAdjunct >= 0 && this.nextFollowingAdjunct < this.followingAdjuncts.length) {
                    this.finalAdjunctsReturned = this.nextFollowingAdjunct + 1 >= this.followingAdjuncts.length;
                    return this.followingAdjuncts[this.nextFollowingAdjunct++];
                }
                return null;
            }

            @Override
            public void remove() {
                throw new IllegalArgumentException("Unimplemented");
            }
        };
    }

    public abstract TokenKind getTokenKind(int var1);

    public void initialize(IPath filePath, ISourceProject project, IMessageHandler handler) {
        this.fProject = project;
        this.fFilePath = filePath;
        this.handler = handler;
        System.out.println(String.valueOf(this.id) + " initialized for " + this.fFilePath.toString());
    }

    public boolean isCompleteable(int kind) {
        switch (this.getTokenKind(kind)) {
            case IDENTIFIER: 
            case INTEGER: 
            case REAL: 
            case STRING: 
            case KEYWORD: {
                return true;
            }
        }
        return false;
    }

    public boolean isIdentifier(int kind) {
        return this.getTokenKind(kind) == TokenKind.IDENTIFIER;
    }

    public boolean isKeyword(int kind) {
        String[] tokenKindNames = this.getParser().orderedTerminalSymbols();
        return kind < tokenKindNames.length && this.fIsKeyword[kind];
    }

    public ParsedResult parse(String contents, boolean scanOnly, IProgressMonitor progressMonitor) {
        block8: {
            System.out.println(String.valueOf(this.id) + " Parse " + this.fFilePath.toString() + " " + this.fLanguage + " scanOnly = " + scanOnly + " handler = " + this.handler.getClass().getName());
            if (progressMonitor.isCanceled()) {
                return this.fCurrentAst;
            }
            ICSTFileEnvironment fileEnvironment = this.createEnvironment(this.getFileHandle());
            fileEnvironment.setProblemHandler(this.createProblemHandler(fileEnvironment));
            ParsedResult newResult = null;
            try {
                ParsedResult workingResult = new ParsedResult(fileEnvironment);
                workingResult.parse(new StringReader(contents), progressMonitor);
                newResult = workingResult;
            }
            catch (IOException e) {
                ErrorHandler.reportError((String)("Failed to parse language " + this.getLanguage().getName() + " and input " + this.getPath() + ":"), (Throwable)e);
                this.fCurrentAst = newResult;
                break block8;
            }
            catch (CoreException e) {
                try {
                    ErrorHandler.reportError((String)("Failed to parse language " + this.getLanguage().getName() + " and input " + this.getPath() + ":"), (Throwable)e);
                    break block8;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this.fCurrentAst = newResult;
                }
            }
            this.fCurrentAst = newResult;
        }
        this.cacheKeywordsOnce();
        return this.fCurrentAst;
    }

    public static class ParsedResult
    extends ASTandCST {
        protected final ICSTFileEnvironment fileEnvironment;
        protected ICSTRootEnvironment rootEnvironment;

        public ParsedResult(ICSTFileEnvironment fileEnvironment) {
            this.fileEnvironment = fileEnvironment;
        }

        public ICSTFileEnvironment getFileEnvironment() {
            return this.fileEnvironment;
        }

        public ICSTRootEnvironment getRootEnvironment() {
            return this.rootEnvironment;
        }

        public ICSTRootEnvironment parse(Reader reader, IProgressMonitor progressMonitor) throws IOException, CoreException {
            this.rootEnvironment = this.fileEnvironment.parse(reader, this.fileEnvironment.getFile(), progressMonitor);
            if (this.rootEnvironment == null) {
                return null;
            }
            this.rootEnvironment.validate();
            this.setCST(this.rootEnvironment.getCSTNode());
            this.setAST((Resource)this.rootEnvironment.getASTNode());
            return this.rootEnvironment;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TokenKind {
        EOF,
        IDENTIFIER,
        INTEGER,
        REAL,
        STRING,
        KEYWORD,
        LINE_COMMENT,
        PARAGRAPH_COMMENT,
        OTHER;

    }
}

