/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.modelregistry.ui.builder;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.qvt.declarative.modelregistry.ui.ModelRegistryUIPlugin;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ToggleNatureAction
implements IObjectActionDelegate {
    private static final String UMLX_NATURE_ID = "org.eclipse.gmt.umlx.registry.editor.ModelRegistryNature";
    private ISelection selection;

    public void run(IAction action) {
        if (this.selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)this.selection) {
                IProject project = null;
                if (element instanceof IProject) {
                    project = (IProject)element;
                } else if (element instanceof IAdaptable) {
                    project = (IProject)((IAdaptable)element).getAdapter(IProject.class);
                }
                if (project == null) continue;
                this.toggleNature(project);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    private void toggleNature(IProject project) {
        try {
            String[] newNatures;
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            int i = 0;
            while (i < natures.length) {
                if (UMLX_NATURE_ID.equals(natures[i])) {
                    newNatures = new String[natures.length - 1];
                    System.arraycopy(natures, 0, newNatures, 0, i);
                    System.arraycopy(natures, i + 1, newNatures, i, newNatures.length - i);
                    natures = newNatures;
                }
                ++i;
            }
            i = 0;
            while (i < natures.length) {
                if ("org.eclipse.qvt.declarative.modelregistry.ui.ModelRegistryNature".equals(natures[i])) {
                    newNatures = new String[natures.length - 1];
                    System.arraycopy(natures, 0, newNatures, 0, i);
                    System.arraycopy(natures, i + 1, newNatures, i, natures.length - i - 1);
                    description.setNatureIds(newNatures);
                    project.setDescription(description, null);
                    return;
                }
                ++i;
            }
            String[] newNatures2 = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures2, 0, natures.length);
            newNatures2[natures.length] = "org.eclipse.qvt.declarative.modelregistry.ui.ModelRegistryNature";
            description.setNatureIds(newNatures2);
            project.setDescription(description, null);
        }
        catch (CoreException e) {
            ModelRegistryUIPlugin.logError("Failed to toggle nature org.eclipse.qvt.declarative.modelregistry.ui.ModelRegistryNature", e);
        }
    }
}

