/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.modelregistry.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.qvt.declarative.modelregistry.environment.AbstractFileHandle;
import org.eclipse.qvt.declarative.modelregistry.environment.AccessorKindRegistry;
import org.eclipse.qvt.declarative.modelregistry.environment.ModelRegistryEnvironment;
import org.eclipse.qvt.declarative.modelregistry.model.Accessor;
import org.eclipse.qvt.declarative.modelregistry.model.FileHandleRegistry;
import org.eclipse.qvt.declarative.modelregistry.model.ModelSerialization;
import org.eclipse.qvt.declarative.modelregistry.model.ProjectRegistry;
import org.eclipse.qvt.declarative.modelregistry.model.Registration;
import org.eclipse.qvt.declarative.modelregistry.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessorRegistry<A extends Accessor>
implements Comparable<AccessorRegistry<A>> {
    private final FileHandleRegistry parent;
    private final Class<A> accessorClass;
    private final Map<String, Registration<A>> registrations = new HashMap<String, Registration<A>>();

    public AccessorRegistry(FileHandleRegistry parent, Class<A> accessorClass) {
        this.parent = parent;
        this.accessorClass = accessorClass;
    }

    public void add(Registration<?> registration) {
        Accessor validAccessor = (Accessor)ClassUtils.asClass(registration.getAccessor(), this.accessorClass);
        if (validAccessor == null) {
            ModelRegistryEnvironment.logError("BUG -- Inconsistent accessor classes : " + registration.getAccessor().getClass() + ", " + this.accessorClass, null);
        } else if (this.registrations.get(validAccessor) != null) {
            ModelRegistryEnvironment.logError("BUG -- Conflicting accessor : " + registration, null);
        } else {
            this.registrations.put(validAccessor.getName(), ClassUtils.asClassUnchecked(registration, null));
        }
    }

    public Registration<A> add(String accessorName, URI uri, ModelSerialization modelSerialisation) {
        AccessorKindRegistry accessorKindRegistry = ModelRegistryEnvironment.getInstance().getAccessorKindRegistry();
        A accessor = accessorKindRegistry.createAccessor(this.accessorClass, accessorName);
        return this.add(accessor, uri, modelSerialisation);
    }

    public Registration<A> add(A accessor, URI uri, ModelSerialization modelSerialisation) {
        Registration<A> registration = new Registration<A>(this, accessor, uri, modelSerialisation);
        this.registrations.put(accessor.getName(), registration);
        return registration;
    }

    public Registration<A> add(Registration<A> registration) {
        return this.registrations.put(registration.getAccessorName(), registration);
    }

    public void clear() {
        this.registrations.clear();
    }

    @Override
    public int compareTo(AccessorRegistry<A> accessorRegistry) {
        return this.getAccessorClass().getName().compareTo(accessorRegistry.getAccessorClass().getName());
    }

    public Registration<A> createRegistration(String accessorName, String resourceURI, ModelSerialization modelSerialisation) {
        AccessorKindRegistry accessorKindRegistry = ModelRegistryEnvironment.getInstance().getAccessorKindRegistry();
        A accessor = accessorKindRegistry.createAccessor(this.getAccessorClass(), accessorName);
        URI uri = URI.createURI((String)resourceURI);
        return new Registration<A>(this, accessor, uri, modelSerialisation);
    }

    public Registration<A> get(A accessor) {
        return this.registrations.get(accessor.getName());
    }

    public Class<A> getAccessorClass() {
        return this.accessorClass;
    }

    public AbstractFileHandle getFileHandle() {
        return this.parent.getFileHandle();
    }

    public FileHandleRegistry getFileHandleRegistry() {
        return this.parent;
    }

    public ProjectRegistry getProjectRegistry() {
        return this.parent.getProjectRegistry();
    }

    public Collection<String> getRegistrationKeys() {
        return this.registrations.keySet();
    }

    public Collection<Registration<A>> getRegistrations() {
        return this.registrations.values();
    }

    public Registration<A> remove(Registration<A> registration) {
        return this.registrations.remove(registration.getAccessorName());
    }

    public String toString() {
        AccessorKindRegistry accessorKindRegistry = ModelRegistryEnvironment.getInstance().getAccessorKindRegistry();
        return String.valueOf(String.valueOf(this.parent)) + "[" + accessorKindRegistry.toAccessorString(this.accessorClass) + "]";
    }
}

