/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.parser.qvtcore.environment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.LookupException;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.qvt.declarative.ecore.QVTBase.QVTBaseFactory;
import org.eclipse.qvt.declarative.ecore.QVTBase.Rule;
import org.eclipse.qvt.declarative.ecore.QVTBase.Transformation;
import org.eclipse.qvt.declarative.ecore.QVTBase.TypedModel;
import org.eclipse.qvt.declarative.ecore.QVTCore.Mapping;
import org.eclipse.qvt.declarative.ecore.utils.EcoreUtils;
import org.eclipse.qvt.declarative.parser.environment.CSTChildEnvironment;
import org.eclipse.qvt.declarative.parser.qvt.cst.IdentifierCS;
import org.eclipse.qvt.declarative.parser.qvtcore.cst.DirectionCS;
import org.eclipse.qvt.declarative.parser.qvtcore.cst.MappingCS;
import org.eclipse.qvt.declarative.parser.qvtcore.cst.QueryCS;
import org.eclipse.qvt.declarative.parser.qvtcore.cst.TransformationCS;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.IQVTcNodeEnvironment;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.QVTcEnvironment;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.QVTcQueryEnvironment;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.QVTcRootMappingEnvironment;
import org.eclipse.qvt.declarative.parser.qvtcore.environment.QVTcTopLevelEnvironment;
import org.eclipse.qvt.declarative.parser.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QVTcTransformationEnvironment
extends QVTcEnvironment<IQVTcNodeEnvironment, QVTcTopLevelEnvironment, Transformation, TransformationCS> {
    private Map<MappingCS, QVTcRootMappingEnvironment> mappingCSEnvironments = new HashMap<MappingCS, QVTcRootMappingEnvironment>();
    private Map<String, QVTcRootMappingEnvironment> mappingEnvironments = new HashMap<String, QVTcRootMappingEnvironment>();
    private Map<QueryCS, QVTcQueryEnvironment> queryCSEnvironments = new HashMap<QueryCS, QVTcQueryEnvironment>();
    private final Map<String, List<EPackage>> metaModelContents = new HashMap<String, List<EPackage>>();
    private List<EPackage> allContents = null;

    public QVTcTransformationEnvironment(QVTcTopLevelEnvironment env, TransformationCS transformationCS) {
        super(env, QVTBaseFactory.eINSTANCE.createTransformation(), transformationCS);
        EList names = transformationCS.getPathName().getSequenceOfNames();
        String name = (String)names.get(names.size() - 1);
        ((Transformation)this.ast).setName(name);
        transformationCS.getPathName().setAst((Object)this.ast);
        Variable variable = EcoreFactory.eINSTANCE.createVariable();
        this.rootEnvironment.getASTNodeToCSTNodeMap().put(variable, transformationCS);
        variable.setName("self");
        variable.setType((Object)((EClassifier)this.ast));
        this.setSelfVariable((org.eclipse.ocl.expressions.Variable)variable);
    }

    public void addMetaModelPackage(String metaModelId, EPackage ePackage) {
        List<EPackage> contents = this.metaModelContents.get(metaModelId);
        if (contents == null) {
            contents = new ArrayList<EPackage>();
            this.metaModelContents.put(metaModelId, contents);
        }
        if (!contents.contains(ePackage)) {
            contents.add(ePackage);
        }
        if (this.allContents == null) {
            this.allContents = new ArrayList<EPackage>();
        }
        if (!this.allContents.contains(ePackage)) {
            this.allContents.add(ePackage);
        }
    }

    public QVTcRootMappingEnvironment createEnvironment(MappingCS mappingCS) {
        QVTcRootMappingEnvironment environment = new QVTcRootMappingEnvironment(this, mappingCS);
        Mapping mapping = environment.getMapping();
        ((Transformation)this.ast).getRule().add((Object)mapping);
        this.mappingCSEnvironments.put(mappingCS, environment);
        QVTcRootMappingEnvironment oldEnvironment = this.mappingEnvironments.put(mappingCS.getName(), environment);
        if (oldEnvironment != null) {
            this.analyzerError("Duplicate mapping", "MappingCS", mappingCS);
        }
        return environment;
    }

    public QVTcQueryEnvironment createEnvironment(QueryCS queryCS) {
        QVTcQueryEnvironment environment = new QVTcQueryEnvironment(this, queryCS);
        this.queryCSEnvironments.put(queryCS, environment);
        return environment;
    }

    public TypedModel createTypedModel(DirectionCS directionCS) {
        IdentifierCS identifierCS = directionCS.getIdentifier();
        String identifier = identifierCS.getValue();
        Transformation transformation = this.getTransformation();
        TypedModel typedModel = (TypedModel)EcoreUtils.getNamedElement((Collection)transformation.getModelParameter(), (String)identifier);
        if (typedModel != null) {
            this.analyzerError("direction already defined", "directionCS", directionCS);
        } else {
            typedModel = QVTBaseFactory.eINSTANCE.createTypedModel();
            this.initASTMapping(typedModel, (CSTNode)directionCS);
            CSTChildEnvironment.setNameFromIdentifier((ENamedElement)typedModel, (IdentifierCS)identifierCS);
            transformation.getModelParameter().add((Object)typedModel);
        }
        return typedModel;
    }

    public QVTcRootMappingEnvironment getEnvironment(String name) {
        return this.mappingEnvironments.get(name);
    }

    public QVTcRootMappingEnvironment getEnvironment(MappingCS mappingCS) {
        return this.mappingCSEnvironments.get(mappingCS);
    }

    public QVTcQueryEnvironment getEnvironment(QueryCS queryCS) {
        return this.queryCSEnvironments.get(queryCS);
    }

    public Collection<MappingCS> getMappings() {
        return this.mappingCSEnvironments.keySet();
    }

    public String getModelName(EObject object) {
        for (String key : this.metaModelContents.keySet()) {
            List<EPackage> ePackages = this.metaModelContents.get(key);
            if (!ePackages.contains(object)) continue;
            return key;
        }
        return null;
    }

    public Collection<QueryCS> getQueries() {
        return this.queryCSEnvironments.keySet();
    }

    public Transformation getTransformation() {
        return (Transformation)this.ast;
    }

    public TypedModel getTypedModel(IdentifierCS identifierCS) {
        String identifier = identifierCS.getValue();
        Transformation transformation = this.getTransformation();
        return (TypedModel)EcoreUtils.getNamedElement((Collection)transformation.getModelParameter(), (String)identifier);
    }

    public List<EPackage> resolvePackages(PathNameCS packageNameCS) {
        EList names = packageNameCS.getSequenceOfNames();
        String packageName = StringUtils.splice((List)names, (String)"::");
        List<EPackage> ePackages = this.metaModelContents.get(packageName);
        if (ePackages == null) {
            ePackages = new ArrayList<EPackage>();
            this.metaModelContents.put(packageName, ePackages);
            URI uri = this.getFileEnvironment().getResolver().getURI(packageName);
            if (uri == null) {
                String message = "Unknown package '" + this.formatString(packageName) + "'";
                this.analyzerError(message, "ImportCS", packageNameCS);
            } else {
                try {
                    Resource resource = this.getFileEnvironment().getResolver().getResource(uri, true);
                    if (resource == null) {
                        String message = "Failed to load package '" + this.formatString(packageName) + "'";
                        this.analyzerError(message, "ImportCS", packageNameCS);
                    } else {
                        EList contents = resource.getContents();
                        if (contents != null) {
                            for (EObject eObject : contents) {
                                if (eObject instanceof EPackage) {
                                    ePackages.add((EPackage)eObject);
                                    continue;
                                }
                                String message = "Non-EPackage '" + this.formatName(eObject) + "' ignored";
                                this.analyzerError(message, "ImportCS", packageNameCS);
                            }
                        }
                    }
                    ePackages = this.metaModelContents.get(packageName);
                }
                catch (Exception e) {
                    String message = "Failed to load package '" + this.formatString(packageName) + "' : " + e.getMessage();
                    this.analyzerError(message, "ImportCS", packageNameCS);
                }
            }
        }
        return ePackages;
    }

    public EClassifier tryLookupClassifier(List<String> names) throws LookupException {
        EClassifier eClassifier;
        EClassifier eClassifier2;
        String metaModelName;
        List<EPackage> contextPackages;
        if (names == null) {
            return null;
        }
        int namesSize = names.size();
        if (namesSize > 1 && (contextPackages = this.metaModelContents.get(metaModelName = names.get(0))) != null && !contextPackages.isEmpty() && (eClassifier2 = this.tryLookupClassifier(contextPackages, names.subList(1, namesSize))) != null) {
            return eClassifier2;
        }
        if (namesSize > 0 && this.allContents != null && !this.allContents.isEmpty() && (eClassifier = this.tryLookupClassifier(this.allContents, names)) != null) {
            return eClassifier;
        }
        return super.tryLookupClassifier(names);
    }

    @Override
    public Mapping tryLookupMapping(String name) throws LookupException {
        Rule firstFind = null;
        ArrayList<Rule> allFinds = null;
        for (Rule rule : ((Transformation)this.ast).getRule()) {
            if (!name.equals(rule.getName())) continue;
            if (allFinds != null) {
                allFinds.add(rule);
                continue;
            }
            if (firstFind != null) {
                allFinds = new ArrayList<Rule>();
                allFinds.add(firstFind);
                allFinds.add(rule);
                firstFind = null;
                continue;
            }
            firstFind = rule;
        }
        if (allFinds != null) {
            throw new LookupException("Ambiguous Mapping", allFinds);
        }
        if (firstFind == null) {
            return null;
        }
        if (firstFind instanceof Mapping) {
            return (Mapping)firstFind;
        }
        throw new LookupException("Non-Mapping", Collections.singletonList(firstFind));
    }
}

