/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvts;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.QVTrelationDirectedScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.RelationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationalTransformation2TracePackage;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtrelation.Key;
import org.eclipse.qvtd.pivot.qvtrelation.RelationalTransformation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationHelper;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.RootRegion;

public class RelationalTransformationAnalysis
extends AbstractTransformationAnalysis {
    protected final @NonNull QVTrelationHelper helper;
    private final @NonNull Map<@NonNull CompleteClass, @Nullable Key> completeClass2key = new HashMap<CompleteClass, Key>();

    public RelationalTransformationAnalysis(@NonNull QVTrelationDirectedScheduleManager directedScheduleManager, @NonNull RelationalTransformation transformation, @NonNull RootRegion rootRegion) {
        super(directedScheduleManager, (Transformation)transformation, rootRegion);
        this.helper = new QVTrelationHelper(directedScheduleManager.getEnvironmentFactory());
        QVTbaseUtil.getPrimitiveTypedModel((Transformation)transformation);
    }

    protected void analyzeKey(@NonNull Key key) {
        Class keyedClass = QVTrelationUtil.getIdentifies((Key)key);
        CompleteClass keyedCompleteClass = this.getCompleteClass((Type)keyedClass);
        this.completeClass2key.put(keyedCompleteClass, key);
        TypedModel typedModel = this.scheduleManager.getDomainUsage((Element)key).getTypedModel((Element)this.transformation);
        assert (typedModel != null);
        ClassDatum classDatum = this.scheduleManager.getClassDatum(typedModel, keyedClass);
        for (Property part : QVTrelationUtil.getOwnedParts((Key)key)) {
            PropertyDatum propertyDatum = this.scheduleManager.getPropertyDatum(classDatum, part);
            propertyDatum.setKey(true);
        }
        for (Property oppositePart : QVTrelationUtil.getOwnedOppositeParts((Key)key)) {
            Property part = QVTrelationUtil.getOpposite((Property)oppositePart);
            PropertyDatum propertyDatum = this.scheduleManager.getPropertyDatum(classDatum, part);
            propertyDatum.setKey(true);
        }
    }

    @Override
    public void analyzeSourceModel() {
        for (Key key : QVTrelationUtil.getOwnedKey((RelationalTransformation)this.getTransformation())) {
            this.analyzeKey(key);
        }
        super.analyzeSourceModel();
    }

    public @Nullable Key getKeyForType(@NonNull Type type) {
        CompleteClass completeClass = this.getCompleteClass(type);
        return this.completeClass2key.get(completeClass);
    }

    @Override
    public @NonNull RelationAnalysis getRuleAnalysis(@NonNull Rule rule) {
        return (RelationAnalysis)super.getRuleAnalysis(rule);
    }

    @Override
    public @NonNull QVTrelationDirectedScheduleManager getScheduleManager() {
        return (QVTrelationDirectedScheduleManager)this.scheduleManager;
    }

    public @NonNull RelationalTransformation getTransformation() {
        return (RelationalTransformation)super.getTransformation();
    }

    @Override
    public @NonNull RelationalTransformation2TracePackage getTransformation2TracePackage() {
        return (RelationalTransformation2TracePackage)super.getTransformation2TracePackage();
    }
}

