/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.doc.exe2016.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public abstract class AbstractDoublyLinkedListGenerator<@NonNull L extends EObject, @NonNull E extends EObject> {
    public void checkModel(L list, int testSize) {
        List<E> elements = this.getOwnedElements(list);
        assert (elements.size() == testSize - 1);
        int i = 0;
        @Nullable E element = this.getHeadElement(list);
        while (element != null) {
            assert (this.getElementName(element).equals("e-" + (i > 0 ? testSize - i : 1)));
            if (i > 0 && element == this.getHeadElement(list)) break;
            ++i;
            element = this.getTarget(element);
        }
        assert (i == testSize - 1);
        i = 0;
        element = this.getHeadElement(list);
        while (element != null) {
            if (i > 0 && element == this.getHeadElement(list)) break;
            assert (this.getElementName(element).equals("e-" + (i + 1)));
            ++i;
            element = this.getSource(element);
        }
        assert (i == testSize - 1);
    }

    public @NonNull List<@NonNull ? extends EObject> createDoublyLinkedListModel(int nElements) {
        E element;
        L list = this.createDoublyLinkedList();
        this.setListName(list, "listName");
        @Nullable E prevElement = null;
        ArrayList<E> elements = new ArrayList<E>(nElements - 1);
        int n = 1;
        while (n < nElements) {
            element = this.createElement();
            this.setElementName(element, "e-" + n);
            elements.add(element);
            if (n == 1) {
                this.setHeadElement(list, element);
            }
            if (n == nElements - 1) {
                this.setSource((EObject)ClassUtil.nonNullState(this.getHeadElement(list)), element);
            }
            if (prevElement != null) {
                this.setSource(element, prevElement);
            }
            prevElement = element;
            ++n;
        }
        this.getOwnedElements(list).addAll(elements);
        int i = 1;
        element = this.getHeadElement(list);
        while (element != null) {
            if (i > 1 && element == this.getHeadElement(list)) break;
            ++i;
            element = this.getTarget(element);
        }
        assert (i == nElements);
        return Collections.singletonList(list);
    }

    protected abstract L createDoublyLinkedList();

    protected abstract E createElement();

    protected abstract String getElementName(E var1);

    protected abstract @Nullable E getHeadElement(L var1);

    protected abstract String getListName(L var1);

    protected abstract @NonNull List<E> getOwnedElements(L var1);

    protected abstract E getSource(E var1);

    protected abstract E getTarget(E var1);

    protected abstract void setElementName(E var1, String var2);

    protected abstract void setHeadElement(L var1, E var2);

    protected abstract void setListName(L var1, String var2);

    protected abstract void setSource(E var1, E var2);

    protected abstract void setTarget(E var1, E var2);
}

