/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFolder;
import org.eclipse.m2m.internal.qvt.oml.common.io.CResource;

public class CFileUtil {
    private CFileUtil() {
    }

    public static void copyFolder(CFolder sourceDir, CFolder destDir) throws IOException {
        CResource[] children = sourceDir.members();
        int i = 0;
        while (i < children.length) {
            CResource source = children[i];
            if (source instanceof CFolder) {
                CFolder sourceFolder = (CFolder)source;
                CFolder destFolder = destDir.getFolder(sourceFolder.getName());
                destFolder.create();
                CFileUtil.copyFolder(sourceFolder, destFolder);
            } else {
                CFile sourceFile = (CFile)source;
                CFile destFile = destDir.getFile(source.getName());
                CFileUtil.copyFile(sourceFile, destFile);
            }
            ++i;
        }
    }

    public static void copyFile(CFile from, CFile to) throws IOException {
        InputStream contents = null;
        try {
            contents = from.getContents();
            if (to.exists()) {
                to.setContents(contents);
            } else {
                to.create(contents);
            }
        }
        catch (Throwable throwable) {
            if (contents != null) {
                try {
                    contents.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (contents != null) {
            try {
                contents.close();
            }
            catch (Exception exception) {}
        }
    }

    public static Reader getReader(CFile file) throws IOException {
        String charset = file.getCharset();
        InputStreamReader reader = charset == null ? new InputStreamReader(file.getContents()) : new InputStreamReader(file.getContents(), charset);
        return reader;
    }

    public static InputStream getContentStreamForFile(CFile file, String contents) throws IOException {
        String charset = CFileUtil.getFileCharset(file);
        ByteArrayInputStream stream = charset == null ? new ByteArrayInputStream(contents.getBytes()) : new ByteArrayInputStream(contents.getBytes(charset));
        return stream;
    }

    public static String getFileCharset(CFile file) throws IOException {
        String charset = file.exists() ? file.getCharset() : file.getParent().getDefaultCharset();
        return charset;
    }
}

