/*
 * Decompiled with CFR 0.152.
 */
package org.gastro.business.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.gastro.business.BusinessDay;
import org.gastro.business.BusinessFactory;
import org.gastro.business.BusinessPackage;
import org.gastro.business.Order;
import org.gastro.business.OrderDetail;
import org.gastro.business.OrderState;
import org.gastro.business.Waiter;
import org.gastro.business.impl.BusinessDayImpl;
import org.gastro.business.impl.OrderDetailImpl;
import org.gastro.business.impl.OrderImpl;
import org.gastro.business.impl.WaiterImpl;

public class BusinessFactoryImpl
extends EFactoryImpl
implements BusinessFactory {
    public static BusinessFactory init() {
        try {
            BusinessFactory theBusinessFactory = (BusinessFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.gastro.org/business/1.0");
            if (theBusinessFactory != null) {
                return theBusinessFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new BusinessFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createBusinessDay();
            }
            case 1: {
                return this.createOrder();
            }
            case 2: {
                return this.createOrderDetail();
            }
            case 3: {
                return this.createWaiter();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.createOrderStateFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 4: {
                return this.convertOrderStateToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public BusinessDay createBusinessDay() {
        BusinessDayImpl businessDay = new BusinessDayImpl();
        return businessDay;
    }

    public Order createOrder() {
        OrderImpl order = new OrderImpl();
        return order;
    }

    public OrderDetail createOrderDetail() {
        OrderDetailImpl orderDetail = new OrderDetailImpl();
        return orderDetail;
    }

    public Waiter createWaiter() {
        WaiterImpl waiter = new WaiterImpl();
        return waiter;
    }

    public OrderState createOrderStateFromString(EDataType eDataType, String initialValue) {
        OrderState result = OrderState.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertOrderStateToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public BusinessPackage getBusinessPackage() {
        return (BusinessPackage)this.getEPackage();
    }

    @Deprecated
    public static BusinessPackage getPackage() {
        return BusinessPackage.eINSTANCE;
    }
}

