/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.id;

import java.io.IOException;
import java.io.ObjectStreamException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDString;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.spi.common.id.AbstractCDOID;
import org.eclipse.emf.cdo.spi.common.id.InternalCDOIDObject;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ref.Interner;

public final class CDOIDObjectStringWithClassifierImpl
extends AbstractCDOID
implements InternalCDOIDObject,
CDOIDString,
CDOClassifierRef.Provider {
    private static final long serialVersionUID = 1L;
    private static final StringWithClassifierInterner INTERNER = new StringWithClassifierInterner();
    private final String value;
    private final CDOClassifierRef classifierRef;

    private CDOIDObjectStringWithClassifierImpl(String value, CDOClassifierRef classifierRef) {
        CheckUtil.checkArg((Object)value, (String)"Null not allowed");
        this.value = value;
        this.classifierRef = classifierRef;
    }

    private CDOIDObjectStringWithClassifierImpl() {
        this.value = null;
        this.classifierRef = null;
    }

    public String getStringValue() {
        return this.value;
    }

    public CDOClassifierRef getClassifierRef() {
        return this.classifierRef;
    }

    public void write(CDODataOutput out) throws IOException {
        out.writeString(this.value);
        out.writeCDOClassifierRef(this.classifierRef);
    }

    public String toURIFragment() {
        return String.valueOf(this.classifierRef.getPackageURI()) + "#" + this.classifierRef.getClassifierName() + "#" + this.value;
    }

    public CDOID.Type getType() {
        return CDOID.Type.OBJECT;
    }

    public CDOID.ObjectType getSubType() {
        return CDOID.ObjectType.STRING_WITH_CLASSIFIER;
    }

    public boolean isExternal() {
        return false;
    }

    public boolean isObject() {
        return true;
    }

    public boolean isTemporary() {
        return false;
    }

    public int hashCode() {
        return CDOIDObjectStringWithClassifierImpl.getHashCode(this.value, this.classifierRef);
    }

    public String toString() {
        return "OID:" + this.toURIFragment();
    }

    protected int doCompareTo(CDOID o) throws ClassCastException {
        return this.toURIFragment().compareTo(o.toURIFragment());
    }

    private Object readResolve() throws ObjectStreamException {
        return CDOIDObjectStringWithClassifierImpl.create(this.value, this.classifierRef);
    }

    private static int getHashCode(String value, CDOClassifierRef classifierRef) {
        return value.hashCode() ^ classifierRef.hashCode();
    }

    public static CDOIDObjectStringWithClassifierImpl create(String value, CDOClassifierRef classifierRef) {
        return INTERNER.intern(value, classifierRef);
    }

    public static CDOIDObjectStringWithClassifierImpl create(CDODataInput in) throws IOException {
        String value = in.readString();
        CDOClassifierRef classifierRef = in.readCDOClassifierRef();
        return CDOIDObjectStringWithClassifierImpl.create(value, classifierRef);
    }

    public static CDOIDObjectStringWithClassifierImpl create(String fragmentPart) {
        int index1 = fragmentPart.indexOf("#");
        int index2 = fragmentPart.indexOf("#", index1 + 1);
        if (index1 == -1 || index2 == -1) {
            throw new IllegalArgumentException("The fragment " + fragmentPart + " is invalid");
        }
        String packageURI = fragmentPart.substring(0, index1);
        String classifierName = fragmentPart.substring(index1 + 1, index2);
        CDOClassifierRef classifierRef = new CDOClassifierRef(packageURI, classifierName);
        String value = fragmentPart.substring(index2 + 1);
        return CDOIDObjectStringWithClassifierImpl.create(value, classifierRef);
    }

    /* synthetic */ CDOIDObjectStringWithClassifierImpl(String string, CDOClassifierRef cDOClassifierRef, CDOIDObjectStringWithClassifierImpl cDOIDObjectStringWithClassifierImpl) {
        this(string, cDOClassifierRef);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StringWithClassifierInterner
    extends Interner<CDOIDObjectStringWithClassifierImpl> {
        private StringWithClassifierInterner() {
        }

        public synchronized CDOIDObjectStringWithClassifierImpl intern(String value, CDOClassifierRef classifierRef) {
            int hashCode = CDOIDObjectStringWithClassifierImpl.getHashCode(value, classifierRef);
            Interner.Entry entry = this.getEntry(hashCode);
            while (entry != null) {
                CDOIDObjectStringWithClassifierImpl id = (CDOIDObjectStringWithClassifierImpl)entry.get();
                if (id != null && id.value.equals(value) && id.classifierRef.equals(classifierRef)) {
                    return id;
                }
                entry = entry.getNextEntry();
            }
            CDOIDObjectStringWithClassifierImpl id = new CDOIDObjectStringWithClassifierImpl(value, classifierRef, null);
            this.addEntry(this.createEntry(id, hashCode));
            return id;
        }

        protected int hashCode(CDOIDObjectStringWithClassifierImpl id) {
            return CDOIDObjectStringWithClassifierImpl.getHashCode(id.value, id.classifierRef);
        }
    }
}

