/*
 * Decompiled with CFR 0.152.
 */
package com.swtdesigner;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class SWTResourceManager {
    private static Map m_colorMap = new HashMap();
    private static Map m_imageMap = new HashMap();
    private static final int MISSING_IMAGE_SIZE = 10;
    public static final int TOP_LEFT = 1;
    public static final int TOP_RIGHT = 2;
    public static final int BOTTOM_LEFT = 3;
    public static final int BOTTOM_RIGHT = 4;
    protected static final int LAST_CORNER_KEY = 5;
    private static Map[] m_decoratedImageMap = new Map[5];
    private static Map m_fontMap = new HashMap();
    private static Map m_fontToBoldFontMap = new HashMap();

    public static Color getColor(int systemColorID) {
        Display display = Display.getCurrent();
        return display.getSystemColor(systemColorID);
    }

    public static Color getColor(int r, int g, int b) {
        return SWTResourceManager.getColor(new RGB(r, g, b));
    }

    public static Color getColor(RGB rgb) {
        Color color = (Color)m_colorMap.get(rgb);
        if (color == null) {
            Display display = Display.getCurrent();
            color = new Color((Device)display, rgb);
            m_colorMap.put(rgb, color);
        }
        return color;
    }

    public static void disposeColors() {
        Iterator I = m_colorMap.values().iterator();
        while (I.hasNext()) {
            ((Color)I.next()).dispose();
        }
        m_colorMap.clear();
    }

    protected static Image getImage(InputStream stream) throws IOException {
        try {
            Display display = Display.getCurrent();
            ImageData data = new ImageData(stream);
            if (data.transparentPixel > 0) {
                Image image = new Image((Device)display, data, data.getTransparencyMask());
                return image;
            }
            Image image = new Image((Device)display, data);
            return image;
        }
        finally {
            stream.close();
        }
    }

    public static Image getImage(String path) {
        Image image = (Image)m_imageMap.get(path);
        if (image == null) {
            try {
                image = SWTResourceManager.getImage(new FileInputStream(path));
                m_imageMap.put(path, image);
            }
            catch (Exception e) {
                image = SWTResourceManager.getMissingImage();
                m_imageMap.put(path, image);
            }
        }
        return image;
    }

    public static Image getImage(Class clazz, String path) {
        String key = String.valueOf(clazz.getName()) + '|' + path;
        Image image = (Image)m_imageMap.get(key);
        if (image == null) {
            try {
                image = SWTResourceManager.getImage(clazz.getResourceAsStream(path));
                m_imageMap.put(key, image);
            }
            catch (Exception e) {
                image = SWTResourceManager.getMissingImage();
                m_imageMap.put(key, image);
            }
        }
        return image;
    }

    private static Image getMissingImage() {
        Image image = new Image((Device)Display.getCurrent(), 10, 10);
        GC gc = new GC((Drawable)image);
        gc.setBackground(SWTResourceManager.getColor(3));
        gc.fillRectangle(0, 0, 10, 10);
        gc.dispose();
        return image;
    }

    public static Image decorateImage(Image baseImage, Image decorator) {
        return SWTResourceManager.decorateImage(baseImage, decorator, 4);
    }

    public static Image decorateImage(Image baseImage, Image decorator, int corner) {
        Image result;
        HashMap<Image, Image> decoratedMap;
        if (corner <= 0 || corner >= 5) {
            throw new IllegalArgumentException("Wrong decorate corner");
        }
        HashMap cornerDecoratedImageMap = m_decoratedImageMap[corner];
        if (cornerDecoratedImageMap == null) {
            SWTResourceManager.m_decoratedImageMap[corner] = cornerDecoratedImageMap = new HashMap();
        }
        if ((decoratedMap = (HashMap<Image, Image>)cornerDecoratedImageMap.get(baseImage)) == null) {
            decoratedMap = new HashMap<Image, Image>();
            cornerDecoratedImageMap.put(baseImage, decoratedMap);
        }
        if ((result = (Image)decoratedMap.get(decorator)) == null) {
            Rectangle bib = baseImage.getBounds();
            Rectangle dib = decorator.getBounds();
            result = new Image((Device)Display.getCurrent(), bib.width, bib.height);
            GC gc = new GC((Drawable)result);
            gc.drawImage(baseImage, 0, 0);
            if (corner == 1) {
                gc.drawImage(decorator, 0, 0);
            } else if (corner == 2) {
                gc.drawImage(decorator, bib.width - dib.width, 0);
            } else if (corner == 3) {
                gc.drawImage(decorator, 0, bib.height - dib.height);
            } else if (corner == 4) {
                gc.drawImage(decorator, bib.width - dib.width, bib.height - dib.height);
            }
            gc.dispose();
            decoratedMap.put(decorator, result);
        }
        return result;
    }

    public static void disposeImages() {
        Iterator I = m_imageMap.values().iterator();
        while (I.hasNext()) {
            ((Image)I.next()).dispose();
        }
        m_imageMap.clear();
        int i = 0;
        while (i < m_decoratedImageMap.length) {
            Map cornerDecoratedImageMap = m_decoratedImageMap[i];
            if (cornerDecoratedImageMap != null) {
                for (Map decoratedMap : cornerDecoratedImageMap.values()) {
                    for (Image image : decoratedMap.values()) {
                        image.dispose();
                    }
                    decoratedMap.clear();
                }
                cornerDecoratedImageMap.clear();
            }
            ++i;
        }
    }

    public static Font getFont(String name, int height, int style) {
        return SWTResourceManager.getFont(name, height, style, false, false);
    }

    public static Font getFont(String name, int size, int style, boolean strikeout, boolean underline) {
        String fontName = String.valueOf(name) + '|' + size + '|' + style + '|' + strikeout + '|' + underline;
        Font font = (Font)m_fontMap.get(fontName);
        if (font == null) {
            FontData fontData = new FontData(name, size, style);
            if (strikeout || underline) {
                try {
                    Class<?> logFontClass = Class.forName("org.eclipse.swt.internal.win32.LOGFONT");
                    Object logFont = FontData.class.getField("data").get(fontData);
                    if (logFont != null && logFontClass != null) {
                        if (strikeout) {
                            logFontClass.getField("lfStrikeOut").set(logFont, new Byte(1));
                        }
                        if (underline) {
                            logFontClass.getField("lfUnderline").set(logFont, new Byte(1));
                        }
                    }
                }
                catch (Throwable e) {
                    IOUtil.ERR().println("Unable to set underline or strikeout (probably on a non-Windows platform). " + e);
                }
            }
            font = new Font((Device)Display.getCurrent(), fontData);
            m_fontMap.put(fontName, font);
        }
        return font;
    }

    public static Font getBoldFont(Font baseFont) {
        Font font = (Font)m_fontToBoldFontMap.get(baseFont);
        if (font == null) {
            FontData[] fontDatas = baseFont.getFontData();
            FontData data = fontDatas[0];
            font = new Font((Device)Display.getCurrent(), data.getName(), data.getHeight(), 1);
            m_fontToBoldFontMap.put(baseFont, font);
        }
        return font;
    }

    public static void disposeFonts() {
        Iterator iter = m_fontMap.values().iterator();
        while (iter.hasNext()) {
            ((Font)iter.next()).dispose();
        }
        m_fontMap.clear();
        iter = m_fontToBoldFontMap.values().iterator();
        while (iter.hasNext()) {
            ((Font)iter.next()).dispose();
        }
        m_fontToBoldFontMap.clear();
    }

    public static void dispose() {
        SWTResourceManager.disposeColors();
        SWTResourceManager.disposeImages();
        SWTResourceManager.disposeFonts();
    }
}

