/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.migrator.tasks;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.cdo.internal.migrator.tasks.CDOTask;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;

public class CleanupProjectTask
extends CDOTask {
    private String projectName;

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    protected void checkAttributes() throws BuildException {
        CleanupProjectTask.assertTrue("'projectName' must be specified.", this.projectName != null && this.projectName.length() != 0);
    }

    protected void doExecute() throws Exception {
        IProject project = this.root.getProject(this.projectName);
        if (!project.exists()) {
            this.verbose("Project " + this.projectName + " does not exist.");
            return;
        }
        this.verbose("Cleaning up project " + this.projectName + " ...");
        EclipseHelper.sourceCleanup(this, project);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EclipseHelper {
        private static final Generator.CleanupScheduler SCHEDULER = EclipseHelper.getCleanupScheduler();

        private EclipseHelper() {
        }

        public static void sourceCleanup(CDOTask task, IProject project) {
            if (SCHEDULER != null) {
                Set<ICompilationUnit> compilationUnits = EclipseHelper.collectCompilationUnits(project, task);
                SCHEDULER.schedule(compilationUnits);
            }
        }

        private static Set<ICompilationUnit> collectCompilationUnits(IProject project, CDOTask task) {
            LinkedHashSet<ICompilationUnit> compilationUnits = new LinkedHashSet<ICompilationUnit>();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getAllPackageFragmentRoots();
                int n = iPackageFragmentRootArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
                    IResource resource = packageFragmentRoot.getCorrespondingResource();
                    if (resource instanceof IContainer && project.equals((Object)resource.getProject())) {
                        EclipseHelper.collectCompilationUnits((IContainer)resource, compilationUnits, task);
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                throw new BuildException((Throwable)ex);
            }
            return compilationUnits;
        }

        private static void collectCompilationUnits(IContainer container, Set<ICompilationUnit> compilationUnits, CDOTask task) throws CoreException {
            IResource[] iResourceArray = container.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICompilationUnit compilationUnit;
                IResource resource = iResourceArray[n2];
                if (resource instanceof IContainer) {
                    EclipseHelper.collectCompilationUnits((IContainer)resource, compilationUnits, task);
                } else if (resource instanceof IFile && (compilationUnit = JavaCore.createCompilationUnitFrom((IFile)((IFile)resource))) != null) {
                    task.verbose("   " + resource.getProjectRelativePath());
                    compilationUnits.add(compilationUnit);
                }
                ++n2;
            }
        }

        private static Generator.CleanupScheduler getCleanupScheduler() {
            try {
                Class generatorUIUtilClass = CommonPlugin.loadClass((String)"org.eclipse.emf.codegen.ecore.ui", (String)"org.eclipse.emf.codegen.ecore.genmodel.presentation.GeneratorUIUtil");
                return (Generator.CleanupScheduler)generatorUIUtilClass.getField("CLEANUP_SCHEDULER").get(null);
            }
            catch (Throwable t) {
                return null;
            }
        }
    }
}

