/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.om.log;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.net4j.internal.util.om.OSGiBundle;
import org.eclipse.net4j.util.om.log.OMLogHandler;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.osgi.framework.Bundle;

public class EclipseLoggingBridge
implements OMLogHandler {
    public static final EclipseLoggingBridge INSTANCE = new EclipseLoggingBridge();

    protected EclipseLoggingBridge() {
    }

    public void logged(OMLogger logger, OMLogger.Level level, String msg, Throwable t) {
        try {
            OSGiBundle bundle = (OSGiBundle)logger.getBundle();
            ILog log = Platform.getLog((Bundle)bundle.getBundleContext().getBundle());
            log.log((IStatus)new Status(EclipseLoggingBridge.toEclipse(level), bundle.getBundleID(), 0, msg, t));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static int toEclipse(OMLogger.Level level) {
        switch (level) {
            case ERROR: {
                return 4;
            }
            case WARN: {
                return 2;
            }
            case INFO: {
                return 1;
            }
            case DEBUG: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Illegal log level: " + (Object)((Object)level));
    }
}

