/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.tests;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentRunner {
    public static void run(Runnable[] runnables, int maxThreads, int numOfExecution) throws Throwable {
        ExecutorService threadPool = Executors.newFixedThreadPool(maxThreads);
        Future<Throwable>[] futures = ConcurrentRunner.execute(numOfExecution, threadPool, runnables);
        ConcurrentRunner.throwOnFailure(futures, threadPool);
    }

    private static Future<Throwable>[] execute(int loops, ExecutorService threadPool, Runnable[] runnables) {
        Future[] futures = new Future[loops * runnables.length];
        int j = 0;
        while (j < loops) {
            int i = 0;
            while (i < runnables.length) {
                futures[j * runnables.length + i] = threadPool.submit(new ThrowableCatchingWrapper(runnables[i]));
                ++i;
            }
            ++j;
        }
        return futures;
    }

    private static void throwOnFailure(Future<Throwable>[] futures, ExecutorService threadPool) throws InterruptedException, ExecutionException, Throwable {
        Future<Throwable>[] futureArray = futures;
        int n = futures.length;
        int n2 = 0;
        while (n2 < n) {
            Future<Throwable> future = futureArray[n2];
            Throwable e = future.get();
            if (e != null) {
                threadPool.shutdownNow();
                throw e;
            }
            ++n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThrowableCatchingWrapper
    implements Callable<Throwable> {
        private Runnable runnable;

        private ThrowableCatchingWrapper(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public Throwable call() throws Exception {
            try {
                this.runnable.run();
                return null;
            }
            catch (Throwable t) {
                return t;
            }
        }
    }
}

