/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.tests;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.io.ExpectedFileInputStream;
import org.eclipse.net4j.util.io.ExpectedFileReader;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.tests.AbstractOMTest;

public class ExpectedIOTest
extends AbstractOMTest {
    private Exception exception;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.exception = null;
    }

    public void testInputStream() throws Exception {
        final File file = this.createTempFile("ExpectedIOTest", ".tmp");
        int LOOPS = 30;
        Thread producer = new Thread("PRODUCER"){

            public void run() {
                block7: {
                    DataOutputStream out = null;
                    try {
                        try {
                            out = new DataOutputStream(new FileOutputStream(file));
                            int i = 0;
                            while (i < 30) {
                                out.writeInt(i);
                                IOUtil.ERR().println(i);
                                ConcurrencyUtil.sleep((long)10L);
                                ++i;
                            }
                        }
                        catch (Exception ex) {
                            if (ExpectedIOTest.this.exception == null) {
                                ExpectedIOTest.this.exception = ex;
                            }
                            IOUtil.close(out);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(out);
                        throw throwable;
                    }
                    IOUtil.close((Closeable)out);
                }
            }
        };
        Thread consumer = new Thread("CONSUMER"){

            public void run() {
                block7: {
                    DataInputStream in = null;
                    try {
                        try {
                            in = new DataInputStream((InputStream)new ExpectedFileInputStream(file, 120L));
                            int i = 0;
                            while (i < 30) {
                                System.out.println(in.readInt());
                                ++i;
                            }
                        }
                        catch (Exception ex) {
                            if (ExpectedIOTest.this.exception == null) {
                                ExpectedIOTest.this.exception = ex;
                            }
                            IOUtil.close(in);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(in);
                        throw throwable;
                    }
                    IOUtil.close((Closeable)in);
                }
            }
        };
        producer.start();
        ConcurrencyUtil.sleep((long)500L);
        consumer.start();
        producer.join();
        consumer.join();
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public void testInputStreamEOF() throws Exception {
        final File file = this.createTempFile("ExpectedIOTest", ".tmp");
        int LOOPS = 30;
        Thread producer = new Thread("PRODUCER"){

            public void run() {
                block7: {
                    DataOutputStream out = null;
                    try {
                        try {
                            out = new DataOutputStream(new FileOutputStream(file));
                            int i = 0;
                            while (i < 30) {
                                out.writeInt(i);
                                IOUtil.ERR().println(i);
                                ConcurrencyUtil.sleep((long)10L);
                                ++i;
                            }
                        }
                        catch (Exception ex) {
                            if (ExpectedIOTest.this.exception == null) {
                                ExpectedIOTest.this.exception = ex;
                            }
                            IOUtil.close(out);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(out);
                        throw throwable;
                    }
                    IOUtil.close((Closeable)out);
                }
            }
        };
        Thread consumer = new Thread("CONSUMER"){

            public void run() {
                block7: {
                    DataInputStream in = null;
                    try {
                        try {
                            in = new DataInputStream((InputStream)new ExpectedFileInputStream(file, 120L));
                            int i = 0;
                            while (i < 40) {
                                System.out.println(in.readInt());
                                ++i;
                            }
                        }
                        catch (Exception ex) {
                            if (ExpectedIOTest.this.exception == null) {
                                ExpectedIOTest.this.exception = ex;
                            }
                            IOUtil.close(in);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(in);
                        throw throwable;
                    }
                    IOUtil.close((Closeable)in);
                }
            }
        };
        producer.start();
        ConcurrencyUtil.sleep((long)500L);
        consumer.start();
        producer.join();
        consumer.join();
        if (!(this.exception instanceof EOFException)) {
            throw this.exception;
        }
    }

    public void testReader() throws Exception {
        final File file = this.createTempFile("ExpectedIOTest", ".tmp");
        int LOOPS = 30;
        Thread producer = new Thread("PRODUCER"){

            public void run() {
                block7: {
                    FileWriter out = null;
                    try {
                        try {
                            out = new FileWriter(file);
                            int i = 0;
                            while (i < 30) {
                                int c = 97 + i;
                                ((Writer)out).write(c);
                                IOUtil.ERR().println(c);
                                ((Writer)out).write(c + 1);
                                IOUtil.ERR().println(c + 1);
                                ConcurrencyUtil.sleep((long)10L);
                                ++i;
                            }
                        }
                        catch (Exception ex) {
                            if (ExpectedIOTest.this.exception == null) {
                                ExpectedIOTest.this.exception = ex;
                            }
                            IOUtil.close((Closeable)out);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(out);
                        throw throwable;
                    }
                    IOUtil.close((Closeable)out);
                }
            }
        };
        Thread consumer = new Thread("CONSUMER"){

            public void run() {
                block9: {
                    ExpectedFileReader in = null;
                    try {
                        try {
                            in = new ExpectedFileReader(file, 60L);
                            int i = 0;
                            while (i < 30) {
                                int c = in.read();
                                if (c == -1) {
                                    throw new EOFException();
                                }
                                System.out.println(c);
                                c = in.read();
                                if (c == -1) {
                                    throw new EOFException();
                                }
                                System.out.println(c);
                                ++i;
                            }
                        }
                        catch (Exception ex) {
                            if (ExpectedIOTest.this.exception == null) {
                                ExpectedIOTest.this.exception = ex;
                            }
                            IOUtil.close((Closeable)in);
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(in);
                        throw throwable;
                    }
                    IOUtil.close((Closeable)in);
                }
            }
        };
        producer.start();
        ConcurrencyUtil.sleep((long)500L);
        consumer.start();
        producer.join();
        consumer.join();
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public void testReaderEOF() throws Exception {
        final File file = this.createTempFile("ExpectedIOTest", ".tmp");
        int LOOPS = 30;
        Thread producer = new Thread("PRODUCER"){

            public void run() {
                block7: {
                    FileWriter out = null;
                    try {
                        try {
                            out = new FileWriter(file);
                            int i = 0;
                            while (i < 30) {
                                int c = 97 + i;
                                ((Writer)out).write(c);
                                IOUtil.ERR().println(c);
                                ((Writer)out).write(c + 1);
                                IOUtil.ERR().println(c + 1);
                                ConcurrencyUtil.sleep((long)10L);
                                ++i;
                            }
                        }
                        catch (Exception ex) {
                            if (ExpectedIOTest.this.exception == null) {
                                ExpectedIOTest.this.exception = ex;
                            }
                            IOUtil.close((Closeable)out);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(out);
                        throw throwable;
                    }
                    IOUtil.close((Closeable)out);
                }
            }
        };
        Thread consumer = new Thread("CONSUMER"){

            public void run() {
                block9: {
                    ExpectedFileReader in = null;
                    try {
                        try {
                            in = new ExpectedFileReader(file, 60L);
                            int i = 0;
                            while (i < 40) {
                                int c = in.read();
                                if (c == -1) {
                                    throw new EOFException();
                                }
                                System.out.println(c);
                                c = in.read();
                                if (c == -1) {
                                    throw new EOFException();
                                }
                                System.out.println(c);
                                ++i;
                            }
                        }
                        catch (Exception ex) {
                            if (ExpectedIOTest.this.exception == null) {
                                ExpectedIOTest.this.exception = ex;
                            }
                            IOUtil.close((Closeable)in);
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(in);
                        throw throwable;
                    }
                    IOUtil.close((Closeable)in);
                }
            }
        };
        producer.start();
        ConcurrencyUtil.sleep((long)500L);
        consumer.start();
        producer.join();
        consumer.join();
        if (!(this.exception instanceof EOFException)) {
            throw this.exception;
        }
    }
}

