/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.tests.AbstractOMTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedIOTest
extends AbstractOMTest {
    public void testObject() throws Exception {
        HashMap<String, String> map = this.createMap();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ExtendedDataOutputStream edos = new ExtendedDataOutputStream((OutputStream)baos);
        edos.writeObject(map);
        edos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ExtendedDataInputStream edis = new ExtendedDataInputStream((InputStream)bais);
        HashMap result = (HashMap)edis.readObject();
        ExtendedIOTest.assertEquals(map, result);
    }

    public void testObject1() throws Exception {
        byte[] byteArray = this.createByteArray1();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ExtendedDataOutputStream edos = new ExtendedDataOutputStream((OutputStream)baos);
        edos.writeObject((Object)byteArray);
        edos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ExtendedDataInputStream edis = new ExtendedDataInputStream((InputStream)bais);
        byte[] result = (byte[])edis.readObject();
        ExtendedIOTest.assertEquals((boolean)true, (boolean)Arrays.equals(byteArray, result));
    }

    public void testObject2() throws Exception {
        byte[] byteArray = this.createByteArray2();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ExtendedDataOutputStream edos = new ExtendedDataOutputStream((OutputStream)baos);
        edos.writeObject((Object)byteArray);
        edos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ExtendedDataInputStream edis = new ExtendedDataInputStream((InputStream)bais);
        byte[] result = (byte[])edis.readObject();
        ExtendedIOTest.assertEquals((boolean)true, (boolean)Arrays.equals(byteArray, result));
    }

    public void testByteArray1() throws Exception {
        byte[] byteArray = this.createByteArray1();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ExtendedDataOutputStream edos = new ExtendedDataOutputStream((OutputStream)baos);
        edos.writeByteArray(byteArray);
        edos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ExtendedDataInputStream edis = new ExtendedDataInputStream((InputStream)bais);
        byte[] result = edis.readByteArray();
        ExtendedIOTest.assertEquals((boolean)true, (boolean)Arrays.equals(byteArray, result));
    }

    public void testByteArray2() throws Exception {
        byte[] byteArray = this.createByteArray2();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ExtendedDataOutputStream edos = new ExtendedDataOutputStream((OutputStream)baos);
        edos.writeByteArray(byteArray);
        edos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ExtendedDataInputStream edis = new ExtendedDataInputStream((InputStream)bais);
        byte[] result = edis.readByteArray();
        ExtendedIOTest.assertEquals((boolean)true, (boolean)Arrays.equals(byteArray, result));
    }

    private byte[] createByteArray1() throws IOException {
        HashMap<String, String> map = this.createMap();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ExtendedDataOutputStream edos = new ExtendedDataOutputStream((OutputStream)baos);
        edos.writeObject(map);
        edos.close();
        return baos.toByteArray();
    }

    private byte[] createByteArray2() {
        byte[] byteArray = new byte[256];
        int v = -128;
        int i = 0;
        while (i < byteArray.length) {
            v = (byte)(v + 1);
            ++i;
        }
        return byteArray;
    }

    private HashMap<String, String> createMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        this.putMap(map, "org.eclipse.net4j.util.io.CachedFileMap.java");
        this.putMap(map, "org.eclipse.net4j.util.io.CloseableIterator.java");
        this.putMap(map, "org.eclipse.net4j.util.io.DataInputExtender.java");
        this.putMap(map, "org.eclipse.net4j.util.io.DataOutputExtender.java");
        this.putMap(map, "org.eclipse.net4j.util.io.DelegatingInputStream.java");
        this.putMap(map, "org.eclipse.net4j.util.io.DelegatingOutputStream.java");
        this.putMap(map, "org.eclipse.net4j.util.io.DelegatingStreamWrapper.java");
        this.putMap(map, "org.eclipse.net4j.util.io.ExtendedDataInput.java");
        this.putMap(map, "org.eclipse.net4j.util.io.ExtendedDataInputStream.java");
        this.putMap(map, "org.eclipse.net4j.util.io.ExtendedDataOutput.java");
        this.putMap(map, "org.eclipse.net4j.util.io.ExtendedDataOutputStream.java");
        this.putMap(map, "org.eclipse.net4j.util.io.ExtendedIOUtil.java");
        this.putMap(map, "org.eclipse.net4j.util.io.GZIPStreamWrapper.java");
        this.putMap(map, "org.eclipse.net4j.util.io.IOFilter.java");
        this.putMap(map, "org.eclipse.net4j.util.io.IORunnable.java");
        this.putMap(map, "org.eclipse.net4j.util.io.IORuntimeException.java");
        this.putMap(map, "org.eclipse.net4j.util.io.IOUtil.java");
        this.putMap(map, "org.eclipse.net4j.util.io.IOVisitor.java");
        this.putMap(map, "org.eclipse.net4j.util.io.IStreamWrapper.java");
        this.putMap(map, "org.eclipse.net4j.util.io.NIOUtil.java");
        this.putMap(map, "org.eclipse.net4j.util.io.SortedFileMap.java");
        this.putMap(map, "org.eclipse.net4j.util.io.StreamWrapperChain.java");
        this.putMap(map, "org.eclipse.net4j.util.io.TMPUtil.java");
        this.putMap(map, "org.eclipse.net4j.util.io.XORInputStream.java");
        this.putMap(map, "org.eclipse.net4j.util.io.XOROutputStream.java");
        this.putMap(map, "org.eclipse.net4j.util.io.XORStreamWrapper.java");
        this.putMap(map, "org.eclipse.net4j.util.io.ZIPUtil.java");
        return map;
    }

    private void putMap(HashMap<String, String> map, String string) {
        map.put(string, string);
    }
}

