/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.tests;

import org.eclipse.net4j.util.concurrent.ISynchronizer;
import org.eclipse.net4j.util.concurrent.SynchronizingCorrelator;
import org.eclipse.net4j.util.tests.AbstractOMTest;

public class SynchronizingCorrelatorTest
extends AbstractOMTest {
    public void testPutConsumerFirst() throws Exception {
        final Boolean[] result = new Boolean[]{false};
        final SynchronizingCorrelator correlator = new SynchronizingCorrelator();
        Thread consumer = new Thread(){

            public void run() {
                ISynchronizer eike = correlator.correlate((Object)"eike");
                result[0] = (Boolean)eike.get(5000L);
                SynchronizingCorrelatorTest.msg("RESULT: " + result[0]);
            }
        };
        consumer.start();
        SynchronizingCorrelatorTest.sleep(100L);
        correlator.put((Object)"eike", (Object)true, 15000L);
        consumer.join(15000L);
        SynchronizingCorrelatorTest.assertEquals(Boolean.TRUE, result[0]);
    }

    public void testPutConsumerFirst10() throws Exception {
        int i = 0;
        while (i < 10) {
            this.testPutConsumerFirst();
            ++i;
        }
    }

    public void testBlockingPutConsumerFirst() throws Exception {
        final Boolean[] result = new Boolean[]{false};
        final SynchronizingCorrelator correlator = new SynchronizingCorrelator();
        Thread consumer = new Thread(){

            public void run() {
                ISynchronizer eike = correlator.correlate((Object)"eike");
                result[0] = (Boolean)eike.get(5000L);
                SynchronizingCorrelatorTest.msg("RESULT: " + result[0]);
            }
        };
        consumer.start();
        Thread.sleep(10L);
        boolean consumed = correlator.put((Object)"eike", (Object)true, 1000L);
        SynchronizingCorrelatorTest.msg("Consumed: " + consumed);
        SynchronizingCorrelatorTest.assertEquals((boolean)true, (boolean)consumed);
        consumer.join(1000L);
        SynchronizingCorrelatorTest.assertEquals(Boolean.TRUE, result[0]);
    }

    public void testBlockingPutConsumerFirst10() throws Exception {
        int i = 0;
        while (i < 10) {
            this.testBlockingPutConsumerFirst();
            ++i;
        }
    }

    public void _testPutProducerFirst() throws Exception {
        final Boolean[] result = new Boolean[]{false};
        final SynchronizingCorrelator correlator = new SynchronizingCorrelator();
        correlator.put((Object)"eike", (Object)true, 15000L);
        Thread consumer = new Thread(){

            public void run() {
                ISynchronizer eike = correlator.correlate((Object)"eike");
                result[0] = (Boolean)eike.get(5000L);
                SynchronizingCorrelatorTest.msg("RESULT: " + result[0]);
            }
        };
        consumer.start();
        Thread.sleep(10L);
        consumer.join(100L);
        SynchronizingCorrelatorTest.assertEquals(Boolean.TRUE, result[0]);
    }

    public void _testPutProducerFirst10() throws Exception {
        int i = 0;
        while (i < 10) {
            this._testPutProducerFirst();
            ++i;
        }
    }

    public void testBlockingPutProducerFirst() throws Exception {
        final Boolean[] result = new Boolean[]{false};
        final SynchronizingCorrelator correlator = new SynchronizingCorrelator();
        boolean consumed = correlator.put((Object)"eike", (Object)true, 50L);
        SynchronizingCorrelatorTest.msg("Consumed: " + consumed);
        SynchronizingCorrelatorTest.assertEquals((boolean)false, (boolean)consumed);
        Thread consumer = new Thread(){

            public void run() {
                ISynchronizer eike = correlator.correlate((Object)"eike");
                result[0] = (Boolean)eike.get(5000L);
                SynchronizingCorrelatorTest.msg("RESULT: " + result[0]);
            }
        };
        consumer.start();
        Thread.sleep(10L);
        consumer.join(1000L);
        SynchronizingCorrelatorTest.assertEquals(Boolean.TRUE, result[0]);
    }

    public void testBlockingPutProducerFirst10() throws Exception {
        int i = 0;
        while (i < 10) {
            this.testBlockingPutProducerFirst();
            ++i;
        }
    }
}

