/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.tests;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.concurrent.ThreadPool;
import org.eclipse.net4j.util.tests.AbstractOMTest;

public class ThreadPoolTest
extends AbstractOMTest {
    public void testExceedMaximumPoolSize() throws Exception {
        final ThreadPool pool = ThreadPool.create((String)"test", (int)10, (int)20, (long)60L);
        try {
            int tasks = pool.getMaximumPoolSize() + 100;
            final CountDownLatch latch = new CountDownLatch(tasks);
            int i = 0;
            while (i < tasks) {
                final int n = i++;
                ThreadPoolTest.msg("scheduling " + n);
                pool.execute(new Runnable(){

                    public void run() {
                        ThreadPoolTest.msg("started " + n + " (wc=" + pool.getPoolSize() + ")");
                        ConcurrencyUtil.sleep((long)1000L);
                        latch.countDown();
                    }
                });
            }
            latch.await(15000L, TimeUnit.MILLISECONDS);
            ThreadPoolTest.msg("FINISHED with largest pool size = " + pool.getLargestPoolSize());
        }
        finally {
            pool.shutdownNow();
        }
    }

    public void testWithKeepAlive() throws Exception {
        this.runTest(1000L);
    }

    public void testWithoutKeepAlive() throws Exception {
        this.runTest(0L);
    }

    private void runTest(long keepAliveTime) {
        TaskManager taskManager = new TaskManager(10, 20, keepAliveTime);
        int max = taskManager.getMaximumPoolSize();
        int extra = 10;
        int count = max + 10;
        int run = 0;
        while (run < 10) {
            System.out.println("RUN " + (run + 1));
            TaskManager.Task[] tasks = taskManager.createTasks(count);
            ThreadPoolTest.assertEquals((int)count, (int)taskManager.getCreatedTasks());
            ThreadPoolTest.assertEquals((int)0, (int)taskManager.getScheduledTasks());
            ThreadPoolTest.assertEquals((int)0, (int)taskManager.getCurrentlyEnqueuedTasks());
            ThreadPoolTest.assertEquals((int)0, (int)taskManager.getFinishedTasks());
            taskManager.schedule(tasks, 0, count);
            ThreadPoolTest.assertEquals((int)count, (int)taskManager.getScheduledTasks());
            ThreadPoolTest.sleep(20L);
            ThreadPoolTest.assertEquals((int)max, (int)taskManager.getStartedTasks());
            ThreadPoolTest.assertEquals((int)0, (int)taskManager.getFinishedTasks());
            ThreadPoolTest.assertEquals((int)extra, (int)taskManager.getCurrentlyEnqueuedTasks());
            int i = 1;
            while (i <= extra) {
                tasks[i - 1].finish();
                ThreadPoolTest.sleep(10L);
                ThreadPoolTest.assertEquals((int)(max + i), (int)taskManager.getStartedTasks());
                ThreadPoolTest.assertEquals((int)i, (int)taskManager.getFinishedTasks());
                ThreadPoolTest.assertEquals((int)(extra - i), (int)taskManager.getCurrentlyEnqueuedTasks());
                ++i;
            }
            ThreadPoolTest.assertEquals((int)count, (int)taskManager.getStartedTasks());
            ThreadPoolTest.assertEquals((int)extra, (int)taskManager.getFinishedTasks());
            ThreadPoolTest.assertEquals((int)0, (int)taskManager.getCurrentlyEnqueuedTasks());
            i = extra;
            while (i < count) {
                tasks[i].finish();
                ++i;
            }
            ThreadPoolTest.sleep(20L);
            ThreadPoolTest.assertEquals((int)count, (int)taskManager.getStartedTasks());
            ThreadPoolTest.assertEquals((int)count, (int)taskManager.getFinishedTasks());
            ThreadPoolTest.assertEquals((int)0, (int)taskManager.getCurrentlyEnqueuedTasks());
            taskManager.resetStatistics();
            ++run;
        }
    }

    public static class TaskManager
    extends ThreadPool {
        private final AtomicInteger createdTasks = new AtomicInteger();
        private final AtomicInteger scheduledTasks = new AtomicInteger();
        private final AtomicInteger startedTasks = new AtomicInteger();
        private final AtomicInteger finishedTasks = new AtomicInteger();

        public TaskManager(int corePoolSize, int maximumPoolSize, long keepAliveTime) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, TaskManager.createThreadFactory());
        }

        public int getCreatedTasks() {
            return this.createdTasks.get();
        }

        public int getScheduledTasks() {
            return this.scheduledTasks.get();
        }

        public int getStartedTasks() {
            return this.startedTasks.get();
        }

        public int getFinishedTasks() {
            return this.finishedTasks.get();
        }

        public int getCurrentlyEnqueuedTasks() {
            return this.getQueue().size();
        }

        public int getInactiveWorkers() {
            return this.getPoolSize() - this.getActiveCount();
        }

        public void resetStatistics() {
            this.createdTasks.set(0);
            this.scheduledTasks.set(0);
            this.startedTasks.set(0);
            this.finishedTasks.set(0);
        }

        public Task[] createTasks(int count) {
            Task[] result = new Task[count];
            int i = 0;
            while (i < result.length) {
                result[i] = new Task(this, i + 1);
                ++i;
            }
            return result;
        }

        public void schedule(Task[] tasks, int start, int end) {
            int i = start;
            while (i < end) {
                Task task = tasks[i];
                this.execute(task);
                ++i;
            }
        }

        public void execute(Runnable command) {
            this.scheduledTasks.incrementAndGet();
            super.execute(command);
        }

        private static ThreadFactory createThreadFactory() {
            final ThreadFactory factory = Executors.defaultThreadFactory();
            return new ThreadFactory(){

                public Thread newThread(Runnable task) {
                    System.out.println("Creating new worker");
                    return factory.newThread(task);
                }
            };
        }

        public static class Task
        extends CountDownLatch
        implements Runnable {
            private final TaskManager manager;
            private final int id;
            private AtomicBoolean used = new AtomicBoolean();

            public Task(TaskManager manager, int id) {
                super(1);
                this.manager = manager;
                this.id = id;
                manager.createdTasks.incrementAndGet();
            }

            public final void finish() {
                this.countDown();
            }

            public final void run() {
                if (!this.used.compareAndSet(false, true)) {
                    throw new IllegalStateException(this + " has already been used");
                }
                this.manager.startedTasks.incrementAndGet();
                System.out.println("Running " + this);
                try {
                    this.await();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                System.out.println("Finished " + this);
                this.manager.finishedTasks.incrementAndGet();
            }

            public String toString() {
                return "Task " + this.id;
            }
        }
    }
}

