/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.tests;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Timer {
    private long sum;
    private long start;

    public Timer() {
        this.start();
    }

    public void start() {
        this.start = System.nanoTime();
    }

    public void stop() {
        if (this.start > 0L) {
            long nanos = System.nanoTime() - this.start;
            this.sum += nanos;
            this.start = 0L;
        }
    }

    public void done() {
        this.done(TimeUnit.NANOSECONDS);
    }

    public void done(TimeUnit timeUnit) {
        this.stop();
        long converted = timeUnit.convert(this.sum, TimeUnit.NANOSECONDS);
        System.out.println(converted);
    }

    public static <T> T execute(Callable<T> callable) throws Exception {
        return Timer.execute(TimeUnit.NANOSECONDS, callable);
    }

    public static <T> T execute(TimeUnit timeUnit, Callable<T> callable) throws Exception {
        Timer timer = new Timer();
        try {
            T t = callable.call();
            return t;
        }
        finally {
            timer.done(timeUnit);
        }
    }
}

