/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.examples.transfer;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.examples.transfer.UploadProtocol;
import org.eclipse.net4j.internal.examples.bundle.OM;
import org.eclipse.net4j.signal.RequestWithMonitoring;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.om.monitor.EclipseMonitor;
import org.eclipse.net4j.util.om.monitor.MonitorCanceledException;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class UploadSSLClientAction
implements IWorkbenchWindowActionDelegate,
UploadProtocol {
    private IWorkbenchWindow window;

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(IAction action) {
        FileDialog fileDialog = new FileDialog(this.window.getShell());
        final String path = fileDialog.open();
        if (path != null) {
            final File file = new File(path);
            new Job("Uploading file"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        boolean replaced = UploadSSLClientAction.this.transferFile(file, monitor);
                        OM.LOG.info("File " + path + (replaced ? " replaced" : " stored") + " on the Net4j server.");
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    catch (MonitorCanceledException ex) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    catch (Exception ex) {
                        Status status = new Status(4, "org.eclipse.net4j.examples", "Problem with upload of " + path, (Throwable)ex);
                        return status;
                    }
                    finally {
                        monitor.done();
                    }
                }
            }.schedule();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    private boolean transferFile(File file, IProgressMonitor monitor) throws Exception {
        SignalProtocol protocol = null;
        try {
            IConnector connector = Net4jUtil.getConnector((IManagedContainer)IPluginContainer.INSTANCE, (String)"ssl", (String)"localhost:2036");
            protocol = new SignalProtocol("upload");
            protocol.open(connector);
            UploadRequest request = new UploadRequest(protocol, file);
            boolean bl = (Boolean)request.send(EclipseMonitor.safe((IProgressMonitor)monitor));
            return bl;
        }
        finally {
            protocol.close();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class UploadRequest
    extends RequestWithMonitoring<Boolean> {
        private File file;

        public UploadRequest(SignalProtocol<?> protocol, File file) {
            super(protocol, (short)1);
            this.file = file;
        }

        protected void requesting(ExtendedDataOutputStream out, OMMonitor monitor) throws Exception {
            long size = this.file.length();
            out.writeLong(size);
            out.writeString(this.file.getName());
            monitor.begin((double)((int)size));
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(this.file));
                while (size != 0L) {
                    int chunk = 8192;
                    if (size < 8192L) {
                        chunk = (int)size;
                    }
                    byte[] buffer = new byte[chunk];
                    in.read(buffer);
                    out.writeByteArray(buffer);
                    monitor.worked((double)chunk);
                    size -= (long)chunk;
                }
            }
            finally {
                monitor.done();
                in.close();
            }
        }

        protected Boolean confirming(ExtendedDataInputStream in, OMMonitor monitor) throws Exception {
            return in.readBoolean();
        }
    }
}

