/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.jms.internal.server;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.net4j.jms.internal.server.Server;
import org.eclipse.net4j.jms.internal.server.ServerSession;
import org.eclipse.net4j.jms.internal.server.protocol.JMSServerProtocol;
import org.eclipse.net4j.jms.server.IConnection;

public class ServerConnection
implements IConnection {
    private Server server;
    private String userName;
    private List<ServerSession> sessions = new ArrayList<ServerSession>(0);
    private JMSServerProtocol protocol;

    public ServerConnection(Server server, String userName) {
        this.server = server;
        this.userName = userName;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    public JMSServerProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(JMSServerProtocol protocol) {
        this.protocol = protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerSession openSession(int sessionID) {
        ServerSession session = new ServerSession(this, sessionID);
        List<ServerSession> list = this.sessions;
        synchronized (list) {
            while (sessionID >= this.sessions.size()) {
                this.sessions.add(null);
            }
            this.sessions.set(sessionID, session);
        }
        return session;
    }

    @Override
    public ServerSession getSession(int sessionID) {
        return this.sessions.get(sessionID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSession[] getSessions() {
        ArrayList<ServerSession> result = new ArrayList<ServerSession>(this.sessions.size());
        List<ServerSession> list = this.sessions;
        synchronized (list) {
            for (ServerSession session : this.sessions) {
                if (session == null) continue;
                result.add(session);
            }
        }
        return result.toArray(new ServerSession[result.size()]);
    }

    public void close() {
        this.protocol.getChannel().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeSession(ServerSession session) {
        List<ServerSession> list = this.sessions;
        synchronized (list) {
            block4: {
                int sessionID = session.getID();
                if (this.sessions.get(sessionID) != session) break block4;
                this.sessions.set(sessionID, null);
                return true;
            }
            return false;
        }
    }
}

