/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.db;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.db.CDODBUtil;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.db.mapping.ITypeMapping;
import org.eclipse.emf.cdo.server.internal.db.mapping.TypeMappingRegistry;
import org.eclipse.emf.cdo.tests.config.impl.RepositoryConfig;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;

public abstract class DBConfig
extends RepositoryConfig {
    public static final String CAPABILITY = "DB";
    public static final String CAPABILITY_RANGES = "DB.ranges";
    public static final String CAPABILITY_COPY_ON_BRANCH = "DB.copy.on.branch";
    public static final String CAPABILITY_INVERSE_LISTS = "DB.inverse.lists";
    public static final String PROP_TEST_MAPPING_STRATEGY = "test.repository.MappingStrategy";
    private static final long serialVersionUID = 1L;
    private boolean withRanges;
    private boolean copyOnBranch;
    private boolean inverseLists;
    private transient IDBAdapter dbAdapter;

    public DBConfig(String name) {
        super(name);
    }

    public void initCapabilities(Set<String> capabilities) {
        super.initCapabilities(capabilities);
        capabilities.add(CAPABILITY);
        capabilities.add(this.getDBAdapterName());
        if (this.withRanges()) {
            capabilities.add(CAPABILITY_RANGES);
        }
        if (this.copyOnBranch()) {
            capabilities.add(CAPABILITY_COPY_ON_BRANCH);
        }
        if (this.inverseLists()) {
            capabilities.add(CAPABILITY_INVERSE_LISTS);
        }
    }

    protected IDBAdapter getDBAdapter() {
        if (this.dbAdapter == null) {
            this.dbAdapter = this.createDBAdapter();
        }
        return this.dbAdapter;
    }

    protected abstract String getDBAdapterName();

    protected String getStoreName() {
        return CAPABILITY;
    }

    public DBConfig supportingAudits(boolean supportingAudits) {
        return (DBConfig)super.supportingAudits(supportingAudits);
    }

    public DBConfig supportingBranches(boolean supportingBranches) {
        return (DBConfig)super.supportingBranches(supportingBranches);
    }

    public DBConfig supportingChunks(boolean supportingChunks) {
        return (DBConfig)super.supportingChunks(supportingChunks);
    }

    public DBConfig supportingExtRefs(boolean supportingExtRefs) {
        return (DBConfig)super.supportingExtRefs(supportingExtRefs);
    }

    public DBConfig idGenerationLocation(CDOCommonRepository.IDGenerationLocation idGenerationLocation) {
        return (DBConfig)super.idGenerationLocation(idGenerationLocation);
    }

    public boolean withRanges() {
        return this.withRanges;
    }

    public DBConfig withRanges(boolean withRanges) {
        this.withRanges = withRanges;
        return this;
    }

    public boolean copyOnBranch() {
        return this.copyOnBranch;
    }

    public DBConfig copyOnBranch(boolean copyOnBranch) {
        this.copyOnBranch = copyOnBranch;
        return this;
    }

    public boolean inverseLists() {
        return this.inverseLists;
    }

    public DBConfig inverseLists(boolean inverseLists) {
        this.inverseLists = inverseLists;
        return this;
    }

    public void setUp() throws Exception {
        CDODBUtil.prepareContainer((IManagedContainer)IPluginContainer.INSTANCE);
        super.setUp();
        ((TypeMappingRegistry)ITypeMapping.Registry.INSTANCE).init();
    }

    protected boolean isOptimizing() {
        return true;
    }

    public IStore createStore(String repoName) {
        IMappingStrategy mappingStrategy = this.createMappingStrategy();
        mappingStrategy.setProperties(this.createMappingStrategyProperties());
        IDBAdapter dbAdapter = this.getDBAdapter();
        DataSource dataSource = this.createDataSource(repoName);
        IDBConnectionProvider connectionProvider = dbAdapter.createConnectionProvider(dataSource);
        HashMap props = new HashMap();
        return CDODBUtil.createStore((IMappingStrategy)mappingStrategy, (IDBAdapter)dbAdapter, (IDBConnectionProvider)connectionProvider, props);
    }

    protected Map<String, String> createMappingStrategyProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("qualifiedNames", "true");
        props.put("forceIndexes", "XREF");
        props.put("copyOnBranch", Boolean.toString(this.copyOnBranch));
        return props;
    }

    protected IMappingStrategy createMappingStrategy() {
        IMappingStrategy mappingStrategy = this.getTestMappingStrategy();
        if (mappingStrategy != null) {
            return mappingStrategy;
        }
        return CDODBUtil.createHorizontalMappingStrategy((boolean)this.supportingAudits(), (boolean)this.supportingBranches(), (boolean)this.withRanges);
    }

    protected IMappingStrategy getTestMappingStrategy() {
        return (IMappingStrategy)this.getTestProperty(PROP_TEST_MAPPING_STRATEGY);
    }

    protected String getMappingStrategySpecialization() {
        return String.valueOf(this.withRanges ? "-ranges" : "") + (this.copyOnBranch ? "-copy" : "") + (this.inverseLists ? "-inverse" : "");
    }

    protected abstract IDBAdapter createDBAdapter();

    protected abstract DataSource createDataSource(String var1);
}

