/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.syncing;

import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.internal.server.syncing.SynchronizableRepository;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalFailoverParticipant;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;

public class FailoverParticipant
extends SynchronizableRepository
implements InternalFailoverParticipant {
    private boolean allowBackupCommits;

    @Override
    public boolean isAllowBackupCommits() {
        return this.allowBackupCommits;
    }

    @Override
    public void setAllowBackupCommits(boolean allowBackupCommits) {
        this.allowBackupCommits = allowBackupCommits;
    }

    @Override
    public void setType(CDOCommonRepository.Type type) {
        this.checkArg(type == MASTER || type == BACKUP, "Type must be MASTER or BACKUP");
        super.setType(type);
    }

    @Override
    protected void changingType(CDOCommonRepository.Type oldType, CDOCommonRepository.Type newType) {
        if (this.isActive()) {
            if (newType == MASTER) {
                this.doStopSynchronization();
                this.setState(ONLINE);
            } else {
                this.setReplicationCountersToLatest();
                this.doStartSynchronization();
            }
        }
        super.changingType(oldType, newType);
    }

    protected void doStartSynchronization() {
        super.startSynchronization();
    }

    protected void doStopSynchronization() {
        super.stopSynchronization();
    }

    @Override
    protected void startSynchronization() {
        if (this.getType() == BACKUP) {
            this.doStartSynchronization();
        }
    }

    @Override
    protected void stopSynchronization() {
        if (this.getType() == BACKUP) {
            this.doStopSynchronization();
        }
    }

    @Override
    public InternalCommitContext createCommitContext(InternalTransaction transaction) {
        if (this.getType() == BACKUP) {
            if (this.getState() != ONLINE) {
                throw new IllegalStateException("Backup repository is not online");
            }
            if (this.allowBackupCommits || transaction.getSession() == this.getReplicatorSession()) {
                return this.createWriteThroughCommitContext(transaction);
            }
            throw new IllegalStateException("Only the repository synchronizer is allowed to commit transactions to a backup repository");
        }
        return this.createNormalCommitContext(transaction);
    }
}

