/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.session.remote;

import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionEvent;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionMessage;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.IEvent;

public interface CDORemoteSessionManager
extends IContainer<CDORemoteSession> {
    public CDOSession getLocalSession();

    public CDORemoteSession[] getRemoteSessions();

    public boolean isSubscribed();

    public boolean isForceSubscription();

    public void setForceSubscription(boolean var1);

    public Set<CDORemoteSession> sendMessage(CDORemoteSessionMessage var1, CDORemoteSession ... var2);

    public Set<CDORemoteSession> sendMessage(CDORemoteSessionMessage var1, Collection<CDORemoteSession> var2);

    public static class EventAdapter
    extends ContainerEventAdapter<CDORemoteSession> {
        protected void onLocalSubscriptionChanged(boolean subscribed) {
        }

        protected void onOpened(CDORemoteSession remoteSession) {
        }

        protected void onClosed(CDORemoteSession remoteSession) {
        }

        protected void onSubscribed(CDORemoteSession remoteSession) {
        }

        protected void onUnsubscribed(CDORemoteSession remoteSession) {
        }

        protected void onMessageReceived(CDORemoteSession remoteSession, CDORemoteSessionMessage message) {
        }

        protected void notifyOtherEvent(IEvent event) {
            if (event instanceof LocalSubscriptionChangedEvent) {
                LocalSubscriptionChangedEvent e = (LocalSubscriptionChangedEvent)event;
                this.onLocalSubscriptionChanged(e.isSubscribed());
            } else if (event instanceof CDORemoteSessionEvent.SubscriptionChanged) {
                CDORemoteSessionEvent.SubscriptionChanged e = (CDORemoteSessionEvent.SubscriptionChanged)event;
                if (e.isSubscribed()) {
                    this.onSubscribed(e.getRemoteSession());
                } else {
                    this.onUnsubscribed(e.getRemoteSession());
                }
            } else if (event instanceof CDORemoteSessionEvent.MessageReceived) {
                CDORemoteSessionEvent.MessageReceived e = (CDORemoteSessionEvent.MessageReceived)event;
                this.onMessageReceived(e.getRemoteSession(), e.getMessage());
            } else {
                super.notifyOtherEvent(event);
            }
        }

        protected final void onAdded(IContainer<CDORemoteSession> container, CDORemoteSession element) {
            this.onOpened(element);
        }

        protected final void onRemoved(IContainer<CDORemoteSession> container, CDORemoteSession element) {
            this.onClosed(element);
        }
    }

    public static interface LocalSubscriptionChangedEvent
    extends IEvent {
        public CDORemoteSessionManager getSource();

        public boolean isSubscribed();
    }
}

