/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.tests.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.sql.DataSource;
import oracle.jdbc.pool.OracleDataSource;
import org.eclipse.emf.cdo.tests.db.AbstractSetupDBConfig;
import org.eclipse.emf.cdo.tests.db.bundle.OM;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.oracle.OracleAdapter;
import org.eclipse.net4j.util.tests.AbstractOMTest;

public abstract class OracleConfig
extends AbstractSetupDBConfig {
    public static final String DB_ADAPTER_NAME = "oracle";
    private static final String DRIVER_TYPE = System.getProperty("test.oracle.drivertype", "thin");
    private static final String SERVER_NAME = System.getProperty("test.oracle.servername", "localhost");
    private static final int PORT_NUMBER = Integer.getInteger("test.oracle.portnumber", 1521);
    private static final String DATABASE_NAME = System.getProperty("test.oracle.databasename", "TEST");
    private static final String USER = System.getProperty("test.oracle.user", "cdotest");
    private static final String PASSWORD = System.getProperty("test.oracle.password", "oracle");
    private static final long serialVersionUID = 1L;

    public OracleConfig() {
        super(DB_ADAPTER_NAME);
    }

    @Override
    protected String getDBAdapterName() {
        return DB_ADAPTER_NAME;
    }

    @Override
    protected IDBAdapter createDBAdapter() {
        return new OracleAdapter();
    }

    protected void initRepositoryProperties(Map<String, String> props) {
        super.initRepositoryProperties(props);
        props.put("connectionKeepAlivePeriod", "5");
        props.put("readerPoolCapacity", "5");
        props.put("writerPoolCapacity", "5");
    }

    protected String getUserName(String dbName) {
        return USER;
    }

    @Override
    protected DataSource createDataSourceForDB(String dbName) throws SQLException {
        String userName = this.getUserName(dbName);
        return OracleConfig.createDataSourceForUser(userName);
    }

    public static OracleDataSource createDataSourceForUser(String userName) throws SQLException {
        OracleDataSource dataSource = new OracleDataSource();
        dataSource.setDriverType(DRIVER_TYPE);
        dataSource.setServerName(SERVER_NAME);
        dataSource.setPortNumber(PORT_NUMBER);
        dataSource.setDatabaseName(DATABASE_NAME);
        dataSource.setUser(userName);
        dataSource.setPassword(PASSWORD);
        return dataSource;
    }

    public static class MultiUser
    extends OracleConfig {
        private static final long serialVersionUID = 1L;

        @Override
        protected void initDatabase(Connection connection, Statement stmt, String dbName) throws SQLException {
            String userName = this.getUserName(dbName);
            stmt.execute("CREATE USER " + userName + " IDENTIFIED BY oracle");
            stmt.execute("GRANT DBA TO " + userName);
        }

        @Override
        protected void dropDatabase(Connection connection, Statement stmt, String dbName) throws SQLException {
            String userName = this.getUserName(dbName);
            stmt.execute("DROP USER " + userName + " CASCADE");
        }

        @Override
        protected String getUserName(String dbName) {
            if (dbName == null) {
                return USER;
            }
            return dbName;
        }
    }

    public static class SingleUser
    extends OracleConfig {
        private static final long serialVersionUID = 1L;

        @Override
        protected void initDatabase(String dbName) {
            if (!this.getDBName("repo1").equals(dbName)) {
                OM.LOG.info("Skipping database " + dbName + " in " + this.getCurrentTest());
                AbstractOMTest.skipTest();
            }
            super.initDatabase(dbName);
        }

        @Override
        protected void dropDatabase(Connection connection, Statement stmt, String dbName) throws SQLException {
            OM.LOG.info("Dropping all tables...");
            DBUtil.dropAllTables((Connection)connection, null);
        }
    }
}

