/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui;

import java.util.Objects;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.swt.graphics.Image;

public interface CDOTopicProvider {
    public Topic[] getTopics();

    public void addTopicListener(Listener var1);

    public void removeTopicListener(Listener var1);

    public static interface Listener {
        public void topicAdded(CDOTopicProvider var1, Topic var2);

        public void topicRemoved(CDOTopicProvider var1, Topic var2);
    }

    public static final class Topic {
        private final CDOSession session;
        private final String id;
        private final Image image;
        private final String text;
        private final String description;

        public Topic(CDOSession session, String id, Image image, String text, String description) {
            this.session = session;
            this.id = id;
            this.image = image;
            this.text = text;
            this.description = description;
        }

        public CDOSession getSession() {
            return this.session;
        }

        public String getId() {
            return this.id;
        }

        public Image getImage() {
            return this.image;
        }

        public String getText() {
            return this.text;
        }

        public String getDescription() {
            return this.description;
        }

        public int hashCode() {
            return Objects.hash(this.session, this.id);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Topic other = (Topic)obj;
            return Objects.equals(this.session, other.session) && Objects.equals(this.id, other.id);
        }

        public String toString() {
            String string = String.valueOf(this.session.getRepositoryInfo().getName()) + "/" + this.id;
            String userID = this.session.getUserID();
            if (!StringUtil.isEmpty((String)userID)) {
                string = String.valueOf(userID) + "@" + string;
            }
            return string;
        }
    }
}

