/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer.resources;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.internal.explorer.bundle.OM;
import org.eclipse.emf.cdo.internal.explorer.resources.CDOCheckoutFileStore;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.om.OMPlatform;

public class CDOCheckoutFileSystem
extends FileSystem {
    public static final String SCHEME = "cdo.checkout";
    public static final String PARAM_TIME_STAMPS = "timeStamps";
    public static final String TIME_STAMPS_SHALLOW = "shallow";
    public static final String TIME_STAMPS_DEEP = "deep";
    private static final boolean OMIT_CHECKOUT_FILE_SYSTEM = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.explorer.omitCheckoutFileSystem");

    public IFileStore getStore(URI uri) {
        if (!OMIT_CHECKOUT_FILE_SYSTEM) {
            try {
                String authority;
                CDOCheckout checkout;
                String scheme = uri.getScheme();
                if (SCHEME.equals(scheme) && (checkout = CDOExplorerUtil.getCheckout(authority = uri.getAuthority())) != null) {
                    String path = uri.getPath();
                    boolean shallowTimeStamp = CDOCheckoutFileSystem.isShallowTimeStamps(uri);
                    return this.createFileStore(checkout, path, shallowTimeStamp);
                }
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
        return EFS.getNullFileSystem().getStore(uri);
    }

    protected CDOCheckoutFileStore createFileStore(CDOCheckout checkout, String path, boolean shallowTimeStamp) {
        return new CDOCheckoutFileStore(checkout, path, shallowTimeStamp);
    }

    private static boolean isShallowTimeStamps(URI uri) {
        Map parameters = CDOURIUtil.getParameters((String)uri.getQuery());
        String parameter = (String)parameters.get(PARAM_TIME_STAMPS);
        return TIME_STAMPS_SHALLOW.equalsIgnoreCase(parameter);
    }

    public static URI createURI(CDOCheckout checkout, String path, boolean shallowTimeStamp) {
        try {
            String authority = checkout.getID();
            String query = shallowTimeStamp ? "timeStamps=shallow" : null;
            return new URI(SCHEME, authority, path, query, null);
        }
        catch (URISyntaxException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }
}

