/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.concurrent.ExecutorService;
import org.eclipse.net4j.util.concurrent.ThreadPool;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleException;
import org.eclipse.net4j.util.lifecycle.LifecycleState;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;

public class ExecutorServiceFactory
extends Factory {
    public static final String DEFAULT_THREAD_GROUP_NAME = "net4j";
    public static final String PRODUCT_GROUP = "org.eclipse.net4j.executorServices";
    @Deprecated
    public static final String TYPE = "default";
    private static final String DEFAULT_TYPE = OMPlatform.INSTANCE.getProperty("org.eclipse.net4j.util.concurrent.ExecutorServiceFactory.type", "default");
    private static final String DEFAULT_DESCRIPTION = OMPlatform.INSTANCE.getProperty("org.eclipse.net4j.util.concurrent.ExecutorServiceFactory.description");

    public ExecutorServiceFactory() {
        super(PRODUCT_GROUP, DEFAULT_TYPE);
    }

    @Override
    public ExecutorService create(String description) {
        final ThreadPool executorService = ThreadPool.create(description);
        return LifecycleUtil.delegateLifecycle(this.getClass().getClassLoader(), executorService, ExecutorService.class, new ILifecycle(){
            private boolean active;

            @Override
            public void activate() throws LifecycleException {
                this.active = true;
            }

            @Override
            public Exception deactivate() {
                try {
                    executorService.shutdown();
                    this.active = false;
                    return null;
                }
                catch (Exception ex) {
                    return ex;
                }
            }

            @Override
            public LifecycleState getLifecycleState() {
                return this.active ? LifecycleState.ACTIVE : LifecycleState.INACTIVE;
            }

            @Override
            public boolean isActive() {
                return this.active;
            }

            @Override
            public void addListener(IListener listener) {
            }

            @Override
            public void removeListener(IListener listener) {
            }

            @Override
            public IListener[] getListeners() {
                return EventUtil.NO_LISTENERS;
            }

            @Override
            public boolean hasListeners() {
                return false;
            }

            public String toString() {
                return "CachedThreadPool";
            }
        });
    }

    public static ExecutorService get(IManagedContainer container) {
        return (ExecutorService)container.getElement(PRODUCT_GROUP, DEFAULT_TYPE, DEFAULT_DESCRIPTION);
    }
}

