/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.jms.internal.admin;

import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.jms.admin.IJMSAdmin;
import org.eclipse.net4j.jms.internal.admin.bundle.OM;
import org.eclipse.net4j.jms.internal.admin.protocol.JMSAdminProtocol;
import org.eclipse.net4j.jms.internal.admin.protocol.JMSCreateDestinationRequest;

public class JMSAdmin
implements IJMSAdmin {
    private JMSAdminProtocol protocol;

    public JMSAdmin(IConnector connector) {
        this.protocol = new JMSAdminProtocol(connector);
    }

    @Override
    public void close() {
        this.protocol.close();
        this.protocol = null;
    }

    @Override
    public boolean createQueue(String name) {
        return this.createDestination(name, (byte)1);
    }

    @Override
    public boolean createTopic(String name) {
        return this.createDestination(name, (byte)2);
    }

    private boolean createDestination(String name, byte type) {
        try {
            return (Boolean)new JMSCreateDestinationRequest(this.protocol, type, name).send();
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
            return false;
        }
    }
}

