/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.lm.ui.bundle.OM;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.actions.LongRunningAction;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public abstract class LMAction<CONTEXT extends CDOObject>
extends LongRunningAction {
    private final String bannerMessage;
    private final String bannerImagePath;
    private Image bannerImage;
    private LMDialog dialog;
    private final CONTEXT context;

    public LMAction(IWorkbenchPage page, String text, String toolTipText, ImageDescriptor image, String bannerMessage, String bannerImagePath, CONTEXT context) {
        super(page, text, toolTipText, image);
        this.bannerImagePath = bannerImagePath;
        this.bannerMessage = bannerMessage;
        this.context = context;
    }

    public CONTEXT getContext() {
        return this.context;
    }

    protected void preRun() throws Exception {
        LMDialog dialog;
        if (this.isDialogNeeded() && (dialog = new LMDialog(this.getShell())).open() == 1) {
            this.cancel();
        }
    }

    protected final void doRun(IProgressMonitor monitor) throws Exception {
        this.doRun(this.context, monitor);
    }

    protected abstract void doRun(CONTEXT var1, IProgressMonitor var2) throws Exception;

    protected Point getInitialSize(LMDialog dialog) {
        return dialog._getInitialSize();
    }

    protected Point getInitialLocation(LMDialog dialog, Point initialSize) {
        return dialog._getInitialLocation(initialSize);
    }

    protected void configureShell(LMDialog dialog, Shell newShell) {
        dialog._configureShell(newShell);
    }

    protected Image getBannerImage(LMDialog dialog) {
        if (this.bannerImage == null && this.bannerImagePath != null) {
            ImageDescriptor descriptor = this.getImageDescriptor(this.bannerImagePath);
            this.bannerImage = descriptor.createImage((Device)this.getDisplay());
        }
        return this.bannerImage;
    }

    protected ImageDescriptor getImageDescriptor(String imagePath) {
        return OM.Activator.INSTANCE.loadImageDescriptor(imagePath);
    }

    protected boolean isDialogNeeded() {
        return true;
    }

    protected abstract void fillDialogArea(LMDialog var1, Composite var2);

    protected final Button newCheckBox(Composite parent, String text) {
        new Label(parent, 0);
        Button checkBox = new Button(parent, 32);
        checkBox.setText(text);
        checkBox.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 0x1000000).create());
        return checkBox;
    }

    protected final void openError(String message) {
        MessageDialog.openError((Shell)this.getShell(), (String)"Lifecycle Management", (String)message);
    }

    private final void validateDialog(boolean withMessage) {
        if (this.dialog != null) {
            String errorMessage = this.doValidate(this.dialog);
            if (errorMessage != null) {
                if (withMessage) {
                    this.dialog.setErrorMessage(errorMessage);
                }
                this.enableOkButton(false);
            } else {
                this.dialog.setErrorMessage(null);
                this.enableOkButton(true);
            }
        }
    }

    protected final void validateDialog() {
        this.validateDialog(true);
    }

    protected String doValidate(LMDialog dialog) {
        return null;
    }

    protected void dialogClosed(LMDialog dialog) {
        if (this.bannerImage != null) {
            this.bannerImage.dispose();
        }
    }

    private void enableOkButton(boolean enabled) {
        Button okButton = this.dialog.getOkButton();
        if (okButton != null) {
            okButton.setEnabled(enabled);
        } else {
            UIUtil.asyncExec((Display)this.getDisplay(), () -> {
                Button button = this.dialog.getOkButton();
                if (button != null && !button.isDisposed()) {
                    button.setEnabled(enabled);
                }
            });
        }
    }

    protected class LMDialog
    extends TitleAreaDialog {
        protected LMDialog(Shell parentShell) {
            super(parentShell);
            LMAction.this.dialog = this;
        }

        protected Point getInitialSize() {
            return LMAction.this.getInitialSize(this);
        }

        protected Point getInitialLocation(Point initialSize) {
            return LMAction.this.getInitialLocation(this, initialSize);
        }

        protected boolean isResizable() {
            return true;
        }

        protected void configureShell(Shell newShell) {
            LMAction.this.configureShell(this, newShell);
        }

        protected Control createDialogArea(Composite parent) {
            Shell shell = this.getShell();
            shell.setText("Lifecycle Management");
            String text = LMAction.this.getText();
            if (text.endsWith(INTERACTIVE)) {
                text = text.substring(0, text.length() - INTERACTIVE.length());
            }
            this.setTitle(text);
            Image image = LMAction.this.getBannerImage(this);
            if (image != null) {
                this.setTitleImage(image);
            }
            if (LMAction.this.bannerMessage != null) {
                this.setMessage(LMAction.this.bannerMessage);
            }
            Composite area = (Composite)super.createDialogArea(parent);
            Composite composite = new Composite(area, 0);
            composite.setLayoutData((Object)new GridData(1808));
            composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).margins(10, 10).create());
            LMAction.this.fillDialogArea(this, composite);
            UIUtil.asyncExec((Display)shell.getDisplay(), () -> LMAction.this.validateDialog(false));
            return area;
        }

        public Button getOkButton() {
            return this.getButton(0);
        }

        public boolean close() {
            LMAction.this.dialogClosed(this);
            LMAction.this.dialog = null;
            return super.close();
        }

        private Point _getInitialSize() {
            return super.getInitialSize();
        }

        private Point _getInitialLocation(Point initialSize) {
            return super.getInitialLocation(initialSize);
        }

        private void _configureShell(Shell newShell) {
            super.configureShell(newShell);
        }
    }

    public static abstract class NewElement<CONTEXT extends CDOObject>
    extends LMAction<CONTEXT> {
        private final StructuredViewer viewer;

        public NewElement(IWorkbenchPage page, StructuredViewer viewer, String text, String toolTipText, ImageDescriptor image, String bannerMessage, String bannerImagePath, CONTEXT context) {
            super(page, text, toolTipText, image, bannerMessage, bannerImagePath, context);
            this.viewer = viewer;
        }

        @Override
        protected final void doRun(CONTEXT context, IProgressMonitor monitor) throws Exception {
            CDOObject element = this.newElement(context, monitor);
            if (element != null) {
                UIUtil.asyncExec(() -> this.viewer.setSelection((ISelection)new StructuredSelection((Object)element)));
            }
        }

        protected abstract CDOObject newElement(CONTEXT var1, IProgressMonitor var2) throws Exception;
    }
}

