/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SequenceDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.shared.common.error.StandardException;

class DropSequenceNode
extends DDLStatementNode {
    private TableName dropItem;

    DropSequenceNode(TableName dropSequenceName, ContextManager cm) {
        super(dropSequenceName, cm);
        this.dropItem = dropSequenceName;
    }

    @Override
    public String statementToString() {
        return "DROP ".concat(this.dropItem.getTableName());
    }

    @Override
    public void bindStatement() throws StandardException {
        DataDictionary dataDictionary = this.getDataDictionary();
        String sequenceName = this.getRelativeName();
        SequenceDescriptor seqDesc = null;
        SchemaDescriptor sd = this.getSchemaDescriptor();
        if (sd.getUUID() != null) {
            seqDesc = dataDictionary.getSequenceDescriptor(sd, sequenceName);
        }
        if (seqDesc == null) {
            throw StandardException.newException("42Y55", this.statementToString(), sequenceName);
        }
        this.getCompilerContext().createDependency(seqDesc);
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropSequenceConstantAction(this.getSchemaDescriptor(), this.getRelativeName());
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.dropItem != null) {
            this.dropItem = (TableName)this.dropItem.accept(v);
        }
    }
}

