/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import java.io.IOException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOObjectHistory;
import org.eclipse.emf.cdo.CDOObjectReference;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitHistory;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDExternal;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.id.CDOWithID;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.model.CDOClassifierRef;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionData;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.common.util.CDOResourceNodeNotFoundException;
import org.eclipse.emf.cdo.eresource.CDOBinaryResource;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.CDOTextResource;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceImpl;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceNodeImpl;
import org.eclipse.emf.cdo.internal.common.commit.CDOCommitHistoryProviderImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORevisionDeltaImpl;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.DanglingReferenceException;
import org.eclipse.emf.cdo.util.InvalidURIException;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.eclipse.emf.cdo.util.ReadOnlyException;
import org.eclipse.emf.cdo.view.CDOAdapterPolicy;
import org.eclipse.emf.cdo.view.CDOObjectHandler;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.emf.cdo.view.CDORegistrationHandler;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewAdaptersNotifiedEvent;
import org.eclipse.emf.cdo.view.CDOViewEvent;
import org.eclipse.emf.cdo.view.CDOViewProvider;
import org.eclipse.emf.cdo.view.CDOViewProviderChangedEvent;
import org.eclipse.emf.cdo.view.CDOViewTargetChangedEvent;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.object.CDOLegacyAdapter;
import org.eclipse.emf.internal.cdo.query.CDOQueryImpl;
import org.eclipse.emf.internal.cdo.view.CDOObjectHistoryImpl;
import org.eclipse.emf.internal.cdo.view.CDOStateMachine;
import org.eclipse.emf.internal.cdo.view.CDOStoreImpl;
import org.eclipse.emf.internal.cdo.view.CDOURIHandler;
import org.eclipse.emf.spi.cdo.CDOStore;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.emf.spi.cdo.InternalCDOViewSet;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.AbstractCloseableIterator;
import org.eclipse.net4j.util.collection.CloseableIterator;
import org.eclipse.net4j.util.collection.ConcurrentArray;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.concurrent.DelegableReentrantLock;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.container.IContainerDelta;
import org.eclipse.net4j.util.container.SelfAttachingContainerListener;
import org.eclipse.net4j.util.container.SingleDeltaContainerEvent;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.lifecycle.LifecycleException;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.log.OMLogger;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.net4j.util.ref.ReferenceType;
import org.eclipse.net4j.util.ref.ReferenceValueMap2;
import org.eclipse.net4j.util.registry.HashMapRegistry;
import org.eclipse.net4j.util.registry.IRegistry;

public abstract class AbstractCDOView
extends CDOCommitHistoryProviderImpl<CDOObject, CDOObjectHistory>
implements InternalCDOView,
SelfAttachingContainerListener.DoNotDescend {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_VIEW, AbstractCDOView.class);
    private static final String REPOSITORY_NAME_KEY = "cdo.repository.name";
    private static final String SAFE_RENAME = "~renamed";
    private static final Set<String> LEGACY_MODELS = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.view.REPORT_LEGACY_MODELS") ? Collections.synchronizedSet(new HashSet()) : null;
    private static final ThreadLocal<Lock> NEXT_VIEW_LOCK = new ThreadLocal();
    private final InternalCDOView.ViewAndState[] viewAndStates = InternalCDOView.ViewAndState.create(this);
    private final CDOURIHandler uriHandler = new CDOURIHandler(this);
    protected final Lock viewLock;
    protected final Condition viewLockCondition;
    private final BranchPointLock branchPointLock = new BranchPointLock();
    private CDOBranchPoint branchPoint;
    private CDOBranchPoint normalizedBranchPoint;
    private URI uri;
    private CDOViewProvider provider;
    private InternalCDOViewSet viewSet;
    private Map<CDOID, InternalCDOObject> objects;
    private int objectCreationCounter;
    private CDOStore store = new CDOStoreImpl(this);
    private CDOResourceImpl rootResource;
    private CDOID rootResourceID;
    private final ConcurrentArray<CDOObjectHandler> objectHandlers = new ConcurrentArray<CDOObjectHandler>(){

        protected CDOObjectHandler[] newArray(int length) {
            return new CDOObjectHandler[length];
        }
    };
    private final ConcurrentArray<CDORegistrationHandler> registrationHandlers = new ConcurrentArray<CDORegistrationHandler>(){

        protected CDORegistrationHandler[] newArray(int length) {
            return new CDORegistrationHandler[length];
        }
    };
    private final IRegistry<String, Object> properties = new HashMapRegistry.AutoCommit();
    @ReflectUtil.ExcludeFromDump
    private transient Map<String, CDOID> resourcePathCache = new HashMap<String, CDOID>();
    @ReflectUtil.ExcludeFromDump
    private transient CDOID lastLookupID;
    @ReflectUtil.ExcludeFromDump
    private transient InternalCDOObject lastLookupObject;
    @ReflectUtil.ExcludeFromDump
    private transient boolean bypassRegistrationHandlers;

    public AbstractCDOView(CDOSession session, CDOBranchPoint branchPoint) {
        this(session);
        if (session != null) {
            branchPoint = CDOBranchUtil.adjustBranchPoint((CDOBranchPoint)branchPoint, (CDOBranchManager)session.getBranchManager());
        }
        this.basicSetBranchPoint(branchPoint);
    }

    public AbstractCDOView(CDOSession session) {
        Lock lock = NEXT_VIEW_LOCK.get();
        if (lock != null) {
            NEXT_VIEW_LOCK.remove();
        } else if (session != null && session.options().isDelegableViewLockEnabled()) {
            lock = new DelegableReentrantLock();
        }
        this.viewLock = lock;
        this.viewLockCondition = this.viewLock != null ? this.viewLock.newCondition() : null;
        this.initObjectsMap(ReferenceType.SOFT);
    }

    public final IRegistry<String, Object> properties() {
        return this.properties;
    }

    @Override
    public String getRepositoryName() {
        Object repositoryName = this.properties.get((Object)REPOSITORY_NAME_KEY);
        if (repositoryName instanceof String) {
            return (String)repositoryName;
        }
        return this.getSession().getRepositoryInfo().getName();
    }

    @Override
    public void setRepositoryName(String repositoryName) {
        this.properties.put((Object)REPOSITORY_NAME_KEY, (Object)repositoryName);
    }

    public boolean isReadOnly() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHistorical() {
        BranchPointLock branchPointLock = this.branchPointLock;
        synchronized (branchPointLock) {
            return this.branchPoint.getTimeStamp() != 0L;
        }
    }

    @Override
    @Deprecated
    public boolean isLegacyModeEnabled() {
        return true;
    }

    protected final Map<CDOID, InternalCDOObject> getModifiableObjects() {
        return this.objects;
    }

    public int purgeUnusedObjects() {
        if (this.objects instanceof ReferenceValueMap2) {
            ReferenceValueMap2 map = (ReferenceValueMap2)this.objects;
            Method method = ReflectUtil.getMethod(ReferenceValueMap2.class, (String)"internalPurgeQueue", (Class[])new Class[0]);
            return (Integer)ReflectUtil.invokeMethod((Method)method, (Object)map, (Object[])new Object[0]);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<CDOID, InternalCDOObject> getObjects() {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                if (this.objects == null) {
                    Map<CDOID, InternalCDOObject> map = Collections.emptyMap();
                    return map;
                }
                Map<CDOID, InternalCDOObject> map = Collections.unmodifiableMap(this.objects);
                return map;
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setObjects(Map<CDOID, InternalCDOObject> objects) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                this.objects = objects;
            }
            finally {
                this.unlockView();
            }
        }
    }

    protected boolean initObjectsMap(ReferenceType referenceType) {
        Object newObjects;
        switch (referenceType) {
            case STRONG: {
                if (this.objects instanceof ReferenceValueMap2.Strong) {
                    return false;
                }
                Map map = CDOIDUtil.createMap();
                newObjects = new ReferenceValueMap2.Strong<CDOID, InternalCDOObject>(map){

                    protected void purged(CDOID id) {
                        AbstractCDOView.this.objectCollected(id);
                    }
                };
                break;
            }
            case SOFT: {
                if (this.objects instanceof ReferenceValueMap2.Soft) {
                    return false;
                }
                Map map = CDOIDUtil.createMap();
                newObjects = new ReferenceValueMap2.Soft<CDOID, InternalCDOObject>(map){

                    protected void purged(CDOID id) {
                        AbstractCDOView.this.objectCollected(id);
                    }
                };
                break;
            }
            case WEAK: {
                if (this.objects instanceof ReferenceValueMap2.Weak) {
                    return false;
                }
                Map map = CDOIDUtil.createMap();
                newObjects = new ReferenceValueMap2.Weak<CDOID, InternalCDOObject>(map){

                    protected void purged(CDOID id) {
                        AbstractCDOView.this.objectCollected(id);
                    }
                };
                break;
            }
            default: {
                throw new IllegalArgumentException(Messages.getString("CDOViewImpl.29"));
            }
        }
        if (this.objects == null) {
            this.setObjects((Map<CDOID, InternalCDOObject>)newObjects);
        } else {
            for (Map.Entry<CDOID, InternalCDOObject> entry : this.objects.entrySet()) {
                InternalCDOObject object = entry.getValue();
                if (object == null) continue;
                newObjects.put((Object)entry.getKey(), (Object)object);
            }
            Map<CDOID, InternalCDOObject> oldObjects = this.objects;
            this.setObjects((Map<CDOID, InternalCDOObject>)newObjects);
            oldObjects.clear();
        }
        return true;
    }

    @Override
    public InternalCDOView.ViewAndState getViewAndState(CDOState state) {
        return this.viewAndStates[state.ordinal()];
    }

    @Override
    public CDOStore getStore() {
        this.checkActive();
        return this.store;
    }

    @Override
    public ResourceSet getResourceSet() {
        InternalCDOViewSet viewSet = this.getViewSet();
        return viewSet == null ? null : viewSet.getResourceSet();
    }

    @Override
    public InternalCDOViewSet getViewSet() {
        return this.viewSet;
    }

    @Override
    public void setViewSet(InternalCDOViewSet viewSet) {
        this.viewSet = viewSet;
        if (viewSet != null) {
            viewSet.getResourceSet().getURIConverter().getURIHandlers().add(0, (Object)this.getURIHandler());
        }
    }

    @Override
    public final Object getViewMonitor() {
        if (this.viewLock != null) {
            return new NOOPMonitor();
        }
        return this;
    }

    @Override
    public final Lock getViewLock() {
        return this.viewLock;
    }

    @Override
    public final void lockView() {
        if (this.viewLock != null) {
            this.viewLock.lock();
        }
    }

    @Override
    public final void unlockView() {
        if (this.viewLock != null) {
            this.viewLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncExec(Runnable runnable) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                runnable.run();
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <V> V syncExec(Callable<V> callable) throws Exception {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            V v = callable.call();
            return v;
            finally {
                this.unlockView();
            }
        }
    }

    @Override
    public CDOViewProvider getProvider() {
        return this.provider;
    }

    @Override
    public void setProvider(CDOViewProvider provider) {
        CDOViewProvider oldProvider = this.provider;
        if (provider != oldProvider) {
            this.provider = provider;
            if (this.viewSet != null) {
                this.viewSet.remapView(this);
            }
            if (provider instanceof CDOViewProvider.CDOViewProvider2) {
                CDOViewProvider.CDOViewProvider2 provider2 = (CDOViewProvider.CDOViewProvider2)provider;
                this.uri = provider2.getViewURI(this);
                this.uriHandler.setViewProvider2(provider2);
            } else {
                this.uri = null;
                this.uriHandler.setViewProvider2(null);
            }
            IListener[] listeners = this.getListeners();
            if (listeners.length != 0) {
                this.fireEvent(new ViewProviderChangedEvent(oldProvider, provider), listeners);
            }
        }
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public void setSession(InternalCDOSession session) {
        this.rootResourceID = session.getRepositoryInfo().getRootResourceID();
        if (this.rootResourceID == null || this.rootResourceID.isNull()) {
            throw new IllegalStateException("RootResourceID is null; is the repository not yet initialized?");
        }
    }

    @Override
    public CDOResourceImpl getRootResource() {
        this.checkActive();
        Object object = this.getViewMonitor();
        synchronized (object) {
            CDOResourceImpl cDOResourceImpl;
            this.lockView();
            try {
                if (this.rootResource == null) {
                    this.getObject(this.rootResourceID);
                    CheckUtil.checkState((Object)this.rootResource, (String)"rootResource");
                }
                cDOResourceImpl = this.rootResource;
                this.unlockView();
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            return cDOResourceImpl;
        }
    }

    private void setRootResource(CDOResourceImpl resource) {
        this.rootResource = resource;
        this.rootResource.setRoot(true);
        this.registerObject(this.rootResource);
        try {
            this.rootResource.load(null);
        }
        catch (IOException ex) {
            throw WrappedException.wrap((Exception)ex);
        }
    }

    @Override
    public URI createResourceURI(String path) {
        URI uri;
        if (this.provider != null && (uri = this.provider.getResourceURI(this, path)) != null) {
            return uri;
        }
        InternalCDOSession session = this.getSession();
        return CDOURIUtil.createResourceURI(session, path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isEmpty() {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                CDOResourceImpl rootResource = this.getRootResource();
                if (rootResource.cdoPermission() == CDOPermission.NONE) {
                    return true;
                }
                boolean empty = rootResource.getContents().isEmpty();
                this.ensureContainerAdapter(rootResource);
                boolean bl = empty;
                return bl;
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDOResourceNode[] getElements() {
        ArrayList<CDOResourceNode> elements = new ArrayList<CDOResourceNode>();
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                if (this.isActive()) {
                    CDOResourceImpl rootResource = this.getRootResource();
                    EList<EObject> contents = rootResource.getContents();
                    for (EObject object2 : contents) {
                        if (!(object2 instanceof CDOResourceNode)) continue;
                        CDOResourceNode element = (CDOResourceNode)object2;
                        elements.add(element);
                    }
                    this.ensureContainerAdapter(rootResource);
                }
            }
            finally {
                this.unlockView();
            }
            return elements.toArray(new CDOResourceNode[elements.size()]);
        }
    }

    private void ensureContainerAdapter(final CDOResource rootResource) {
        EList adapters = rootResource.eAdapters();
        ContainerAdapter adapter = this.getContainerAdapter((EList<Adapter>)adapters);
        if (adapter == null) {
            adapter = new ContainerAdapter();
            adapters.add((Object)adapter);
            this.options().addChangeSubscriptionPolicy(new CDOAdapterPolicy(){

                @Override
                public boolean isValid(EObject eObject, Adapter adapter) {
                    return eObject == rootResource;
                }
            });
        }
    }

    private ContainerAdapter getContainerAdapter(EList<Adapter> adapters) {
        for (Adapter adapter : adapters) {
            if (!(adapter instanceof ContainerAdapter) || ((ContainerAdapter)adapter).getView() != this) continue;
            return (ContainerAdapter)adapter;
        }
        return null;
    }

    @Override
    public CDOURIHandler getURIHandler() {
        return this.uriHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CDOBranchPoint getBranchPoint() {
        BranchPointLock branchPointLock = this.branchPointLock;
        synchronized (branchPointLock) {
            return this.branchPoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CDOBranchPoint getNormalizedBranchPoint() {
        BranchPointLock branchPointLock = this.branchPointLock;
        synchronized (branchPointLock) {
            return this.normalizedBranchPoint;
        }
    }

    @Override
    public boolean setBranch(CDOBranch branch) {
        return this.setBranchPoint(branch, this.getTimeStamp(), null);
    }

    @Override
    public boolean setBranch(CDOBranch branch, IProgressMonitor monitor) {
        return this.setBranchPoint(branch, this.getTimeStamp(), monitor);
    }

    @Override
    public boolean setTimeStamp(long timeStamp) {
        return this.setBranchPoint(this.getBranch(), timeStamp, null);
    }

    @Override
    public boolean setTimeStamp(long timeStamp, IProgressMonitor monitor) {
        return this.setBranchPoint(this.getBranch(), timeStamp, monitor);
    }

    @Override
    public boolean setBranchPoint(CDOBranch branch, long timeStamp) {
        return this.setBranchPoint(branch, timeStamp, null);
    }

    @Override
    public boolean setBranchPoint(CDOBranch branch, long timeStamp, IProgressMonitor monitor) {
        CDOBranchPoint branchPoint = branch.getPoint(timeStamp);
        return this.setBranchPoint(branchPoint, monitor);
    }

    @Override
    public boolean setBranchPoint(CDOBranchPoint branchPoint) {
        return this.setBranchPoint(branchPoint, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CDOBranchPoint basicSetBranchPoint(CDOBranchPoint branchPoint) {
        BranchPointLock branchPointLock = this.branchPointLock;
        synchronized (branchPointLock) {
            this.branchPoint = this.adjustBranchPoint(branchPoint);
            this.normalizedBranchPoint = CDOBranchUtil.normalizeBranchPoint((CDOBranchPoint)this.branchPoint);
            return this.branchPoint;
        }
    }

    protected final CDOBranchPoint adjustBranchPoint(CDOBranchPoint branchPoint) {
        InternalCDOSession session = this.getSession();
        if (session != null) {
            CDOBranchManager branchManager = session.getBranchManager();
            branchPoint = CDOBranchUtil.adjustBranchPoint((CDOBranchPoint)branchPoint, (CDOBranchManager)branchManager);
        }
        return CDOBranchUtil.copyBranchPoint((CDOBranchPoint)branchPoint);
    }

    @Override
    public void waitForUpdate(long updateTime) {
        this.waitForUpdate(updateTime, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDOBranch getBranch() {
        BranchPointLock branchPointLock = this.branchPointLock;
        synchronized (branchPointLock) {
            return this.branchPoint.getBranch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeStamp() {
        BranchPointLock branchPointLock = this.branchPointLock;
        synchronized (branchPointLock) {
            return this.branchPoint.getTimeStamp();
        }
    }

    protected void fireViewTargetChangedEvent(CDOBranchPoint oldBranchPoint, IListener[] listeners) {
        this.fireEvent(new ViewTargetChangedEvent(oldBranchPoint, this.branchPoint), listeners);
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public boolean hasConflict() {
        return false;
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean hasResource(String path) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                this.checkActive();
                this.getResourceNodeID(path);
                this.unlockView();
            }
            catch (CDOResourceNodeNotFoundException ex) {
                this.unlockView();
                return false;
                catch (Throwable throwable) {
                    this.unlockView();
                    throw throwable;
                }
            }
            return true;
        }
    }

    @Override
    public CDOQueryImpl createQuery(String language, String queryString) {
        return this.createQuery(language, queryString, null);
    }

    @Override
    public CDOQueryImpl createQuery(String language, String queryString, Object context) {
        this.checkActive();
        Object object = this.getViewMonitor();
        synchronized (object) {
            CDOQueryImpl cDOQueryImpl;
            this.lockView();
            try {
                cDOQueryImpl = new CDOQueryImpl(this, language, queryString, context);
                this.unlockView();
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            return cDOQueryImpl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CDOResourceNode getResourceNode(String path) throws CDOResourceNodeNotFoundException {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                InternalCDOObject object2;
                CDOID id = this.getResourceNodeID(path);
                if (id != null && (object2 = this.getObject(id)) instanceof CDOResourceNode) {
                    CDOResourceNode cDOResourceNode = (CDOResourceNode)((Object)object2);
                    return cDOResourceNode;
                }
                throw new CDOResourceNodeNotFoundException("Resource node not found: " + path);
            }
            finally {
                this.unlockView();
            }
        }
    }

    private CDOID getCachedResourceNodeID(String path) {
        if (this.resourcePathCache != null) {
            path = CDOURIUtil.sanitizePath(path);
            return this.resourcePathCache.get(path);
        }
        return null;
    }

    private void setCachedResourceNodeID(String path, CDOID id) {
        if (this.resourcePathCache != null) {
            path = CDOURIUtil.sanitizePath(path);
            if (id == null) {
                this.resourcePathCache.remove(path);
            } else {
                this.resourcePathCache.put(path, id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setResourcePathCache(Map<String, CDOID> resourcePathCache) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                this.resourcePathCache = resourcePathCache;
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearResourcePathCacheIfNecessary(CDORevisionDelta delta) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                if (this.resourcePathCache != null && !this.resourcePathCache.isEmpty()) {
                    if (delta == null) {
                        this.resourcePathCache.clear();
                    } else if (AbstractCDOView.canHaveResourcePathImpact(delta, this.rootResourceID)) {
                        this.resourcePathCache.clear();
                    }
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    @Override
    public CDOID getResourceNodeID(String path) {
        if (StringUtil.isEmpty((String)path)) {
            throw new IllegalArgumentException(Messages.getString("CDOViewImpl.1"));
        }
        Object object = this.getViewMonitor();
        synchronized (object) {
            CDOID cDOID;
            this.lockView();
            try {
                CDOID id = this.getCachedResourceNodeID(path);
                if (id == null) {
                    if (CDOURIUtil.SEGMENT_SEPARATOR.equals(path)) {
                        id = this.getResourceNodeIDChecked(null, null);
                        this.setCachedResourceNodeID(path, id);
                    } else {
                        List<String> names = CDOURIUtil.analyzePath(path);
                        path = "";
                        for (String name : names) {
                            CDOID cached = this.getCachedResourceNodeID(path = String.valueOf(path) + CDOURIUtil.SEGMENT_SEPARATOR + name);
                            if (cached != null) {
                                id = cached;
                                continue;
                            }
                            id = this.getResourceNodeIDChecked(id, name);
                            this.setCachedResourceNodeID(path, id);
                        }
                    }
                }
                cDOID = id;
                this.unlockView();
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            return cDOID;
        }
    }

    private CDOID getResourceNodeIDChecked(CDOID folderID, String name) throws CDOResourceNodeNotFoundException {
        CDOID id = this.getResourceNodeID(folderID, name);
        if (id == null) {
            throw new CDOException(MessageFormat.format(Messages.getString("CDOViewImpl.2"), name));
        }
        return id;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CDOResourceNode getResourceNode(CDOID folderID, String name) throws CDOResourceNodeNotFoundException {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                CDOID id = this.getResourceNodeID(folderID, name);
                CDOResourceNode cDOResourceNode = (CDOResourceNode)((Object)this.getObject(id));
                return cDOResourceNode;
            }
            catch (CDOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CDOException((Throwable)ex);
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CDOID getResourceNodeID(CDOID folderID, String name) throws CDOResourceNodeNotFoundException {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                CDOList list;
                if (folderID == null) {
                    CDOID cDOID = this.getRootOrTopLevelResourceNodeID(name);
                    return cDOID;
                }
                if (name == null) {
                    throw new IllegalArgumentException(Messages.getString("CDOViewImpl.3"));
                }
                InternalCDORevision folderRevision = this.getLocalRevision(folderID);
                EClass resourceFolderClass = EresourcePackage.eINSTANCE.getCDOResourceFolder();
                if (folderRevision.getEClass() != resourceFolderClass) {
                    throw new CDOException(MessageFormat.format(Messages.getString("CDOViewImpl.4"), folderID));
                }
                boolean bypassPermissionChecks = folderRevision.bypassPermissionChecks(true);
                try {
                    list = folderRevision.getListOrNull((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_FOLDER__NODES);
                }
                finally {
                    folderRevision.bypassPermissionChecks(bypassPermissionChecks);
                }
                CDOStore store = this.getStore();
                int size = list == null ? 0 : list.size();
                int i = 0;
                while (true) {
                    if (i >= size) {
                        throw new CDOResourceNodeNotFoundException(MessageFormat.format(Messages.getString("CDOViewImpl.5"), name));
                    }
                    Object value = list.get(i);
                    CDOID childID = (CDOID)this.convertObjectToID(value = store.resolveProxy(folderRevision, (EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_FOLDER__NODES, i, value));
                    InternalCDORevision childRevision = this.getLocalRevision(childID);
                    String childName = (String)childRevision.get((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_NODE__NAME, 0);
                    if (name.equals(childName)) {
                        CDOID cDOID = childID;
                        return cDOID;
                    }
                    ++i;
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CDOID getRootOrTopLevelResourceNodeID(String name) throws CDOResourceNodeNotFoundException {
        if (name == null) {
            return this.rootResourceID;
        }
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                CDOID id = this.getRootOrTopLevelResourceNodeIDCached(name);
                if (id != null) {
                    CDOID cDOID = id;
                    return cDOID;
                }
                CDOQuery resourceQuery = this.createResourcesQuery(null, name, true);
                resourceQuery.setMaxResults(1);
                List<CDOID> ids = resourceQuery.getResult(CDOID.class);
                if (ids.isEmpty()) {
                    throw new CDOResourceNodeNotFoundException(MessageFormat.format(Messages.getString("CDOViewImpl.7"), name));
                }
                CDOID cDOID = ids.get(0);
                return cDOID;
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CDOID getRootOrTopLevelResourceNodeIDCached(String name) {
        InternalCDORevision rootResourceRevision = this.getRevision(this.rootResourceID, false);
        if (rootResourceRevision == null) return null;
        boolean bypassPermissionChecksRoot = rootResourceRevision.bypassPermissionChecks(true);
        try {
            CDOList contents = rootResourceRevision.getListOrNull((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__CONTENTS);
            if (contents == null) return null;
            for (Object element : contents) {
                CDOResourceNode node;
                if (element instanceof CDOID) {
                    CDOID id = (CDOID)element;
                    InternalCDORevision revision = this.getRevision(id, false);
                    if (revision == null) continue;
                    boolean bypassPermissionChecks = revision.bypassPermissionChecks(true);
                    try {
                        if (name.equals(CDORevisionUtil.getResourceNodeName((CDORevision)revision))) {
                            CDOID cDOID = id;
                            return cDOID;
                        }
                    }
                    finally {
                        revision.bypassPermissionChecks(bypassPermissionChecks);
                    }
                }
                if (!(element instanceof CDOResourceNode) || !name.equals((node = (CDOResourceNode)element).getName())) continue;
                CDOID cDOID = node.cdoID();
                return cDOID;
            }
            return null;
        }
        finally {
            rootResourceRevision.bypassPermissionChecks(bypassPermissionChecksRoot);
        }
    }

    private InternalCDORevision getLocalRevision(CDOID id) {
        InternalCDORevision revision = null;
        InternalCDOObject object = this.getObject(id, false);
        if (object != null && object.cdoState() != CDOState.PROXY) {
            revision = object.cdoRevision();
        }
        if (revision == null) {
            revision = this.getRevision(id, true);
        }
        if (revision == null) {
            throw new CDOException(MessageFormat.format(Messages.getString("CDOViewImpl.9"), id));
        }
        return revision;
    }

    protected InternalCDORevision getRevision(CDOObject object) {
        if (object.cdoState() == CDOState.NEW) {
            return null;
        }
        InternalCDORevision revision = (InternalCDORevision)object.cdoRevision();
        if (revision == null) {
            revision = CDOStateMachine.INSTANCE.read((InternalCDOObject)object);
        }
        return revision;
    }

    @Override
    public CDOLockState[] getLockStatesOfObjects(Collection<? extends CDOObject> objects) {
        ArrayList<CDOID> ids = new ArrayList<CDOID>();
        for (CDOObject cDOObject : objects) {
            CDOID id = this.getID((InternalCDOObject)cDOObject, true);
            if (id == null) continue;
            ids.add(id);
        }
        return this.getLockStates(ids);
    }

    @Override
    public List<InternalCDOObject> getObjectsList() {
        Object object = this.getViewMonitor();
        synchronized (object) {
            ArrayList<InternalCDOObject> arrayList;
            this.lockView();
            try {
                ArrayList<InternalCDOObject> result = new ArrayList<InternalCDOObject>();
                for (InternalCDOObject value : this.objects.values()) {
                    if (value == null) continue;
                    result.add(value);
                }
                arrayList = result;
                this.unlockView();
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            return arrayList;
        }
    }

    @Override
    public CDOResource getResource(String path) throws CDOResourceNodeNotFoundException {
        return this.getResource(path, true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public CDOResource getResource(String path, boolean loadOnDemand) throws CDOResourceNodeNotFoundException {
        this.checkActive();
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                CDOResource cDOResource;
                URI uri = CDOURIUtil.createResourceURI(this, path);
                ResourceSet resourceSet = this.getResourceSet();
                this.ensureURIs(resourceSet);
                try {
                    cDOResource = (CDOResource)resourceSet.getResource(uri, loadOnDemand);
                }
                catch (RuntimeException ex) {
                    EList resources = resourceSet.getResources();
                    int i = resources.size() - 1;
                    while (i >= 0) {
                        Resource resource = (Resource)resources.get(i);
                        if (uri.equals(resource.getURI())) {
                            resources.remove(i);
                            break;
                        }
                        --i;
                    }
                    throw ex;
                }
                return cDOResource;
            }
            finally {
                this.unlockView();
            }
        }
    }

    @Override
    public CDOTextResource getTextResource(String path) throws CDOResourceNodeNotFoundException {
        return (CDOTextResource)this.getResourceNode(path);
    }

    @Override
    public CDOBinaryResource getBinaryResource(String path) throws CDOResourceNodeNotFoundException {
        return (CDOBinaryResource)this.getResourceNode(path);
    }

    @Override
    public CDOResourceFolder getResourceFolder(String path) throws CDOResourceNodeNotFoundException {
        return (CDOResourceFolder)this.getResourceNode(path);
    }

    private void ensureURIs(ResourceSet resourceSet) {
        EList resources = resourceSet.getResources();
        Object[] resourceArr = null;
        int size = 0;
        do {
            int i = size;
            size = resources.size();
            if (size == 0) break;
            if (resourceArr == null || resourceArr.length < size) {
                resourceArr = new Resource[size * 2];
            }
            resourceArr = (Resource[])resources.toArray(resourceArr);
            while (i < size) {
                resourceArr[i].getURI();
                ++i;
            }
        } while (resources.size() > size);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public final List<CDOResourceNode> queryResources(CDOResourceFolder folder, String name, boolean exactMatch) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                ArrayList<CDOResourceNode> arrayList;
                CloseableIterator<CDOResourceNode> it = this.queryResourcesUnsynced(folder, name, exactMatch);
                try {
                    ArrayList<CDOResourceNode> result = new ArrayList<CDOResourceNode>();
                    while (it.hasNext()) {
                        CDOResourceNode node = (CDOResourceNode)it.next();
                        result.add(node);
                    }
                    arrayList = result;
                }
                catch (Throwable throwable) {
                    it.close();
                    throw throwable;
                }
                it.close();
                return arrayList;
            }
            finally {
                this.unlockView();
            }
        }
    }

    @Override
    public final CloseableIterator<CDOResourceNode> queryResourcesAsync(CDOResourceFolder folder, String name, boolean exactMatch) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            CloseableIterator<CDOResourceNode> closeableIterator;
            this.lockView();
            try {
                closeableIterator = this.queryResourcesUnsynced(folder, name, exactMatch);
                this.unlockView();
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            return closeableIterator;
        }
    }

    protected CloseableIterator<CDOResourceNode> queryResourcesUnsynced(CDOResourceFolder folder, String name, boolean exactMatch) {
        CDOQuery resourceQuery = this.createResourcesQuery(folder, name, exactMatch);
        return resourceQuery.getResultAsync(CDOResourceNode.class);
    }

    private CDOQuery createResourcesQuery(CDOResourceFolder folder, String name, boolean exactMatch) {
        this.checkActive();
        CDOQueryImpl query = this.createQuery("resources", name);
        query.setParameter("folder", folder == null ? null : folder.cdoID());
        query.setParameter("exactMatch", exactMatch);
        return query;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public final <T extends EObject> List<T> queryInstances(EClass type) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                ArrayList<EObject> arrayList;
                CloseableIterator<T> it = this.queryInstancesUnsynced(type, false);
                try {
                    ArrayList<EObject> result = new ArrayList<EObject>();
                    while (it.hasNext()) {
                        EObject object2 = (EObject)it.next();
                        result.add(object2);
                    }
                    arrayList = result;
                }
                catch (Throwable throwable) {
                    it.close();
                    throw throwable;
                }
                it.close();
                return arrayList;
            }
            finally {
                this.unlockView();
            }
        }
    }

    @Override
    public final <T extends EObject> CloseableIterator<T> queryInstancesAsync(EClass type) {
        return this.queryInstancesAsync(type, false);
    }

    @Override
    public final <T extends EObject> CloseableIterator<T> queryInstancesAsync(EClass type, boolean exact) {
        if (exact && (type.isInterface() || type.isAbstract())) {
            return AbstractCloseableIterator.emptyCloseable();
        }
        Object object = this.getViewMonitor();
        synchronized (object) {
            CloseableIterator<T> closeableIterator;
            this.lockView();
            try {
                closeableIterator = this.queryInstancesUnsynced(type, exact);
                this.unlockView();
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            return closeableIterator;
        }
    }

    protected <T extends EObject> CloseableIterator<T> queryInstancesUnsynced(EClass type, boolean exact) {
        CDOQuery query = this.createInstancesQuery(type, exact);
        return query.getResultAsync();
    }

    private CDOQuery createInstancesQuery(EClass type, boolean exact) {
        CDOQueryImpl query = this.createQuery("instances", null);
        query.setParameter("type", type);
        if (exact) {
            query.setParameter("exact", Boolean.TRUE);
        }
        return query;
    }

    @Override
    public final List<CDOObjectReference> queryXRefs(CDOObject targetObject, EReference ... sourceReferences) {
        return this.queryXRefs(Collections.singleton(targetObject), sourceReferences);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public final List<CDOObjectReference> queryXRefs(Set<CDOObject> targetObjects, EReference ... sourceReferences) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                ArrayList<CDOObjectReference> arrayList;
                CloseableIterator<CDOObjectReference> it = this.queryXRefsUnsynced(targetObjects, sourceReferences);
                try {
                    ArrayList<CDOObjectReference> result = new ArrayList<CDOObjectReference>();
                    while (it.hasNext()) {
                        CDOObjectReference object2 = (CDOObjectReference)it.next();
                        result.add(object2);
                    }
                    arrayList = result;
                }
                catch (Throwable throwable) {
                    it.close();
                    throw throwable;
                }
                it.close();
                return arrayList;
            }
            finally {
                this.unlockView();
            }
        }
    }

    @Override
    public final CloseableIterator<CDOObjectReference> queryXRefsAsync(Set<CDOObject> targetObjects, EReference ... sourceReferences) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            CloseableIterator<CDOObjectReference> closeableIterator;
            this.lockView();
            try {
                closeableIterator = this.queryXRefsUnsynced(targetObjects, sourceReferences);
                this.unlockView();
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            return closeableIterator;
        }
    }

    protected CloseableIterator<CDOObjectReference> queryXRefsUnsynced(Set<CDOObject> targetObjects, EReference ... sourceReferences) {
        CDOQuery query = this.createXRefsQuery(true, null, targetObjects, sourceReferences);
        if (query.getQueryString() != null) {
            return query.getResultAsync(CDOObjectReference.class);
        }
        return AbstractCloseableIterator.emptyCloseable();
    }

    protected final CDOQuery createXRefsQuery(boolean excludeNewObjects, Set<CDOID> targetIDs, Set<CDOObject> targetObjects, EReference ... sourceReferences) {
        StringBuilder builder = null;
        for (CDOObject target : targetObjects) {
            CDOID id = this.getXRefTargetID(target);
            if (targetIDs != null) {
                targetIDs.add(id);
            }
            if (this.isObjectNew(id)) {
                if (!excludeNewObjects) continue;
                throw new IllegalArgumentException("Cross referencing for uncommitted new objects is not supported: " + target);
            }
            if (builder == null) {
                builder = new StringBuilder();
            } else {
                builder.append("|");
            }
            builder.append(id.isExternal() ? "e" : "i");
            builder.append(id.toURIFragment());
            if (id instanceof CDOClassifierRef.Provider) continue;
            builder.append("|");
            CDOClassifierRef classifierRef = new CDOClassifierRef((EClassifier)target.eClass());
            builder.append(classifierRef.getURI());
        }
        String queryString = builder == null ? null : builder.toString();
        CDOQueryImpl query = this.createQuery("xrefs", queryString);
        if (sourceReferences.length != 0) {
            String sourceReferencesParam = this.createXRefsQuerySourceReferences(sourceReferences);
            query.setParameter("sourceReferences", sourceReferencesParam);
        }
        return query;
    }

    private String createXRefsQuerySourceReferences(EReference[] sourceReferences) {
        StringBuilder builder = new StringBuilder();
        EReference[] eReferenceArray = sourceReferences;
        int n = sourceReferences.length;
        int n2 = 0;
        while (n2 < n) {
            EReference sourceReference = eReferenceArray[n2];
            StringUtil.appendSeparator((StringBuilder)builder, (char)'|');
            CDOClassifierRef classifierRef = new CDOClassifierRef((EClassifier)sourceReference.getEContainingClass());
            builder.append(classifierRef.getURI());
            builder.append('|');
            builder.append(sourceReference.getName());
            ++n2;
        }
        return builder.toString();
    }

    protected CDOID getXRefTargetID(CDOObject target) {
        if (FSMUtil.isTransient(target)) {
            throw new IllegalArgumentException("Cross referencing for transient objects not supported " + target);
        }
        return target.cdoID();
    }

    public CDOResourceImpl getResource(CDOID resourceID) {
        if (CDOIDUtil.isNull((CDOID)resourceID)) {
            throw new IllegalArgumentException("resourceID: " + resourceID);
        }
        return (CDOResourceImpl)this.getObject(resourceID);
    }

    public InternalCDOObject newInstance(EClass eClass) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            InternalCDOObject internalCDOObject;
            this.lockView();
            try {
                EObject eObject = EcoreUtil.create((EClass)eClass);
                internalCDOObject = FSMUtil.adapt(eObject, this);
                this.unlockView();
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            return internalCDOObject;
        }
    }

    public InternalCDORevision getRevision(CDOID id) {
        return this.getRevision(id, true);
    }

    @Override
    public Map<CDOID, CDOObject> getObjects(Collection<CDOID> ids) {
        Map result = CDOIDUtil.createMap();
        ArrayList missingIDs = new ArrayList();
        for (CDOID id : ids) {
            result.computeIfAbsent(id, i -> {
                InternalCDOObject object = this.getObject((CDOID)i, false);
                if (object == null) {
                    missingIDs.add(i);
                }
                return object;
            });
        }
        if (!missingIDs.isEmpty()) {
            InternalCDOSession session = this.getSession();
            int initialChunkSize = session.options().getCollectionLoadingPolicy().getInitialChunkSize();
            InternalCDORevisionManager revisionManager = session.getRevisionManager();
            List revisions = revisionManager.getRevisions(missingIDs, (CDOBranchPoint)this, initialChunkSize, 0, true);
            for (CDORevision revision : revisions) {
                if (revision == null) continue;
                result.computeIfAbsent(revision.getID(), i -> this.getObject((CDOID)i, false));
            }
        }
        return result;
    }

    @Override
    public InternalCDOObject getObject(CDOID id) {
        return this.getObject(id, true);
    }

    @Override
    public InternalCDOObject getObject(CDOID id, boolean loadOnDemand) {
        if (CDOIDUtil.isNull((CDOID)id)) {
            return null;
        }
        Object object = this.getViewMonitor();
        synchronized (object) {
            InternalCDOObject internalCDOObject;
            this.lockView();
            try {
                internalCDOObject = this.getObjectUnsynced(id, loadOnDemand);
                this.unlockView();
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            return internalCDOObject;
        }
    }

    protected InternalCDOObject getObjectUnsynced(CDOID id, boolean loadOnDemand) {
        this.checkActive();
        if (this.rootResource != null && this.rootResource.cdoID() == id) {
            return this.rootResource;
        }
        if (id == this.lastLookupID) {
            return this.lastLookupObject;
        }
        this.lastLookupID = null;
        this.lastLookupObject = null;
        InternalCDOObject localLookupObject = null;
        if (id.isExternal()) {
            URI uri = URI.createURI((String)((CDOIDExternal)id).getURI());
            ResourceSet resourceSet = this.getResourceSet();
            localLookupObject = (InternalCDOObject)CDOUtil.getCDOObject(resourceSet.getEObject(uri, loadOnDemand));
            if (localLookupObject == null) {
                if (!loadOnDemand) {
                    return null;
                }
                throw new ObjectNotFoundException(id, (CDOBranchPoint)this);
            }
        } else {
            localLookupObject = this.objects.get(id);
            if (localLookupObject == null) {
                if (!loadOnDemand) {
                    return null;
                }
                this.excludeNewObject(id);
                localLookupObject = this.createObject(id);
                if (id == this.rootResourceID) {
                    this.setRootResource((CDOResourceImpl)localLookupObject);
                }
            }
        }
        this.lastLookupID = id;
        this.lastLookupObject = localLookupObject;
        return this.lastLookupObject;
    }

    protected void excludeNewObject(CDOID id) {
        if (this.isObjectNew(id)) {
            throw new ObjectNotFoundException(id, (CDOBranchPoint)this);
        }
    }

    @Override
    public boolean isObjectNew(CDOID id) {
        return id.isTemporary();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T extends EObject> T getObject(T objectFromDifferentView) {
        this.checkActive();
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            CDOObject object2 = CDOUtil.getCDOObject(objectFromDifferentView);
            CDOView view = object2.cdoView();
            if (view == null) {
                return null;
            }
            if (view != this) {
                EObject cast;
                if (!view.getSession().getRepositoryInfo().getUUID().equals(this.getSession().getRepositoryInfo().getUUID())) {
                    throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOViewImpl.11"), objectFromDifferentView));
                }
                CDOID id = object2.cdoID();
                InternalCDOObject contextified = this.getObject(id, true);
                if (objectFromDifferentView instanceof CDOLegacyAdapter) {
                    InternalCDOObject cast2;
                    InternalCDOObject internalCDOObject = cast2 = contextified;
                    return (T)internalCDOObject;
                }
                EObject eObject = cast = CDOUtil.getEObject(contextified);
                return (T)eObject;
            }
            T t = objectFromDifferentView;
            return t;
            finally {
                this.unlockView();
            }
        }
    }

    @Override
    public boolean isObjectRegistered(CDOID id) {
        this.checkActive();
        if (CDOIDUtil.isNull((CDOID)id)) {
            return false;
        }
        Object object = this.getViewMonitor();
        synchronized (object) {
            boolean bl;
            this.lockView();
            try {
                bl = this.objects.containsKey(id);
                this.unlockView();
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            return bl;
        }
    }

    public InternalCDOObject removeObject(CDOID id) {
        if (id == null) {
            return null;
        }
        Object object = this.getViewMonitor();
        synchronized (object) {
            InternalCDOObject internalCDOObject;
            this.lockView();
            try {
                InternalCDOObject object2;
                if (id == this.lastLookupID) {
                    this.lastLookupID = null;
                    this.lastLookupObject = null;
                }
                if ((object2 = this.objects.remove(id)) != null) {
                    this.objectDeregistered(object2);
                }
                internalCDOObject = object2;
                this.unlockView();
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            return internalCDOObject;
        }
    }

    private InternalCDOObject createObject(CDOID id) {
        InternalCDOObject object;
        if (TRACER.isEnabled()) {
            TRACER.trace("Creating object for " + id);
        }
        int originalCount = this.objectCreationCounter;
        InternalCDORevision revision = this.getRevision(id, true);
        if (revision == null) {
            throw new ObjectNotFoundException(id, (CDOBranchPoint)this);
        }
        InternalCDOObject internalCDOObject = object = this.objectCreationCounter == originalCount ? null : this.objects.get(id);
        if (object == null) {
            EClass eClass = revision.getEClass();
            object = CDOModelUtil.isResource((EClass)eClass) && id != this.rootResourceID ? (InternalCDOObject)((Object)this.newResourceInstance(revision)) : this.newInstance(eClass);
            ++this.objectCreationCounter;
            this.cleanObject(object, revision);
            CDOStateMachine.INSTANCE.dispatchLoadNotification(object);
            if (!CDOModelUtil.isResource((EClass)eClass)) {
                this.getStore().getResource(object);
            }
            if (CDOModelUtil.isResourceNode((EClass)eClass)) {
                String path = this.getResourcePath(revision);
                this.setCachedResourceNodeID(path, id);
            }
        }
        return object;
    }

    private CDOResource newResourceInstance(InternalCDORevision revision) {
        String path = this.getResourcePath(revision);
        URI uri = CDOURIUtil.createResourceURI(this, path);
        ResourceSet resourceSet = this.getResourceSet();
        CDOResource existingResource = (CDOResource)resourceSet.getResource(uri, false);
        if (existingResource != null && !this.isReadOnly()) {
            AbstractCDOView.preventURIClash(existingResource);
        }
        return this.getResource(path, true);
    }

    private String getResourcePath(InternalCDORevision revision) {
        CDORevisionData data = revision.data();
        Object containerID = data.getContainerID();
        CDOID folderID = containerID instanceof CDOWithID ? ((CDOWithID)containerID).cdoID() : (CDOID)containerID;
        String name = (String)revision.data().get((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_NODE__NAME, 0);
        if (CDOIDUtil.isNull((CDOID)folderID)) {
            if (name == null) {
                return CDOURIUtil.SEGMENT_SEPARATOR;
            }
            return String.valueOf(CDOURIUtil.SEGMENT_SEPARATOR) + name;
        }
        InternalCDOObject object = this.getObject(folderID, true);
        if (object instanceof CDOResourceFolder) {
            CDOResourceFolder folder = (CDOResourceFolder)((Object)object);
            String path = folder.getPath();
            return String.valueOf(path) + CDOURIUtil.SEGMENT_SEPARATOR + name;
        }
        throw new ImplementationError(MessageFormat.format(Messages.getString("CDOViewImpl.14"), object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanObject(InternalCDOObject object, InternalCDORevision revision) {
        Object object2 = this.getViewMonitor();
        synchronized (object2) {
            this.lockView();
            try {
                object.cdoInternalSetView(this);
                object.cdoInternalSetRevision((CDORevision)revision);
                this.registerObjectIfNotRegistered(object);
                object.cdoInternalSetState(CDOState.CLEAN);
                object.cdoInternalPostLoad();
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CDOID provideCDOID(Object idOrObject) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                InternalCDOObject object2;
                Object shouldBeCDOID = this.convertObjectToID(idOrObject);
                if (shouldBeCDOID instanceof CDOID) {
                    CDOID id = (CDOID)shouldBeCDOID;
                    if (TRACER.isEnabled() && id != idOrObject) {
                        TRACER.format("Converted object to CDOID: {0} --> {1}", new Object[]{idOrObject, id});
                    }
                    CDOID cDOID = id;
                    return cDOID;
                }
                if (!(idOrObject instanceof InternalEObject)) throw new IllegalStateException(MessageFormat.format(Messages.getString("CDOViewImpl.16"), idOrObject));
                InternalEObject eObject = (InternalEObject)idOrObject;
                if (eObject instanceof InternalCDOObject && (object2 = (InternalCDOObject)idOrObject).cdoView() != null && FSMUtil.isNew(object2) && object2.cdoID().isTemporary()) {
                    String uri = EcoreUtil.getURI((EObject)object2.cdoInternalInstance()).toString();
                    CDOIDExternal cDOIDExternal = CDOIDUtil.createTempObjectExternal((String)uri);
                    return cDOIDExternal;
                }
                Resource eResource = eObject.eResource();
                if (eResource != null) {
                    if (eResource instanceof CDOResource && ((CDOResource)eResource).cdoState() == CDOState.TRANSIENT) throw new DanglingReferenceException((EObject)eObject);
                    String uri = EcoreUtil.getURI((EObject)CDOUtil.getEObject((EObject)eObject)).toString();
                    CDOIDExternal cDOIDExternal = CDOIDUtil.createExternal((String)uri);
                    return cDOIDExternal;
                } else {
                    URI proxyURI = eObject.eProxyURI();
                    if (proxyURI == null) throw new DanglingReferenceException((EObject)eObject);
                    ResourceSet resourceSet = this.getResourceSet();
                    EObject resolvedObject = EcoreUtil.resolve((EObject)eObject, (ResourceSet)resourceSet);
                    if (resolvedObject == eObject) {
                        CDOIDExternal cDOIDExternal = CDOIDUtil.createExternal((String)proxyURI.toString());
                        return cDOIDExternal;
                    }
                    CDOID cDOID = this.provideCDOID(resolvedObject);
                    return cDOID;
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    @Override
    public Object convertObjectToID(Object potentialObject) {
        return this.convertObjectToID(potentialObject, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object convertObjectToID(Object potentialObject, boolean onlyPersistedID) {
        if (potentialObject instanceof CDOID) {
            return potentialObject;
        }
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                if (potentialObject instanceof InternalEObject) {
                    if (potentialObject instanceof InternalCDOObject) {
                        InternalCDOObject object2 = (InternalCDOObject)potentialObject;
                        CDOID id = this.getID(object2, onlyPersistedID);
                        if (id != null) {
                            CDOID cDOID = id;
                            return cDOID;
                        }
                    } else {
                        InternalCDOObject object3 = (InternalCDOObject)EcoreUtil.getAdapter((List)((InternalEObject)potentialObject).eAdapters(), CDOLegacyAdapter.class);
                        if (object3 != null) {
                            CDOID id = this.getID(object3, onlyPersistedID);
                            if (id != null) {
                                CDOID cDOID = id;
                                return cDOID;
                            }
                            potentialObject = object3;
                        }
                    }
                }
                Object object4 = potentialObject;
                return object4;
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected CDOID getID(InternalCDOObject object, boolean onlyPersistedID) {
        Object object2 = this.getViewMonitor();
        synchronized (object2) {
            this.lockView();
            try {
                if (onlyPersistedID && (FSMUtil.isTransient(object) || FSMUtil.isNew(object))) {
                    return null;
                }
                InternalCDOView view = object.cdoView();
                if (view == this) {
                    CDOID cDOID = object.cdoID();
                    return cDOID;
                }
                if (view != null && view.getSession() == this.getSession()) {
                    boolean sameTarget;
                    boolean bl = sameTarget = view.getBranch() == this.getBranch() && view.getTimeStamp() == this.getTimeStamp();
                    if (!sameTarget) {
                        throw new IllegalArgumentException("Object " + object + " is managed by a view with different target: " + view);
                    }
                    CDOID cDOID = object.cdoID();
                    return cDOID;
                }
                return null;
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object convertIDToObject(Object potentialID) {
        if (!(potentialID instanceof CDOID)) {
            return potentialID;
        }
        if (potentialID == CDOID.NULL) {
            return null;
        }
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                CDOID id = (CDOID)potentialID;
                if (id.isExternal()) {
                    ResourceSet resourceSet = this.getResourceSet();
                    URI uri = URI.createURI((String)id.toURIFragment());
                    EObject eObject = resourceSet.getEObject(uri, true);
                    return eObject;
                }
                InternalCDOObject result = this.getObject(id, true);
                if (result == null) {
                    throw new ImplementationError(MessageFormat.format(Messages.getString("CDOViewImpl.17"), id));
                }
                InternalEObject internalEObject = result.cdoInternalInstance();
                return internalEObject;
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachResource(CDOResourceImpl resource) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                if (!resource.isExisting()) {
                    throw new ReadOnlyException(MessageFormat.format(Messages.getString("CDOViewImpl.18"), this));
                }
                resource.cdoInternalSetView(this);
                resource.cdoInternalSetState(CDOState.PROXY);
                this.registerProxyResource2(resource);
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerProxyResource2(CDOResourceImpl resource) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                URI uri = resource.getURI();
                String path = CDOURIUtil.extractResourcePath(uri);
                boolean isRoot = "/".equals(path);
                try {
                    CDOID id = isRoot ? this.rootResourceID : this.getResourceNodeID(path);
                    resource.cdoInternalSetID(id);
                    this.registerObject(resource);
                    if (isRoot) {
                        resource.setRoot(true);
                        this.getResourceSet();
                        this.rootResource = resource;
                    }
                }
                catch (LifecycleException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new InvalidURIException(uri, ex);
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    @Override
    @Deprecated
    public void registerProxyResource(CDOResourceImpl resource) {
        this.registerProxyResource2(resource);
    }

    private void registerObjectIfNotRegistered(InternalCDOObject object) {
        if (CDOModelUtil.isResource((EClass)object.eClass())) {
            return;
        }
        if (this.objects.containsKey(object.cdoID())) {
            return;
        }
        this.registerObject(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerObject(InternalCDOObject object) {
        String nsURI;
        if (LEGACY_MODELS != null && CDOUtil.isLegacyObject(object) && LEGACY_MODELS.add(nsURI = object.eClass().getEPackage().getNsURI())) {
            OM.LOG.info("Legacy model detected: " + nsURI);
        }
        Object object2 = this.getViewMonitor();
        synchronized (object2) {
            this.lockView();
            try {
                InternalCDOObject old;
                if (TRACER.isEnabled()) {
                    TRACER.format("Registering {0}", new Object[]{object});
                }
                if ((old = this.objects.put(object.cdoID(), object)) != null) {
                    if (old != object) {
                        throw new IllegalStateException(MessageFormat.format(Messages.getString("CDOViewImpl.30"), object.cdoID()));
                    }
                    if (TRACER.isEnabled()) {
                        TRACER.format(Messages.getString("CDOViewImpl.20"), new Object[]{old});
                    }
                }
                this.objectRegistered(object);
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregisterObject(InternalCDOObject object) {
        Object object2 = this.getViewMonitor();
        synchronized (object2) {
            this.lockView();
            try {
                if (TRACER.isEnabled()) {
                    TRACER.format("Deregistering {0}", new Object[]{object});
                }
                this.removeObject(object.cdoID());
            }
            finally {
                this.unlockView();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void objectRegistered(InternalCDOObject object) {
        if (this.bypassRegistrationHandlers) {
            return;
        }
        CDORegistrationHandler[] handlers = this.getRegistrationHandlers();
        if (handlers.length != 0) {
            Object object2 = this.getViewMonitor();
            synchronized (object2) {
                this.lockView();
                try {
                    int i = 0;
                    while (i < handlers.length) {
                        CDORegistrationHandler handler = handlers[i];
                        handler.objectRegistered(this, object);
                        ++i;
                    }
                }
                finally {
                    this.unlockView();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void objectDeregistered(InternalCDOObject object) {
        if (this.bypassRegistrationHandlers) {
            return;
        }
        CDORegistrationHandler[] handlers = this.getRegistrationHandlers();
        if (handlers.length != 0) {
            Object object2 = this.getViewMonitor();
            synchronized (object2) {
                this.lockView();
                try {
                    int i = 0;
                    while (i < handlers.length) {
                        CDORegistrationHandler handler = handlers[i];
                        handler.objectDeregistered(this, object);
                        ++i;
                    }
                }
                finally {
                    this.unlockView();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void objectCollected(CDOID id) {
        if (this.bypassRegistrationHandlers) {
            return;
        }
        CDORegistrationHandler[] handlers = this.getRegistrationHandlers();
        if (handlers.length != 0) {
            Object object = this.getViewMonitor();
            synchronized (object) {
                this.lockView();
                try {
                    int i = 0;
                    while (i < handlers.length) {
                        CDORegistrationHandler handler = handlers[i];
                        handler.objectCollected(this, id);
                        ++i;
                    }
                }
                finally {
                    this.unlockView();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void remapObject(CDOID oldID) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                this.remapObjectUnsynced(oldID);
            }
            finally {
                this.unlockView();
            }
        }
    }

    protected InternalCDOObject remapObjectUnsynced(CDOID oldID) {
        InternalCDOObject object = this.objects.remove(oldID);
        CDOID newID = object.cdoID();
        this.objects.put(newID, object);
        if (this.lastLookupID == oldID) {
            this.lastLookupID = newID;
            this.lastLookupObject = object;
        }
        if (TRACER.isEnabled()) {
            TRACER.format("Remapping {0} --> {1}", new Object[]{oldID, newID});
        }
        return object;
    }

    @Override
    public void addObjectHandler(CDOObjectHandler handler) {
        this.objectHandlers.add((Object)handler);
    }

    @Override
    public void removeObjectHandler(CDOObjectHandler handler) {
        this.objectHandlers.remove((Object)handler);
    }

    @Override
    public CDOObjectHandler[] getObjectHandlers() {
        return (CDOObjectHandler[])this.objectHandlers.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleObjectStateChanged(InternalCDOObject object, CDOState oldState, CDOState newState) {
        CDOObjectHandler[] handlers = this.getObjectHandlers();
        if (handlers.length != 0) {
            Object object2 = this.getViewMonitor();
            synchronized (object2) {
                this.lockView();
                try {
                    int i = 0;
                    while (i < handlers.length) {
                        CDOObjectHandler handler = handlers[i];
                        handler.objectStateChanged(this, object, oldState, newState);
                        ++i;
                    }
                }
                finally {
                    this.unlockView();
                }
            }
        }
    }

    @Override
    public void addRegistrationHandler(CDORegistrationHandler handler) {
        this.registrationHandlers.add((Object)handler);
    }

    @Override
    public void removeRegistrationHandler(CDORegistrationHandler handler) {
        this.registrationHandlers.remove((Object)handler);
    }

    @Override
    public CDORegistrationHandler[] getRegistrationHandlers() {
        return (CDORegistrationHandler[])this.registrationHandlers.get();
    }

    protected final void bypassRegistrationHandlers(Runnable runnable) {
        this.bypassRegistrationHandlers = true;
        try {
            runnable.run();
        }
        finally {
            this.bypassRegistrationHandlers = false;
        }
    }

    protected Map<CDOObject, Pair<CDORevision, CDORevisionDelta>> invalidate(List<CDORevisionKey> allChangedObjects, List<CDOIDAndVersion> allDetachedObjects, List<CDORevisionDelta> deltas, Map<CDOObject, CDORevisionDelta> revisionDeltas, Set<CDOObject> detachedObjects, Map<CDOID, InternalCDORevision> oldRevisions) {
        boolean hasConflictResolvers = this instanceof CDOTransaction && ((CDOTransaction)((Object)this)).options().getConflictResolvers().length != 0;
        HashMap<InternalCDOObject, Pair> conflicts = null;
        for (CDOIDAndVersion key : allDetachedObjects) {
            CDOID id = key.getID();
            InternalCDOObject detachedObject = this.removeObject(id);
            if (detachedObject == null) continue;
            InternalCDORevision oldRevision = detachedObject.cdoRevision();
            oldRevisions.put(id, oldRevision);
            CDOStateMachine.INSTANCE.detachRemote(detachedObject);
            detachedObjects.add(detachedObject);
            if (!detachedObject.cdoConflict()) continue;
            if (conflicts == null) {
                conflicts = new HashMap<InternalCDOObject, Pair>();
            }
            conflicts.put(detachedObject, Pair.create((Object)oldRevision, (Object)CDORevisionDelta.DETACHED));
        }
        Map<String, CDOResourceNode> newResourceNodes = null;
        for (CDORevisionKey key : allChangedObjects) {
            CDOID id;
            CDOObject changedObject;
            CDORevisionDelta delta = null;
            if (key instanceof CDORevisionDelta) {
                delta = (CDORevisionDelta)key;
                if (hasConflictResolvers) {
                    delta = new CDORevisionDeltaImpl(delta, true);
                }
                deltas.add(delta);
            }
            if ((changedObject = (CDOObject)this.objects.get(id = key.getID())) == null) continue;
            CDORevision oldRevision = changedObject.cdoRevision();
            oldRevisions.put(id, (InternalCDORevision)oldRevision);
            CDOStateMachine.INSTANCE.invalidate((InternalCDOObject)changedObject, key);
            if (changedObject instanceof CDOResourceNodeImpl && (delta == null || this.isResourceNodeContainerOrNameChanged(delta))) {
                if (!this.isReadOnly()) {
                    CDOResourceNode changedNode;
                    String path;
                    CDOResourceNode newResourceNode;
                    if (newResourceNodes == null) {
                        newResourceNodes = this.collectNewResourceNodes();
                    }
                    if ((newResourceNode = newResourceNodes.get(path = (changedNode = (CDOResourceNode)changedObject).getPath())) != null) {
                        AbstractCDOView.preventURIClash(newResourceNode);
                        String oldName = newResourceNode.getBasename();
                        newResourceNode.setBasename(String.valueOf(oldName) + SAFE_RENAME);
                    }
                }
                ((CDOResourceNodeImpl)changedObject).recacheURIs();
            }
            revisionDeltas.put(changedObject, delta);
            if (!changedObject.cdoConflict()) continue;
            if (conflicts == null) {
                conflicts = new HashMap();
            }
            conflicts.put((InternalCDOObject)changedObject, Pair.create((Object)oldRevision, (Object)delta));
        }
        return conflicts;
    }

    private boolean isResourceNodeContainerOrNameChanged(CDORevisionDelta delta) {
        if (delta.getFeatureDelta((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_NODE__NAME) != null) {
            return true;
        }
        return delta.getFeatureDelta((EStructuralFeature)CDOContainerFeatureDelta.CONTAINER_FEATURE) != null;
    }

    protected Map<String, CDOResourceNode> collectNewResourceNodes() {
        return Collections.emptyMap();
    }

    protected void handleConflicts(long lastUpdateTime, Map<CDOObject, Pair<CDORevision, CDORevisionDelta>> conflicts, List<CDORevisionDelta> deltas) {
    }

    public void fireAdaptersNotifiedEvent(long timeStamp) {
        this.fireEvent(new AdaptersNotifiedEvent(timeStamp));
    }

    private boolean isLocked(InternalCDOObject object) {
        if (object.cdoWriteLock().isLocked()) {
            return true;
        }
        return object.cdoReadLock().isLocked();
    }

    @Override
    @Deprecated
    public int reload(CDOObject ... objects) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            int n;
            this.lockView();
            try {
                ArrayList<InternalCDOObject> internalObjects;
                if (objects != null && objects.length != 0) {
                    internalObjects = new ArrayList(objects.length);
                    CDOObject[] cDOObjectArray = objects;
                    int n2 = objects.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        CDOObject object2 = cDOObjectArray[n3];
                        if (object2 instanceof InternalCDOObject) {
                            internalObjects.add((InternalCDOObject)object2);
                        }
                        ++n3;
                    }
                } else {
                    internalObjects = new ArrayList<InternalCDOObject>(this.objects.values());
                }
                int result = internalObjects.size();
                if (result != 0) {
                    CDOStateMachine.INSTANCE.reload(internalObjects.toArray(new InternalCDOObject[result]));
                }
                n = result;
                this.unlockView();
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            return n;
        }
    }

    public void close() {
        LifecycleUtil.deactivate((Object)this, (OMLogger.Level)OMLogger.Level.DEBUG);
    }

    public boolean isClosed() {
        return !this.isActive();
    }

    public Object getAdapter(Class adapter) {
        return AdapterUtil.adapt((Object)this, (Class)adapter, (boolean)false);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isReadOnly()) {
            builder.append("View");
        } else {
            builder.append("Transaction");
        }
        builder.append(" ");
        builder.append(this.getViewID());
        if (!this.isActive()) {
            builder.append(" [closed]");
        } else {
            CDOBranchPoint bp = this.branchPoint;
            if (bp != null) {
                long timeStamp;
                boolean brackets = false;
                if (this.getSession().getRepositoryInfo().isSupportingBranches()) {
                    brackets = true;
                    builder.append(" [");
                    builder.append(bp.getBranch().getPathName());
                }
                if ((timeStamp = bp.getTimeStamp()) != 0L) {
                    if (brackets) {
                        builder.append(", ");
                    } else {
                        builder.append(" [");
                        brackets = true;
                    }
                    builder.append(CDOCommonUtil.formatTimeStamp((long)timeStamp));
                }
                if (brackets) {
                    builder.append("]");
                }
            }
        }
        return builder.toString();
    }

    protected String getClassName() {
        return "CDOView";
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof ResourceSet;
    }

    public Notifier getTarget() {
        return this.getResourceSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void collectViewedRevisions(Map<CDOID, InternalCDORevision> revisions) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            this.lockView();
            try {
                for (InternalCDOObject object2 : this.objects.values()) {
                    InternalCDORevision revision;
                    CDOID id;
                    CDOState state = object2.cdoState();
                    if (state != CDOState.CLEAN && state != CDOState.DIRTY && state != CDOState.CONFLICT || revisions.containsKey(id = object2.cdoID()) || (revision = this.getViewedRevision(object2)) == null) continue;
                    revisions.put(id, revision);
                }
            }
            finally {
                this.unlockView();
            }
        }
    }

    protected InternalCDORevision getViewedRevision(InternalCDOObject object) {
        return CDOStateMachine.INSTANCE.readNoLoad(object);
    }

    @Override
    public CDOChangeSetData compareRevisions(CDOBranchPoint source) {
        Object object = this.getViewMonitor();
        synchronized (object) {
            CDOChangeSetData cDOChangeSetData;
            this.lockView();
            try {
                InternalCDOSession session = this.getSession();
                cDOChangeSetData = session.compareRevisions(source, (CDOBranchPoint)this);
                this.unlockView();
            }
            catch (Throwable throwable) {
                this.unlockView();
                throw throwable;
            }
            return cDOChangeSetData;
        }
    }

    public CDOCommitHistory getHistory() {
        CDOBranch branch = this.getBranch();
        InternalCDOCommitInfoManager commitInfoManager = this.getSession().getCommitInfoManager();
        return commitInfoManager.getHistory((Object)branch);
    }

    protected CDOCommitHistory createHistory(CDOObject key) {
        return new CDOObjectHistoryImpl(key);
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        LifecycleUtil.activate((Object)this.viewLock);
        CDOBranchPoint bp = this.branchPoint;
        if (bp != null) {
            this.basicSetBranchPoint(bp);
        }
    }

    protected void doDeactivate() throws Exception {
        ResourceSet resourceSet;
        if (this.viewSet != null && (resourceSet = this.viewSet.getResourceSet()) != null) {
            this.viewSet.getResourceSet().getURIConverter().getURIHandlers().remove((Object)this.getURIHandler());
        }
        LifecycleUtil.deactivate((Object)this.viewLock);
        this.viewSet = null;
        this.objects = null;
        this.store = null;
        this.resourcePathCache = null;
        this.lastLookupID = null;
        this.lastLookupObject = null;
        super.doDeactivate();
    }

    public static void setNextViewLock(Lock viewLock) {
        if (viewLock != null) {
            NEXT_VIEW_LOCK.set(viewLock);
        } else {
            NEXT_VIEW_LOCK.remove();
        }
    }

    public static boolean canHaveResourcePathImpact(CDORevisionDelta delta, CDOID rootResourceID) {
        CDOListFeatureDelta featureDelta;
        EClass eClass = delta.getEClass();
        if (EresourcePackage.Literals.CDO_RESOURCE_NODE.isSuperTypeOf(eClass) && delta.getFeatureDelta((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_NODE__NAME) != null) {
            return true;
        }
        if (eClass == EresourcePackage.Literals.CDO_RESOURCE_FOLDER && AbstractCDOView.canHaveResourcePathImpact(featureDelta = (CDOListFeatureDelta)delta.getFeatureDelta((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_FOLDER__NODES))) {
            return true;
        }
        return eClass == EresourcePackage.Literals.CDO_RESOURCE && rootResourceID == delta.getID() && AbstractCDOView.canHaveResourcePathImpact(featureDelta = (CDOListFeatureDelta)delta.getFeatureDelta((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE__CONTENTS));
    }

    private static boolean canHaveResourcePathImpact(CDOListFeatureDelta featureDelta) {
        if (featureDelta != null) {
            for (CDOFeatureDelta listChange : featureDelta.getListChanges()) {
                CDOFeatureDelta.Type type = listChange.getType();
                switch (type) {
                    case REMOVE: 
                    case CLEAR: 
                    case SET: 
                    case UNSET: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static void preventURIClash(CDOResourceNode node) {
        String oldName = node.getName();
        String oldBasename = node.getBasename();
        node.setBasename(String.valueOf(oldBasename) + SAFE_RENAME);
        OM.LOG.warn("URI clash: resource being instantiated had same URI as a resource already present locally; local resource was renamed from " + oldName + " to " + node.getName());
    }

    private final class AdaptersNotifiedEvent
    extends Event
    implements CDOViewAdaptersNotifiedEvent {
        private static final long serialVersionUID = 1L;
        private long timeStamp;

        public AdaptersNotifiedEvent(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        @Override
        public long getTimeStamp() {
            return this.timeStamp;
        }

        protected String formatEventName() {
            return "CDOViewAdaptersNotifiedEvent";
        }

        protected String formatAdditionalParameters() {
            return "timeStamp=" + this.timeStamp;
        }
    }

    private static final class BranchPointLock {
        private BranchPointLock() {
        }
    }

    private final class ContainerAdapter
    extends AdapterImpl {
        private ContainerAdapter() {
        }

        public AbstractCDOView getView() {
            return AbstractCDOView.this;
        }

        public void notifyChanged(Notification msg) {
            if (msg.isTouch()) {
                return;
            }
            if (msg.getFeature() != EresourcePackage.Literals.CDO_RESOURCE__CONTENTS) {
                return;
            }
            IListener[] listeners = AbstractCDOView.this.getListeners();
            if (listeners.length == 0) {
                return;
            }
            SingleDeltaContainerEvent event = null;
            int eventType = msg.getEventType();
            switch (eventType) {
                case 3: {
                    event = new SingleDeltaContainerEvent((IContainer)AbstractCDOView.this, (Object)((CDOResourceNode)msg.getNewValue()), IContainerDelta.Kind.ADDED);
                    break;
                }
                case 5: {
                    break;
                }
                case 4: {
                    event = new SingleDeltaContainerEvent((IContainer)AbstractCDOView.this, (Object)((CDOResourceNode)msg.getOldValue()), IContainerDelta.Kind.REMOVED);
                    break;
                }
                case 6: {
                    break;
                }
                case 2: {
                    break;
                }
            }
            if (event != null) {
                AbstractCDOView.this.fireEvent((IEvent)event, listeners);
            }
        }
    }

    protected abstract class Event
    extends org.eclipse.net4j.util.event.Event
    implements CDOViewEvent {
        private static final long serialVersionUID = 1L;

        public Event() {
            super((INotifier)AbstractCDOView.this);
        }

        @Override
        public AbstractCDOView getSource() {
            return (AbstractCDOView)super.getSource();
        }
    }

    private static final class NOOPMonitor {
        private NOOPMonitor() {
        }
    }

    private final class ViewProviderChangedEvent
    extends Event
    implements CDOViewProviderChangedEvent {
        private static final long serialVersionUID = 1L;
        private final CDOViewProvider oldProvider;
        private final CDOViewProvider provider;

        public ViewProviderChangedEvent(CDOViewProvider oldProvider, CDOViewProvider provider) {
            this.oldProvider = oldProvider;
            this.provider = provider;
        }

        @Override
        public CDOViewProvider getOldProvider() {
            return this.oldProvider;
        }

        @Override
        public CDOViewProvider getProvider() {
            return this.provider;
        }

        protected String formatEventName() {
            return "CDOViewProviderChangedEvent";
        }

        protected String formatAdditionalParameters() {
            return "oldProvider=" + this.oldProvider + ", provider=" + this.provider;
        }
    }

    private final class ViewTargetChangedEvent
    extends Event
    implements CDOViewTargetChangedEvent {
        private static final long serialVersionUID = 1L;
        private final CDOBranchPoint oldBranchPoint;
        private final CDOBranchPoint branchPoint;

        public ViewTargetChangedEvent(CDOBranchPoint oldBranchPoint, CDOBranchPoint branchPoint) {
            this.oldBranchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)oldBranchPoint);
            this.branchPoint = CDOBranchUtil.copyBranchPoint((CDOBranchPoint)branchPoint);
        }

        @Override
        public CDOBranchPoint getOldBranchPoint() {
            return this.oldBranchPoint;
        }

        @Override
        public CDOBranchPoint getBranchPoint() {
            return this.branchPoint;
        }

        protected String formatEventName() {
            return "CDOViewTargetChangedEvent";
        }

        protected String formatAdditionalParameters() {
            return "oldBranchPoint=" + this.oldBranchPoint + ", branchPoint=" + this.branchPoint;
        }
    }
}

