/*
 * Decompiled with CFR 0.152.
 */
package org.gastro.server.internal.web;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.acceptor.IAcceptor;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.gastro.business.BusinessDay;
import org.gastro.inventory.MenuCard;
import org.gastro.server.GastroServer;
import org.gastro.server.internal.web.OM;
import templates.MenuCardTemplate;

public class GastroServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private String restaurantName;
    private IAcceptor acceptor;
    private IConnector connector;
    private CDOView view;
    private MenuCard menuCard;
    private MenuCardTemplate template = MenuCardTemplate.create(StringUtil.NL);
    private IRepository repository;

    public void init() throws ServletException {
        this.repository = GastroServer.getRepository();
        if (this.repository == null) {
            return;
        }
        OM.LOG.info("Gastro servlet initializing");
        String repositoryName = this.repository.getName();
        this.restaurantName = GastroServlet.getRestaurantName();
        this.acceptor = Net4jUtil.getAcceptor((IManagedContainer)IPluginContainer.INSTANCE, (String)"jvm", (String)repositoryName);
        this.connector = Net4jUtil.getConnector((IManagedContainer)IPluginContainer.INSTANCE, (String)"jvm", (String)repositoryName);
        CDONet4jSessionConfiguration config = CDONet4jUtil.createNet4jSessionConfiguration();
        config.setConnector(this.connector);
        config.setRepositoryName(repositoryName);
        CDONet4jSession session = config.openNet4jSession();
        this.view = session.openView();
        super.init();
        OM.LOG.info("Gastro servlet initialized");
    }

    public void destroy() {
        CDONet4jSession session;
        if (this.repository == null) {
            return;
        }
        OM.LOG.info("Gastro servlet destroying");
        if (this.view != null && (session = (CDONet4jSession)this.view.getSession()) != null) {
            session.close();
        }
        if (this.connector != null) {
            this.connector.close();
        }
        if (this.acceptor != null) {
            this.acceptor.close();
        }
        super.destroy();
        OM.LOG.info("Gastro servlet destroyed");
    }

    public synchronized MenuCard getMenuCard() {
        if (this.menuCard == null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            String path = this.restaurantName + "/" + formatter.format(new Date());
            CDOResource resource = this.view.getResource(path);
            BusinessDay businessDay = (BusinessDay)resource.getContents().get(0);
            this.menuCard = businessDay.getMenuCard();
        }
        return this.menuCard;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PrintWriter writer = resp.getWriter();
        try {
            String html = this.template.generate(this.getMenuCard());
            writer.print(html);
        }
        finally {
            IOUtil.close((Closeable)writer);
        }
    }

    public static String getRestaurantName() throws ServletException {
        String string;
        String configPath = OMPlatform.INSTANCE.getProperty("servlet.config", "config/gastro.properties");
        InputStream stream = OM.BUNDLE.getInputStream(configPath);
        try {
            Properties properties = new Properties();
            properties.load(stream);
            string = properties.getProperty("restaurant");
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new ServletException((Throwable)ex);
            }
        }
        stream.close();
        return string;
    }

    public static String html(String value) {
        return StringEscapeUtils.escapeHtml((String)value);
    }

    public static String html(double value) {
        return GastroServlet.html(NumberFormat.getCurrencyInstance().format(value));
    }
}

