/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject.internal;

import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.match.eobject.EObjectIndex;
import org.eclipse.emf.compare.match.eobject.ProximityEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.ScopeQuery;
import org.eclipse.emf.compare.match.eobject.internal.ProximityIndex;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByTypeIndex
implements EObjectIndex {
    private LoadingCache<String, EObjectIndex> allIndexes;
    private ProximityEObjectMatcher.DistanceFunction meter;

    public ByTypeIndex(ProximityEObjectMatcher.DistanceFunction meter, final ScopeQuery scope) {
        this.meter = meter;
        this.allIndexes = CacheBuilder.newBuilder().build(CacheLoader.from((Function)new Function<String, EObjectIndex>(){

            public EObjectIndex apply(String input) {
                return new ProximityIndex(ByTypeIndex.this.meter, scope);
            }
        }));
    }

    @Override
    public Iterable<EObject> getValuesStillThere(EObjectIndex.Side side) {
        ArrayList allLists = Lists.newArrayList();
        for (EObjectIndex typeSpecificIndex : this.allIndexes.asMap().values()) {
            allLists.add(typeSpecificIndex.getValuesStillThere(side));
        }
        return Iterables.concat((Iterable)allLists);
    }

    @Override
    public Map<EObjectIndex.Side, EObject> findClosests(Comparison inProgress, EObject obj, EObjectIndex.Side side) {
        try {
            EObjectIndex typeSpecificIndex = (EObjectIndex)this.allIndexes.get((Object)this.eClassKey(obj));
            return typeSpecificIndex.findClosests(inProgress, obj, side);
        }
        catch (ExecutionException executionException) {
            return Collections.emptyMap();
        }
    }

    private String eClassKey(EObject obj) {
        EClass clazz = obj.eClass();
        if (clazz.getEPackage() != null) {
            return String.valueOf(clazz.getEPackage().getNsURI()) + ":" + clazz.getName();
        }
        return clazz.getName();
    }

    @Override
    public void remove(EObject obj, EObjectIndex.Side side) {
        try {
            EObjectIndex typeSpecificIndex = (EObjectIndex)this.allIndexes.get((Object)this.eClassKey(obj));
            typeSpecificIndex.remove(obj, side);
        }
        catch (ExecutionException executionException) {}
    }

    @Override
    public void index(EObject eObjs, EObjectIndex.Side side) {
        try {
            EObjectIndex typeSpecificIndex = (EObjectIndex)this.allIndexes.get((Object)this.eClassKey(eObjs));
            typeSpecificIndex.index(eObjs, side);
        }
        catch (ExecutionException executionException) {}
    }
}

