/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.CrossReferenceResolutionScope;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.Graph;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.RevisionedURIConverter;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.SynchronizedResourceSet;
import org.eclipse.emf.compare.ide.ui.internal.util.PlatformElementUtil;
import org.eclipse.emf.compare.ide.ui.logical.AbstractModelResolver;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadedModelResolver
extends AbstractModelResolver
implements Thread.UncaughtExceptionHandler {
    private static final Function<IStorage, URI> AS_URI = new Function<IStorage, URI>(){

        public URI apply(IStorage input) {
            if (input != null) {
                return ResourceUtil.createURIFor((IStorage)input);
            }
            return null;
        }
    };
    private final Graph<URI> dependencyGraph;
    private Set<URI> resolvedResources;
    private BasicDiagnostic diagnostic;
    private final Set<URI> currentlyResolving;
    private final ExecutorService resolvingPool;
    private final ExecutorService unloadingPool;
    private final ReentrantLock lock;
    private final Condition notResolving;
    private final Condition resolutionEnd;
    private ModelResourceListener resourceListener;
    private volatile CrossReferenceResolutionScope resolutionScope = CrossReferenceResolutionScope.CONTAINER;

    public ThreadedModelResolver() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        this.dependencyGraph = new Graph();
        this.lock = new ReentrantLock(true);
        this.notResolving = this.lock.newCondition();
        this.resolutionEnd = this.lock.newCondition();
        ThreadFactory resolvingThreadFactory = new ThreadFactoryBuilder().setNameFormat("EMFCompare-ResolvingThread-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)this).build();
        this.resolvingPool = Executors.newFixedThreadPool(availableProcessors, resolvingThreadFactory);
        ThreadFactory unloadingThreadFactory = new ThreadFactoryBuilder().setNameFormat("EMFCompare-UnloadingThread-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)this).build();
        this.unloadingPool = Executors.newFixedThreadPool(availableProcessors, unloadingThreadFactory);
        this.currentlyResolving = new HashSet<URI>();
    }

    @Override
    public void initialize() {
        this.resourceListener = new ModelResourceListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceListener);
    }

    @Override
    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceListener);
        this.shutdownAndAwaitTermination(this.resolvingPool);
        this.shutdownAndAwaitTermination(this.unloadingPool);
        super.dispose();
    }

    private void shutdownAndAwaitTermination(ExecutorService pool) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(5L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(5L, TimeUnit.SECONDS)) {
                    EMFCompareIDEUIPlugin.getDefault().log(4, "Pool did not terminate");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (!(e instanceof OperationCanceledException)) {
            if (this.diagnostic != null) {
                this.diagnostic.add(BasicDiagnostic.toDiagnostic((Throwable)e));
            } else {
                EMFCompareIDEUIPlugin.getDefault().log(e);
            }
        }
    }

    @Override
    public boolean canResolve(IStorage sourceStorage) {
        return true;
    }

    @Override
    public StorageTraversal resolveLocalModel(IResource start, IProgressMonitor monitor) throws InterruptedException {
        if (!(start instanceof IFile)) {
            return new StorageTraversal(new LinkedHashSet());
        }
        this.lock.lockInterruptibly();
        try {
            StorageTraversal traversal;
            while (!this.currentlyResolving.isEmpty()) {
                this.notResolving.await();
            }
            this.resolvedResources = new LinkedHashSet<URI>();
            this.diagnostic = new BasicDiagnostic("org.eclipse.emf.compare.ide.ui", 0, null, new Object[0]);
            if (this.getResolutionScope() != CrossReferenceResolutionScope.SELF) {
                SynchronizedResourceSet resourceSet = new SynchronizedResourceSet();
                this.updateDependencies(resourceSet, (IFile)start, monitor);
                this.updateChangedResources(resourceSet, monitor);
            }
            while (!this.currentlyResolving.isEmpty()) {
                this.resolutionEnd.await();
            }
            Set<IStorage> traversalSet = this.resolveTraversal((IFile)start, Collections.<URI>emptySet());
            StorageTraversal storageTraversal = traversal = new StorageTraversal(traversalSet, (Diagnostic)this.diagnostic);
            return storageTraversal;
        }
        finally {
            this.diagnostic = null;
            this.resolvedResources = null;
            this.notResolving.signal();
            this.lock.unlock();
        }
    }

    @Override
    public SynchronizationModel resolveLocalModels(IResource left, IResource right, IResource origin, IProgressMonitor monitor) throws InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        subMonitor.subTask(EMFCompareIDEUIMessages.getString("ModelResolver.resolvingLocalModel"));
        if (!(left instanceof IFile) || !(right instanceof IFile) || origin != null && !(origin instanceof IFile)) {
            StorageTraversal leftTraversal = this.resolveLocalModel(left, (IProgressMonitor)subMonitor.newChild(33));
            StorageTraversal rightTraversal = this.resolveLocalModel(right, (IProgressMonitor)subMonitor.newChild(33));
            StorageTraversal originTraversal = origin != null ? this.resolveLocalModel(origin, (IProgressMonitor)subMonitor.newChild(33)) : new StorageTraversal((Set)Sets.newLinkedHashSet());
            subMonitor.setWorkRemaining(0);
            return new SynchronizationModel(leftTraversal, rightTraversal, originTraversal);
        }
        this.lock.lockInterruptibly();
        try {
            SynchronizationModel synchronizationModel;
            Set<Object> originTraversal;
            Set<IStorage> rightTraversal;
            Set<IStorage> leftTraversal;
            URI originURI;
            ImmutableSet startingPoints;
            while (!this.currentlyResolving.isEmpty()) {
                this.notResolving.await();
            }
            this.resolvedResources = new LinkedHashSet<URI>();
            this.diagnostic = new BasicDiagnostic("org.eclipse.emf.compare.ide.ui", 0, null, new Object[0]);
            if (this.getResolutionScope() != CrossReferenceResolutionScope.SELF) {
                SynchronizedResourceSet resourceSet = new SynchronizedResourceSet();
                this.updateDependencies(resourceSet, (IFile)left, (IProgressMonitor)subMonitor.newChild(30));
                this.updateDependencies(resourceSet, (IFile)right, (IProgressMonitor)subMonitor.newChild(30));
                if (origin instanceof IFile) {
                    this.updateDependencies(resourceSet, (IFile)origin, (IProgressMonitor)subMonitor.newChild(30));
                } else {
                    subMonitor.setWorkRemaining(10);
                }
                this.updateChangedResources(resourceSet, (IProgressMonitor)subMonitor.newChild(10));
            }
            URI leftURI = ResourceUtil.createURIFor((IFile)((IFile)left));
            URI rightURI = ResourceUtil.createURIFor((IFile)((IFile)right));
            if (origin instanceof IFile) {
                startingPoints = ImmutableSet.of((Object)((IFile)left), (Object)((IFile)right), (Object)((IFile)origin));
                originURI = ResourceUtil.createURIFor((IFile)((IFile)origin));
            } else {
                startingPoints = ImmutableSet.of((Object)((IFile)left), (Object)((IFile)right));
                originURI = null;
            }
            while (!this.currentlyResolving.isEmpty()) {
                this.resolutionEnd.await();
            }
            if (origin instanceof IFile) {
                leftTraversal = this.resolveTraversal((IFile)left, (Set<URI>)ImmutableSet.of((Object)rightURI, (Object)originURI));
                rightTraversal = this.resolveTraversal((IFile)right, (Set<URI>)ImmutableSet.of((Object)leftURI, (Object)originURI));
                originTraversal = this.resolveTraversal((IFile)origin, (Set<URI>)ImmutableSet.of((Object)leftURI, (Object)rightURI));
            } else {
                leftTraversal = this.resolveTraversal((IFile)left, Collections.singleton(rightURI));
                rightTraversal = this.resolveTraversal((IFile)right, Collections.singleton(leftURI));
                originTraversal = Collections.emptySet();
            }
            Sets.SetView intersection = Sets.intersection(leftTraversal, rightTraversal);
            if (!originTraversal.isEmpty()) {
                intersection = Sets.intersection((Set)intersection, originTraversal);
            }
            this.logCoherenceThreats(Iterables.transform((Iterable)startingPoints, AS_URI), Iterables.transform((Iterable)intersection, AS_URI));
            LinkedHashSet actualLeft = new LinkedHashSet(Sets.difference(leftTraversal, (Set)intersection));
            LinkedHashSet actualRight = new LinkedHashSet(Sets.difference(rightTraversal, (Set)intersection));
            LinkedHashSet actualOrigin = new LinkedHashSet(Sets.difference(originTraversal, (Set)intersection));
            SynchronizationModel synchronizationModel2 = synchronizationModel = new SynchronizationModel(new StorageTraversal(actualLeft), new StorageTraversal(actualRight), new StorageTraversal(actualOrigin), (Diagnostic)this.diagnostic);
            return synchronizationModel2;
        }
        finally {
            this.diagnostic = null;
            this.resolvedResources = null;
            this.notResolving.signal();
            this.lock.unlock();
        }
    }

    @Override
    public SynchronizationModel resolveModels(IStorageProviderAccessor storageAccessor, IStorage left, IStorage right, IStorage origin, IProgressMonitor monitor) throws InterruptedException {
        this.lock.lockInterruptibly();
        try {
            while (!this.currentlyResolving.isEmpty()) {
                this.notResolving.await();
            }
            this.resolvedResources = new LinkedHashSet<URI>();
            this.diagnostic = new BasicDiagnostic("org.eclipse.emf.compare.ide.ui", 0, null, new Object[0]);
            IFile leftFile = PlatformElementUtil.adaptAs(left, IFile.class);
            SynchronizationModel synchronizationModel = leftFile != null ? this.resolveModelsWithLocal(storageAccessor, leftFile, right, origin, monitor) : this.resolveRemoteModels(storageAccessor, left, right, origin, monitor);
            SynchronizationModel synchronizationModel2 = synchronizationModel;
            return synchronizationModel2;
        }
        finally {
            this.resolvedResources = null;
            this.diagnostic = null;
            this.notResolving.signal();
            this.lock.unlock();
        }
    }

    private SynchronizationModel resolveModelsWithLocal(IStorageProviderAccessor storageAccessor, IFile left, IStorage right, IStorage origin, IProgressMonitor monitor) throws InterruptedException {
        if (this.getResolutionScope() != CrossReferenceResolutionScope.SELF) {
            SynchronizedResourceSet resourceSet = new SynchronizedResourceSet();
            this.updateDependencies(resourceSet, left, monitor);
            this.updateChangedResources(resourceSet, monitor);
        }
        Set<IStorage> leftTraversal = this.resolveTraversal(left, Collections.<URI>emptySet(), storageAccessor);
        while (!this.currentlyResolving.isEmpty()) {
            this.resolutionEnd.await();
        }
        Set<IStorage> rightTraversal = this.resolveRemoteTraversal(storageAccessor, right, leftTraversal, IStorageProviderAccessor.DiffSide.REMOTE, monitor);
        Set<Object> originTraversal = origin != null ? this.resolveRemoteTraversal(storageAccessor, origin, leftTraversal, IStorageProviderAccessor.DiffSide.ORIGIN, monitor) : Collections.emptySet();
        SynchronizationModel synchronizationModel = new SynchronizationModel(new StorageTraversal(leftTraversal), new StorageTraversal(rightTraversal), new StorageTraversal(originTraversal), (Diagnostic)this.diagnostic);
        return synchronizationModel;
    }

    private SynchronizationModel resolveRemoteModels(IStorageProviderAccessor storageAccessor, IStorage left, IStorage right, IStorage origin, IProgressMonitor monitor) throws InterruptedException {
        Set<IStorage> leftTraversal = this.resolveRemoteTraversal(storageAccessor, left, Collections.<IStorage>emptySet(), IStorageProviderAccessor.DiffSide.SOURCE, monitor);
        Set<IStorage> rightTraversal = this.resolveRemoteTraversal(storageAccessor, right, Collections.<IStorage>emptySet(), IStorageProviderAccessor.DiffSide.REMOTE, monitor);
        Set<Object> originTraversal = origin != null ? this.resolveRemoteTraversal(storageAccessor, origin, Collections.<IStorage>emptySet(), IStorageProviderAccessor.DiffSide.ORIGIN, monitor) : Collections.emptySet();
        SynchronizationModel synchronizationModel = new SynchronizationModel(new StorageTraversal(leftTraversal), new StorageTraversal(rightTraversal), new StorageTraversal(originTraversal), (Diagnostic)this.diagnostic);
        return synchronizationModel;
    }

    private void updateChangedResources(SynchronizedResourceSet resourceSet, IProgressMonitor monitor) {
        Sets.SetView removedURIs = Sets.difference(this.resourceListener.popRemovedURIs(), this.resolvedResources);
        Sets.SetView changedURIs = Sets.difference(this.resourceListener.popChangedURIs(), this.resolvedResources);
        this.dependencyGraph.removeAll((Collection<URI>)removedURIs);
        LinkedHashSet<URI> recompute = new LinkedHashSet<URI>((Collection<URI>)changedURIs);
        for (URI changed : changedURIs) {
            recompute.addAll(this.dependencyGraph.getDirectParents(changed));
        }
        this.dependencyGraph.removeAll((Collection<URI>)changedURIs);
        for (URI changed : recompute) {
            this.demandResolve(resourceSet, changed, monitor);
        }
    }

    private void updateDependencies(SynchronizedResourceSet resourceSet, IFile file, IProgressMonitor monitor) {
        URI expectedURI = ResourceUtil.createURIFor((IFile)file);
        if (!this.dependencyGraph.contains(expectedURI)) {
            IResource startingPoint = this.getResolutionStartingPoint(file);
            ModelResourceVisitor modelVisitor = new ModelResourceVisitor(resourceSet, monitor);
            try {
                startingPoint.accept((IResourceVisitor)modelVisitor);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private IResource getResolutionStartingPoint(IFile file) {
        IFile startingPoint;
        switch (this.getResolutionScope()) {
            case WORKSPACE: {
                startingPoint = ResourcesPlugin.getWorkspace().getRoot();
                break;
            }
            case PROJECT: {
                startingPoint = file.getProject();
                break;
            }
            case CONTAINER: {
                startingPoint = file.getParent();
                break;
            }
            default: {
                startingPoint = file;
            }
        }
        return startingPoint;
    }

    private CrossReferenceResolutionScope getResolutionScope() {
        return this.resolutionScope;
    }

    public void setResolutionScope(CrossReferenceResolutionScope resolutionScope) {
        this.resolutionScope = resolutionScope;
    }

    private Set<IStorage> resolveTraversal(IFile file, Set<URI> bounds) {
        LinkedHashSet<IStorage> traversal = new LinkedHashSet<IStorage>();
        Iterable<URI> dependencies = this.getDependenciesOf(file, bounds);
        for (URI uri : dependencies) {
            traversal.add((IStorage)this.getFileAt(uri));
        }
        return traversal;
    }

    private Set<IStorage> resolveTraversal(IFile file, Set<URI> bounds, IStorageProviderAccessor storageAccessor) {
        LinkedHashSet<IStorage> traversal = new LinkedHashSet<IStorage>();
        Iterable<URI> dependencies = this.getDependenciesOf(file, bounds);
        for (URI uri : dependencies) {
            IFile dependencyFile = this.getFileAt(uri);
            try {
                if (storageAccessor.isInSync((IResource)dependencyFile)) continue;
                traversal.add((IStorage)dependencyFile);
            }
            catch (CoreException coreException) {}
        }
        return traversal;
    }

    private Set<IStorage> resolveRemoteTraversal(IStorageProviderAccessor storageAccessor, IStorage start, Set<IStorage> localVariants, IStorageProviderAccessor.DiffSide side, IProgressMonitor monitor) throws InterruptedException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(localVariants.size() + 1));
        SynchronizedResourceSet resourceSet = new SynchronizedResourceSet();
        RevisionedURIConverter converter = new RevisionedURIConverter(resourceSet.getURIConverter(), storageAccessor, side);
        resourceSet.setURIConverter((URIConverter)converter);
        this.resolvedResources = new LinkedHashSet<URI>();
        for (IStorage local : localVariants) {
            URI expectedURI = ResourceUtil.createURIFor((IStorage)local);
            this.demandRemoteResolve(resourceSet, expectedURI, (IProgressMonitor)subMonitor.newChild(1));
        }
        URI startURI = ResourceUtil.createURIFor((IStorage)start);
        this.demandRemoteResolve(resourceSet, startURI, (IProgressMonitor)subMonitor.newChild(1));
        while (!this.currentlyResolving.isEmpty()) {
            this.resolutionEnd.await();
        }
        this.resolvedResources = null;
        return converter.getLoadedRevisions();
    }

    private Iterable<URI> getDependenciesOf(IFile file, Set<URI> bounds) {
        Iterable<Object> dependencies;
        URI expectedURI = ResourceUtil.createURIFor((IFile)file);
        switch (this.getResolutionScope()) {
            case WORKSPACE: {
                dependencies = this.dependencyGraph.getSubgraphContaining(expectedURI, bounds);
                break;
            }
            case PROJECT: {
                Set<URI> allDependencies = this.dependencyGraph.getSubgraphContaining(expectedURI, bounds);
                IProject project = file.getProject();
                dependencies = Iterables.filter(allDependencies, this.isInContainer((IResource)project));
                break;
            }
            case CONTAINER: {
                Set<URI> allDependencies1 = this.dependencyGraph.getSubgraphContaining(expectedURI, bounds);
                IContainer container = file.getParent();
                dependencies = Iterables.filter(allDependencies1, this.isInContainer((IResource)container));
                break;
            }
            case OUTGOING: {
                dependencies = this.dependencyGraph.getTreeFrom(expectedURI, bounds);
                break;
            }
            default: {
                dependencies = Collections.singleton(expectedURI);
            }
        }
        return dependencies;
    }

    private IFile getFileAt(URI uri) {
        StringBuilder path = new StringBuilder();
        List segments = uri.segmentsList();
        if (uri.isPlatformResource()) {
            segments = segments.subList(1, segments.size());
        }
        for (String segment : segments) {
            path.append(URI.decode((String)segment)).append('/');
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path.toString()));
    }

    private Predicate<URI> isInContainer(final IResource container) {
        return new Predicate<URI>(){

            public boolean apply(URI input) {
                IFile pointedFile;
                if (input != null && (pointedFile = ThreadedModelResolver.this.getFileAt(input)) != null) {
                    return container.getLocation().isPrefixOf(pointedFile.getLocation());
                }
                return false;
            }
        };
    }

    private void logCoherenceThreats(Iterable<URI> startingPoints, Iterable<URI> removedFromModel) {
        LinkedHashSet<URI> coherenceThreats = new LinkedHashSet<URI>();
        for (URI start : startingPoints) {
            for (URI removed : removedFromModel) {
                if (!this.dependencyGraph.hasChild(removed, start)) continue;
                coherenceThreats.add(removed);
            }
        }
        if (!coherenceThreats.isEmpty()) {
            String message = EMFCompareIDEUIMessages.getString("ModelResolver.coherenceWarning");
            String details = Iterables.toString(coherenceThreats);
            EMFCompareIDEUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.emf.compare.ide.ui", String.valueOf(message) + '\n' + details));
        }
    }

    protected void demandResolve(SynchronizedResourceSet resourceSet, URI uri, IProgressMonitor monitor) {
        this.lock.lock();
        try {
            if (this.resolvedResources.add(uri) && this.currentlyResolving.add(uri)) {
                this.resolvingPool.execute(new ResourceResolver(resourceSet, uri, monitor));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void demandRemoteResolve(SynchronizedResourceSet resourceSet, URI uri, IProgressMonitor monitor) {
        this.lock.lock();
        try {
            if (this.resolvedResources.add(uri) && this.currentlyResolving.add(uri)) {
                this.resolvingPool.execute(new RemoteResourceResolver(resourceSet, uri, monitor));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void demandUnload(SynchronizedResourceSet resourceSet, Resource resource, IProgressMonitor monitor) {
        this.unloadingPool.execute(new ResourceUnloader(resourceSet, resource, monitor));
    }

    private void safeMergeDiagnostic(Diagnostic resourceDiagnostic) {
        this.lock.lock();
        try {
            this.diagnostic.merge(resourceDiagnostic);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModelResourceListener
    implements IResourceChangeListener {
        protected final Set<URI> changedURIs = new LinkedHashSet<URI>();
        protected final Set<URI> removedURIs = new LinkedHashSet<URI>();
        protected final ReentrantLock internalLock = new ReentrantLock();

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            this.internalLock.lock();
            try {
                try {
                    delta.accept((IResourceDeltaVisitor)new ModelResourceDeltaVisitor());
                }
                catch (CoreException e) {
                    EMFCompareIDEUIPlugin.getDefault().log(e);
                    this.internalLock.unlock();
                }
            }
            finally {
                this.internalLock.unlock();
            }
        }

        public Set<URI> popChangedURIs() {
            ImmutableSet changed;
            this.internalLock.lock();
            try {
                changed = ImmutableSet.copyOf(this.changedURIs);
                this.changedURIs.clear();
            }
            finally {
                this.internalLock.unlock();
            }
            return changed;
        }

        public Set<URI> popRemovedURIs() {
            ImmutableSet removed;
            this.internalLock.lock();
            try {
                removed = ImmutableSet.copyOf(this.removedURIs);
                this.removedURIs.clear();
            }
            finally {
                this.internalLock.unlock();
            }
            return removed;
        }

        private class ModelResourceDeltaVisitor
        implements IResourceDeltaVisitor {
            private ModelResourceDeltaVisitor() {
            }

            public boolean visit(IResourceDelta delta) throws CoreException {
                if (delta.getFlags() == 131072 || delta.getResource().getType() != 1) {
                    return true;
                }
                IFile file = (IFile)delta.getResource();
                URI fileURI = ResourceUtil.createURIFor((IFile)file);
                if (delta.getKind() == 2) {
                    ModelResourceListener.this.removedURIs.add(fileURI);
                    ModelResourceListener.this.changedURIs.remove(fileURI);
                } else if (ResourceUtil.hasModelType((IFile)file) && (delta.getKind() & 5) != 0) {
                    ModelResourceListener.this.changedURIs.add(fileURI);
                    ModelResourceListener.this.removedURIs.remove(fileURI);
                }
                return true;
            }
        }
    }

    private class ModelResourceVisitor
    implements IResourceVisitor {
        private final SynchronizedResourceSet resourceSet;
        private final IProgressMonitor monitor;

        public ModelResourceVisitor(SynchronizedResourceSet resourceSet, IProgressMonitor monitor) {
            this.resourceSet = resourceSet;
            this.monitor = monitor;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (ResourceUtil.hasModelType((IFile)file)) {
                    URI expectedURI = ResourceUtil.createURIFor((IFile)file);
                    ThreadedModelResolver.this.demandResolve(this.resourceSet, expectedURI, this.monitor);
                }
                return false;
            }
            return true;
        }
    }

    private class RemoteResourceResolver
    implements Runnable {
        private final SynchronizedResourceSet resourceSet;
        private final URI uri;
        private final IProgressMonitor monitor;

        public RemoteResourceResolver(SynchronizedResourceSet resourceSet, URI uri, IProgressMonitor monitor) {
            this.resourceSet = resourceSet;
            this.uri = uri;
            this.monitor = monitor;
        }

        public void run() {
            try {
                Resource resource = this.resourceSet.loadResource(this.uri);
                Diagnostic resourceDiagnostic = EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true);
                if (resourceDiagnostic.getSeverity() >= 2) {
                    ThreadedModelResolver.this.safeMergeDiagnostic(resourceDiagnostic);
                }
                if (ThreadedModelResolver.this.getResolutionScope() != CrossReferenceResolutionScope.SELF) {
                    Set<URI> crossReferencedResources = this.resourceSet.discoverCrossReferences(resource, this.monitor);
                    for (URI crossRef : crossReferencedResources) {
                        ThreadedModelResolver.this.demandRemoteResolve(this.resourceSet, crossRef, this.monitor);
                    }
                }
                ThreadedModelResolver.this.demandUnload(this.resourceSet, resource, this.monitor);
            }
            finally {
                ThreadedModelResolver.this.lock.lock();
                try {
                    ThreadedModelResolver.this.currentlyResolving.remove(this.uri);
                    if (ThreadedModelResolver.this.currentlyResolving.isEmpty()) {
                        ThreadedModelResolver.this.resolutionEnd.signal();
                    }
                }
                finally {
                    ThreadedModelResolver.this.lock.unlock();
                }
            }
        }
    }

    private class ResourceResolver
    implements Runnable {
        private final SynchronizedResourceSet resourceSet;
        private final URI uri;
        private final IProgressMonitor monitor;

        public ResourceResolver(SynchronizedResourceSet resourceSet, URI uri, IProgressMonitor monitor) {
            this.resourceSet = resourceSet;
            this.uri = uri;
            this.monitor = monitor;
        }

        public void run() {
            try {
                Resource resource = this.resourceSet.loadResource(this.uri);
                Diagnostic resourceDiagnostic = EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true);
                if (resourceDiagnostic.getSeverity() >= 2) {
                    ThreadedModelResolver.this.safeMergeDiagnostic(resourceDiagnostic);
                }
                ThreadedModelResolver.this.dependencyGraph.add(this.uri);
                if (ThreadedModelResolver.this.getResolutionScope() != CrossReferenceResolutionScope.SELF) {
                    Set<URI> crossReferencedResources = this.resourceSet.discoverCrossReferences(resource, this.monitor);
                    ThreadedModelResolver.this.dependencyGraph.addChildren(this.uri, crossReferencedResources);
                    for (URI crossRef : crossReferencedResources) {
                        ThreadedModelResolver.this.demandResolve(this.resourceSet, crossRef, this.monitor);
                    }
                }
                ThreadedModelResolver.this.demandUnload(this.resourceSet, resource, this.monitor);
            }
            finally {
                ThreadedModelResolver.this.lock.lock();
                try {
                    ThreadedModelResolver.this.currentlyResolving.remove(this.uri);
                    if (ThreadedModelResolver.this.currentlyResolving.isEmpty()) {
                        ThreadedModelResolver.this.resolutionEnd.signal();
                    }
                }
                finally {
                    ThreadedModelResolver.this.lock.unlock();
                }
            }
        }
    }

    private static class ResourceUnloader
    implements Runnable {
        private final SynchronizedResourceSet resourceSet;
        private final Resource resource;
        private final IProgressMonitor monitor;

        public ResourceUnloader(SynchronizedResourceSet resourceSet, Resource resource, IProgressMonitor monitor) {
            this.resourceSet = resourceSet;
            this.resource = resource;
            this.monitor = monitor;
        }

        public void run() {
            this.resourceSet.unload(this.resource, this.monitor);
        }
    }
}

