/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroup;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.extender.IDifferenceGroupExtender;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.tree.TreeFactory;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDifferenceGroupImpl
extends AdapterImpl
implements IDifferenceGroup {
    protected static final Function<EObject, Iterator<EObject>> E_ALL_CONTENTS = new Function<EObject, Iterator<EObject>>(){

        public Iterator<EObject> apply(EObject eObject) {
            return eObject.eAllContents();
        }
    };
    protected final Predicate<? super Diff> filter;
    protected final String name;
    protected final Image image;
    protected List<TreeNode> children;
    protected Set<Diff> extensionDiffProcessed;
    private final Comparison comparison;
    private final IDifferenceGroupExtender.Registry registry = EMFCompareRCPUIPlugin.getDefault().getDifferenceGroupExtenderRegistry();
    private final ECrossReferenceAdapter crossReferenceAdapter;
    protected static final Function<Diff, ChildrenSide> DIFF_TO_SIDE = new Function<Diff, ChildrenSide>(){

        public ChildrenSide apply(Diff diff) {
            Conflict c;
            ChildrenSide side = diff != null ? ((c = diff.getConflict()) != null && Predicates.or((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO}), (Predicate)Predicates.and((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}), (Predicate)EMFComparePredicates.ofKind((DifferenceKind)DifferenceKind.ADD))).apply((Object)diff) ? ChildrenSide.getValueFrom(diff.getSource()) : ChildrenSide.BOTH) : ChildrenSide.BOTH;
            return side;
        }
    };

    public BasicDifferenceGroupImpl(Comparison comparison, Predicate<? super Diff> filter, ECrossReferenceAdapter crossReferenceAdapter) {
        this(comparison, filter, EMFCompareRCPUIMessages.getString("BasicDifferenceGroup.name"), EMFCompareRCPUIPlugin.getImage("icons/full/toolb16/group.gif"), crossReferenceAdapter);
    }

    public BasicDifferenceGroupImpl(Comparison comparison, Predicate<? super Diff> filter, String name, ECrossReferenceAdapter crossReferenceAdapter) {
        this(comparison, filter, name, EMFCompareRCPUIPlugin.getImage("icons/full/toolb16/group.gif"), crossReferenceAdapter);
    }

    public BasicDifferenceGroupImpl(Comparison comparison, Predicate<? super Diff> filter, String name, Image image, ECrossReferenceAdapter crossReferenceAdapter) {
        this.comparison = comparison;
        this.filter = filter;
        this.name = name;
        this.image = image;
        this.crossReferenceAdapter = crossReferenceAdapter;
    }

    protected final Comparison getComparison() {
        return this.comparison;
    }

    public boolean isAdapterForType(Object type) {
        return type == IDifferenceGroup.class;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IStyledString.IComposedStyledString getStyledName() {
        ComposedStyledString ret = new ComposedStyledString();
        Iterator eAllContents = Iterators.concat((Iterator)Iterators.transform(this.getChildren().iterator(), E_ALL_CONTENTS));
        Iterator eAllData = Iterators.transform((Iterator)eAllContents, (Function)TREE_NODE_DATA);
        boolean unresolvedDiffs = Iterators.any((Iterator)Iterators.filter((Iterator)eAllData, Diff.class), (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}));
        if (unresolvedDiffs) {
            ret.append("> ", IStyledString.Style.DECORATIONS_STYLER);
        }
        ret.append(this.getName());
        return ret;
    }

    @Override
    public Image getImage() {
        return this.image;
    }

    @Override
    public List<? extends TreeNode> getChildren() {
        if (this.children == null) {
            TreeNode buildSubTree;
            this.children = Lists.newArrayList();
            this.extensionDiffProcessed = Sets.newLinkedHashSet();
            for (Match match : this.comparison.getMatches()) {
                buildSubTree = this.buildSubTree((Match)null, match);
                if (buildSubTree == null) continue;
                this.children.addAll((Collection<TreeNode>)buildSubTree);
            }
            for (MatchResource matchResource : this.comparison.getMatchedResources()) {
                buildSubTree = this.buildSubTree(matchResource);
                if (buildSubTree == null) continue;
                this.children.add(buildSubTree);
            }
            this.registerCrossReferenceAdapter(this.children);
        }
        return this.children;
    }

    protected final void registerCrossReferenceAdapter(List<? extends Notifier> notifiers) {
        for (Notifier notifier : notifiers) {
            notifier.eAdapters().add((Object)this.crossReferenceAdapter);
        }
    }

    protected final void unregisterCrossReferenceAdapter(List<? extends Notifier> notifiers) {
        for (Notifier notifier : notifiers) {
            notifier.eAdapters().remove((Object)this.crossReferenceAdapter);
        }
    }

    protected TreeNode buildSubTree(MatchResource matchResource) {
        TreeNode treeNode = this.wrap((EObject)matchResource);
        for (Match match : this.comparison.getMatches()) {
            treeNode.getChildren().addAll(this.buildSubTree(matchResource, match));
        }
        return treeNode;
    }

    protected List<TreeNode> buildSubTree(MatchResource matchResource, Match match) {
        ArrayList ret = Lists.newArrayList();
        if (this.isRootOfResourceURI(match.getLeft(), matchResource.getLeftURI()) || this.isRootOfResourceURI(match.getRight(), matchResource.getRightURI()) || this.isRootOfResourceURI(match.getOrigin(), matchResource.getOriginURI())) {
            Collection resourceAttachmentChanges = Collections2.filter((Collection)match.getDifferences(), (Predicate)Predicates.and(this.filter, BasicDifferenceGroupImpl.resourceAttachmentChange()));
            for (Diff diff : resourceAttachmentChanges) {
                ret.add(this.wrap((EObject)diff));
            }
        } else {
            for (Match subMatch : match.getSubmatches()) {
                ret.addAll(this.buildSubTree(matchResource, subMatch));
            }
        }
        return ret;
    }

    public List<TreeNode> buildSubTree(Match parentMatch, Match match) {
        return this.buildSubTree(match, false, ChildrenSide.BOTH);
    }

    public List<TreeNode> buildContainmentSubTree(Match match) {
        return this.buildSubTree(match, true, ChildrenSide.BOTH);
    }

    protected List<TreeNode> buildSubTree(Match match, boolean containment, ChildrenSide side) {
        ArrayList ret = Lists.newArrayList();
        LinkedHashSet nodeChildren = Sets.newLinkedHashSet();
        LinkedHashSet matchOfValues = Sets.newLinkedHashSet();
        TreeNode matchTreeNode = this.wrap((EObject)match);
        if (!containment) {
            ret.add(matchTreeNode);
        }
        boolean hasDiff = false;
        for (Diff diff : Collections2.filter((Collection)match.getDifferences(), (Predicate)Predicates.and(this.filter, BasicDifferenceGroupImpl.compatibleSide(side)))) {
            if (EMFComparePredicates.CONTAINMENT_REFERENCE_CHANGE.apply((Object)diff)) {
                TreeNode node;
                hasDiff = true;
                if (containment) {
                    node = this.wrap((EObject)diff);
                    ret.add(node);
                } else {
                    node = this.buildSubTree(diff);
                    nodeChildren.add(node);
                }
                Match matchOfValue = match.getComparison().getMatch(((ReferenceChange)diff).getValue());
                matchOfValues.add(matchOfValue);
                node.getChildren().addAll(this.buildSubTree(matchOfValue, true, (ChildrenSide)((Object)DIFF_TO_SIDE.apply((Object)diff))));
                if (containment) {
                    ret.addAll(this.manageRefines(diff));
                    continue;
                }
                nodeChildren.addAll(this.manageRefines(diff));
                continue;
            }
            if (diff instanceof ResourceAttachmentChange || diff.getPrimeRefining() != null && this.extensionDiffProcessed.contains(diff)) continue;
            hasDiff = true;
            if (containment) {
                ret.add(this.wrap((EObject)diff));
                continue;
            }
            nodeChildren.add(this.buildSubTree(diff));
        }
        ArrayList toRemove = Lists.newArrayList();
        for (TreeNode treeNode : ret) {
            boolean hasNonEmptySubMatch = false;
            for (Match subMatch : Sets.difference((Set)Sets.newLinkedHashSet((Iterable)match.getSubmatches()), (Set)matchOfValues)) {
                List<TreeNode> buildSubTree = this.buildSubTree(subMatch, containment, ChildrenSide.BOTH);
                if (buildSubTree.isEmpty()) continue;
                hasNonEmptySubMatch = true;
                treeNode.getChildren().addAll(buildSubTree);
            }
            treeNode.getChildren().addAll((Collection)nodeChildren);
            if (!(containment || hasDiff || hasNonEmptySubMatch || this.filter.equals((Object)Predicates.alwaysTrue()))) {
                toRemove.add(treeNode);
                continue;
            }
            if (!containment && this.isMatchWithOnlyResourceAttachmentChanges(match)) {
                toRemove.add(treeNode);
                continue;
            }
            for (IDifferenceGroupExtender ext : this.registry.getExtenders()) {
                if (!ext.handle(treeNode)) continue;
                ext.addChildren(treeNode);
            }
        }
        ret.removeAll(toRemove);
        return ret;
    }

    private List<TreeNode> manageRefines(Diff diff) {
        ArrayList ret = Lists.newArrayList();
        EList refines = diff.getRefines();
        for (Diff refine : refines) {
            Diff mainDiff = refine.getPrimeRefining();
            if (mainDiff == null || mainDiff != diff) continue;
            TreeNode refineSubTree = this.buildSubTree(refine);
            ret.add(refineSubTree);
            this.extensionDiffProcessed.add(refine);
        }
        return ret;
    }

    protected TreeNode buildSubTree(Diff diff) {
        TreeNode treeNode = this.wrap((EObject)diff);
        for (IDifferenceGroupExtender ext : this.registry.getExtenders()) {
            if (!ext.handle(treeNode)) continue;
            ext.addChildren(treeNode);
        }
        return treeNode;
    }

    protected boolean isRootOfResourceURI(EObject eObject, String uri) {
        if (eObject != null && uri != null) {
            Resource resource = eObject.eResource();
            return resource != null && uri.equals(resource.getURI().toString());
        }
        return false;
    }

    protected static Predicate<? super Diff> resourceAttachmentChange() {
        return Predicates.instanceOf(ResourceAttachmentChange.class);
    }

    public boolean matchWithLeftAndRightInDifferentContainer(Match match) {
        EObject left = match.getLeft();
        EObject right = match.getRight();
        if (left != null && right != null) {
            return this.comparison.getMatch(left.eContainer()) != this.comparison.getMatch(right.eContainer());
        }
        return false;
    }

    protected boolean containsChildrenWithDataEqualsToDiff(TreeNode treeNode, Diff diff) {
        for (TreeNode child : treeNode.getChildren()) {
            if (diff != child.getData()) continue;
            return true;
        }
        return false;
    }

    protected Predicate<Diff> containmentReferenceForMatch(Match subMatch) {
        return Predicates.and((Predicate[])new Predicate[]{this.filter, EMFComparePredicates.CONTAINMENT_REFERENCE_CHANGE, Predicates.or((Predicate[])new Predicate[]{EMFComparePredicates.valueIs((Object)subMatch.getLeft()), EMFComparePredicates.valueIs((Object)subMatch.getRight()), EMFComparePredicates.valueIs((Object)subMatch.getOrigin())})});
    }

    protected TreeNode wrap(EObject data) {
        TreeNode treeNode = TreeFactory.eINSTANCE.createTreeNode();
        treeNode.setData(data);
        treeNode.eAdapters().add((Object)this);
        return treeNode;
    }

    private boolean isMatchWithOnlyResourceAttachmentChanges(Match match) {
        boolean ret = false;
        Iterable allDifferences = match.getAllDifferences();
        if (Iterables.isEmpty((Iterable)allDifferences)) {
            ret = false;
        } else if (Iterables.all((Iterable)allDifferences, (Predicate)Predicates.instanceOf(ResourceAttachmentChange.class)) && (match.getSubmatches() == null || match.getSubmatches().isEmpty())) {
            ret = true;
        }
        return ret;
    }

    @Override
    public void dispose() {
        if (this.children != null) {
            this.unregisterCrossReferenceAdapter(this.children);
            this.children = null;
        }
    }

    protected static Predicate<? super Diff> compatibleSide(final ChildrenSide side) {
        return new Predicate<Diff>(){

            public boolean apply(Diff input) {
                if (input != null && side != ChildrenSide.BOTH) {
                    return side == ChildrenSide.getValueFrom(input.getSource());
                }
                return side == ChildrenSide.BOTH;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ChildrenSide {
        BOTH,
        LEFT,
        RIGHT;


        public static ChildrenSide getValueFrom(DifferenceSource source) {
            switch (source) {
                case LEFT: {
                    return LEFT;
                }
                case RIGHT: {
                    return RIGHT;
                }
            }
            return BOTH;
        }
    }
}

