/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.internal.postprocessor.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UMLCompareUtil {
    private UMLCompareUtil() {
    }

    public static Element getBaseElement(EObject stereotypeApplication) {
        if (stereotypeApplication == null) {
            return null;
        }
        Element baseElement = UMLUtil.getBaseElement((EObject)stereotypeApplication);
        Iterator features = stereotypeApplication.eClass().getEAllStructuralFeatures().iterator();
        while (features.hasNext() && baseElement == null) {
            Object value;
            EStructuralFeature feature = (EStructuralFeature)features.next();
            if (!feature.getName().startsWith("base_") || !((value = stereotypeApplication.eGet(feature)) instanceof Element)) continue;
            baseElement = (Element)value;
        }
        return baseElement;
    }

    public static Iterable<EReference> getNonUnionSupersetReferences(EReference reference) {
        return Iterables.filter(UMLCompareUtil.getSupersetReferences(reference), UMLCompareUtil.isNonUnionReference());
    }

    private static Predicate<? super EReference> isNonUnionReference() {
        return new Predicate<EReference>(){

            public boolean apply(EReference input) {
                return input != null && !Iterables.any((Iterable)input.getEAnnotations(), UMLUtilForCompare.isUnionAnnotation());
            }
        };
    }

    private static Iterable<EReference> getSupersetReferences(EReference reference) {
        EAnnotation subsetsAnnotation = (EAnnotation)Iterables.find((Iterable)reference.getEAnnotations(), UMLUtilForCompare.isSubsetsAnnotation(), null);
        if (subsetsAnnotation != null) {
            return Iterables.filter((Iterable)subsetsAnnotation.getReferences(), EReference.class);
        }
        return Collections.emptyList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UMLUtilForCompare
    extends UMLUtil {
        private UMLUtilForCompare() {
        }

        public static Predicate<? super EAnnotation> isSubsetsAnnotation() {
            return new Predicate<EAnnotation>(){

                public boolean apply(EAnnotation input) {
                    return input != null && input.getSource().equals("subsets");
                }
            };
        }

        public static Predicate<? super EAnnotation> isUnionAnnotation() {
            return new Predicate<EAnnotation>(){

                public boolean apply(EAnnotation input) {
                    return input != null && input.getSource().equals("union");
                }
            };
        }
    }
}

