/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.diff;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.diff.data.FeatureMapMoveDiffInputData;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Test;

public class FeatureMapMoveDiffTest {
    private FeatureMapMoveDiffInputData input = new FeatureMapMoveDiffInputData();

    @Test
    public void testFeatureMapMoveDiffs() throws IOException {
        Resource left = this.input.getFeatureMapMoveLeft();
        Resource right = this.input.getFeatureMapMoveRight();
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)right, (Notifier)left, null);
        Comparison comparison = EMFCompare.builder().build().compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertEquals((long)6L, (long)differences.size());
        ArrayList<Diff> moveDifferences = new ArrayList<Diff>(2);
        for (Diff diff : differences) {
            if (!(diff instanceof ReferenceChange) || diff.getKind() != DifferenceKind.MOVE) continue;
            moveDifferences.add(diff);
        }
        Assert.assertEquals((long)2L, (long)moveDifferences.size());
        for (Diff mdiff : moveDifferences) {
            Assert.assertEquals((long)2L, (long)mdiff.getEquivalence().getDifferences().size());
            boolean foundFeatureMapChange = false;
            for (Diff equivalent : mdiff.getEquivalence().getDifferences()) {
                if (equivalent == mdiff) continue;
                Assert.assertTrue((boolean)(equivalent instanceof FeatureMapChange));
                foundFeatureMapChange = true;
            }
            if (foundFeatureMapChange) continue;
            Assert.fail((String)"ReferenceChange should have FeatureMapChange as equivalent");
        }
    }
}

