/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.utils;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.junit.Assert;
import org.junit.Test;

public class EMFComparePredicatesTest {
    private CompareFactory factory = CompareFactory.eINSTANCE;

    @Test
    public void testAnyRefiningWithoutRecursion() {
        Comparison comp = this.factory.createComparison();
        Match rootMatch = this.factory.createMatch();
        comp.getMatches().add((Object)rootMatch);
        AttributeChange ac = this.factory.createAttributeChange();
        ReferenceChange rc1 = this.factory.createReferenceChange();
        ReferenceChange rc2 = this.factory.createReferenceChange();
        ReferenceChange rc3 = this.factory.createReferenceChange();
        EList diffs = rootMatch.getDifferences();
        diffs.add((Object)ac);
        diffs.add((Object)rc1);
        diffs.add((Object)rc2);
        diffs.add((Object)rc3);
        ac.getRefinedBy().addAll(Arrays.asList(rc1, rc2, rc3));
        Assert.assertFalse((boolean)EMFComparePredicates.anyRefining((Predicate)Predicates.instanceOf(AttributeChange.class)).apply((Object)ac));
        Assert.assertTrue((boolean)EMFComparePredicates.anyRefining((Predicate)Predicates.instanceOf(ReferenceChange.class)).apply((Object)ac));
        Assert.assertTrue((boolean)EMFComparePredicates.anyRefining((Predicate)Predicates.equalTo((Object)rc3)).apply((Object)ac));
    }

    @Test
    public void testAnyRefiningWithRecursion() {
        Comparison comp = this.factory.createComparison();
        Match rootMatch = this.factory.createMatch();
        comp.getMatches().add((Object)rootMatch);
        AttributeChange ac = this.factory.createAttributeChange();
        AttributeChange ac1 = this.factory.createAttributeChange();
        ReferenceChange rc11 = this.factory.createReferenceChange();
        ReferenceChange rc12 = this.factory.createReferenceChange();
        ReferenceChange rc2 = this.factory.createReferenceChange();
        ReferenceChange rc3 = this.factory.createReferenceChange();
        EList diffs = rootMatch.getDifferences();
        diffs.add((Object)ac);
        diffs.add((Object)ac1);
        diffs.add((Object)rc11);
        diffs.add((Object)rc12);
        diffs.add((Object)rc2);
        diffs.add((Object)rc3);
        ac.getRefinedBy().addAll(Arrays.asList(ac1, rc2, rc3));
        ac1.getRefinedBy().addAll(Arrays.asList(rc11, rc12));
        Assert.assertTrue((boolean)EMFComparePredicates.anyRefining((Predicate)Predicates.instanceOf(AttributeChange.class)).apply((Object)ac));
        Assert.assertTrue((boolean)EMFComparePredicates.anyRefining((Predicate)Predicates.instanceOf(ReferenceChange.class)).apply((Object)ac));
        Assert.assertTrue((boolean)EMFComparePredicates.anyRefining((Predicate)Predicates.equalTo((Object)rc12)).apply((Object)ac));
        Assert.assertFalse((boolean)EMFComparePredicates.anyRefining((Predicate)Predicates.equalTo((Object)ac)).apply((Object)ac));
    }

    @Test
    public void testAllAtomicRefiningWithoutRecursion() {
        Comparison comp = this.factory.createComparison();
        Match rootMatch = this.factory.createMatch();
        comp.getMatches().add((Object)rootMatch);
        AttributeChange ac = this.factory.createAttributeChange();
        ReferenceChange rc1 = this.factory.createReferenceChange();
        ReferenceChange rc2 = this.factory.createReferenceChange();
        ReferenceChange rc3 = this.factory.createReferenceChange();
        EList diffs = rootMatch.getDifferences();
        diffs.add((Object)ac);
        diffs.add((Object)rc1);
        diffs.add((Object)rc2);
        diffs.add((Object)rc3);
        ac.getRefinedBy().addAll(Arrays.asList(rc1, rc2, rc3));
        Assert.assertFalse((boolean)EMFComparePredicates.allAtomicRefining((Predicate)Predicates.instanceOf(AttributeChange.class)).apply((Object)ac));
        Assert.assertTrue((boolean)EMFComparePredicates.allAtomicRefining((Predicate)Predicates.instanceOf(ReferenceChange.class)).apply((Object)ac));
        Assert.assertFalse((boolean)EMFComparePredicates.allAtomicRefining((Predicate)Predicates.equalTo((Object)rc3)).apply((Object)ac));
    }

    @Test
    public void testAllAtomicRefiningWithRecursion() {
        Comparison comp = this.factory.createComparison();
        Match rootMatch = this.factory.createMatch();
        comp.getMatches().add((Object)rootMatch);
        AttributeChange ac = this.factory.createAttributeChange();
        AttributeChange ac1 = this.factory.createAttributeChange();
        ReferenceChange rc11 = this.factory.createReferenceChange();
        ReferenceChange rc12 = this.factory.createReferenceChange();
        ReferenceChange rc2 = this.factory.createReferenceChange();
        ReferenceChange rc3 = this.factory.createReferenceChange();
        EList diffs = rootMatch.getDifferences();
        diffs.add((Object)ac);
        diffs.add((Object)ac1);
        diffs.add((Object)rc11);
        diffs.add((Object)rc12);
        diffs.add((Object)rc2);
        diffs.add((Object)rc3);
        ac.getRefinedBy().addAll(Arrays.asList(ac1, rc2, rc3));
        ac1.getRefinedBy().addAll(Arrays.asList(rc11, rc12));
        Assert.assertFalse((boolean)EMFComparePredicates.allAtomicRefining((Predicate)Predicates.instanceOf(AttributeChange.class)).apply((Object)ac));
        Assert.assertTrue((boolean)EMFComparePredicates.allAtomicRefining((Predicate)Predicates.instanceOf(ReferenceChange.class)).apply((Object)ac));
        Assert.assertFalse((boolean)EMFComparePredicates.allAtomicRefining((Predicate)Predicates.equalTo((Object)rc12)).apply((Object)ac));
    }

    @Test
    public void testHasDirectOrIndirectConflictForDirectConflict() {
        Comparison comp = this.factory.createComparison();
        Match rootMatch = this.factory.createMatch();
        comp.getMatches().add((Object)rootMatch);
        AttributeChange acl = this.factory.createAttributeChange();
        AttributeChange acr = this.factory.createAttributeChange();
        rootMatch.getDifferences().addAll(Arrays.asList(acl, acr));
        Conflict conflict = this.factory.createConflict();
        conflict.setKind(ConflictKind.REAL);
        conflict.getDifferences().addAll(Arrays.asList(acl, acr));
        comp.getConflicts().add((Object)conflict);
        Assert.assertTrue((boolean)EMFComparePredicates.hasDirectOrIndirectConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}).apply((Object)acl));
        Assert.assertTrue((boolean)EMFComparePredicates.hasDirectOrIndirectConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}).apply((Object)acr));
        Assert.assertFalse((boolean)EMFComparePredicates.hasDirectOrIndirectConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO}).apply((Object)acl));
        Assert.assertFalse((boolean)EMFComparePredicates.hasDirectOrIndirectConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO}).apply((Object)acr));
        Assert.assertFalse((boolean)EMFComparePredicates.hasNoDirectOrIndirectConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}).apply((Object)acl));
        Assert.assertFalse((boolean)EMFComparePredicates.hasNoDirectOrIndirectConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}).apply((Object)acr));
        Assert.assertTrue((boolean)EMFComparePredicates.hasNoDirectOrIndirectConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO}).apply((Object)acl));
        Assert.assertTrue((boolean)EMFComparePredicates.hasNoDirectOrIndirectConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO}).apply((Object)acr));
    }

    @Test
    public void testHasDirectOrIndirectConflictForIndirectConflict() {
        Comparison comp = this.factory.createComparison();
        Match rootMatch = this.factory.createMatch();
        comp.getMatches().add((Object)rootMatch);
        ReferenceChange rc = this.factory.createReferenceChange();
        AttributeChange acl = this.factory.createAttributeChange();
        AttributeChange acr = this.factory.createAttributeChange();
        rootMatch.getDifferences().addAll(Arrays.asList(rc, acl, acr));
        rc.getRefinedBy().addAll(Arrays.asList(acl));
        Conflict conflict = this.factory.createConflict();
        conflict.setKind(ConflictKind.REAL);
        conflict.getDifferences().addAll(Arrays.asList(acl, acr));
        comp.getConflicts().add((Object)conflict);
        Assert.assertTrue((boolean)EMFComparePredicates.hasDirectOrIndirectConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}).apply((Object)rc));
        Assert.assertFalse((boolean)EMFComparePredicates.hasDirectOrIndirectConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO}).apply((Object)rc));
        Assert.assertFalse((boolean)EMFComparePredicates.hasNoDirectOrIndirectConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}).apply((Object)rc));
        Assert.assertTrue((boolean)EMFComparePredicates.hasNoDirectOrIndirectConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO}).apply((Object)rc));
    }
}

