/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.tests.workspace.TestProject;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class CompareTestCase {
    protected static final String PROJECT_NAME = "Project-1";
    protected static final String PACKAGE_NAME_PREFIX = "package";
    protected static final String CLASS1_NAME_PREFIX = "Class_A";
    protected static final String CLASS2_NAME_PREFIX = "Class_B";
    protected static final String CLASS3_NAME_PREFIX = "Class_C";
    protected static final String CLASS4_NAME_PREFIX = "Class_D";
    protected TestProject project;

    @Before
    public void setUp() throws Exception {
        this.project = new TestProject(PROJECT_NAME);
    }

    @After
    public void tearDown() throws Exception {
        this.project.dispose();
    }

    protected EPackage createBasicModel(String nameSuffix) {
        EPackage root = this.createPackage(null, PACKAGE_NAME_PREFIX + nameSuffix);
        this.createClass(root, CLASS1_NAME_PREFIX + nameSuffix);
        this.createClass(root, CLASS2_NAME_PREFIX + nameSuffix);
        return root;
    }

    protected EPackage createPackage(EPackage parent, String name) {
        EPackage newPackage = EcoreFactory.eINSTANCE.createEPackage();
        newPackage.setName(name);
        if (parent != null) {
            parent.getESubpackages().add((Object)newPackage);
        }
        return newPackage;
    }

    protected EClass createClass(EPackage parent, String name) {
        EClass newClass = EcoreFactory.eINSTANCE.createEClass();
        newClass.setName(name);
        if (parent != null) {
            parent.getEClassifiers().add((Object)newClass);
        }
        return newClass;
    }

    protected EAttribute createAttribute(EClass parent, String name, EClassifier type) {
        EAttribute newAttribute = EcoreFactory.eINSTANCE.createEAttribute();
        newAttribute.setName(name);
        newAttribute.setEType(type);
        if (parent != null) {
            parent.getEAttributes().add((Object)newAttribute);
        }
        return newAttribute;
    }

    protected EObject findObject(Resource resource, String namePrefix) {
        TreeIterator children = EcoreUtil.getAllProperContents((Resource)resource, (boolean)false);
        while (children.hasNext()) {
            EObject child = (EObject)children.next();
            if (!(child instanceof ENamedElement) || !((ENamedElement)child).getName().startsWith(namePrefix)) continue;
            return child;
        }
        return null;
    }

    protected Resource connectResource(IFile file, ResourceSet resourceSet) throws CoreException {
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        return CompareTestCase.createResource(uri, resourceSet);
    }

    private static Resource createResource(URI modelURI, ResourceSet resourceSet) {
        XMIResourceImpl resource = new XMIResourceImpl(modelURI){

            protected boolean useUUIDs() {
                return true;
            }
        };
        resourceSet.getResources().add((Object)resource);
        return resource;
    }

    protected void makeCrossReference(Resource source, Resource target) {
        UnmodifiableIterator sourceChildren = Iterators.filter((Iterator)EcoreUtil.getAllProperContents((Resource)source, (boolean)false), EClass.class);
        UnmodifiableIterator targetChildren = Iterators.filter((Iterator)EcoreUtil.getAllProperContents((Resource)target, (boolean)false), EClass.class);
        Assert.assertTrue((boolean)sourceChildren.hasNext());
        Assert.assertTrue((boolean)targetChildren.hasNext());
        EClass sourceClass = (EClass)sourceChildren.next();
        EClass targetClass = (EClass)targetChildren.next();
        sourceClass.getESuperTypes().add((Object)targetClass);
    }

    protected void breakCrossReferences(Resource source, Resource target) {
        TreeIterator sourceChildren = EcoreUtil.getAllProperContents((Resource)source, (boolean)false);
        while (sourceChildren.hasNext()) {
            EObject child = (EObject)sourceChildren.next();
            this.breakCrossReferences(child, target);
        }
    }

    private void breakCrossReferences(EObject source, Resource target) {
        for (EReference ref : source.eClass().getEAllReferences()) {
            if (ref.isDerived()) continue;
            Object value = source.eGet((EStructuralFeature)ref);
            if (!ref.isMany()) {
                if (!(value instanceof EObject) || ((EObject)value).eResource() != target) continue;
                source.eSet((EStructuralFeature)ref, null);
                continue;
            }
            if (!(value instanceof Collection)) continue;
            Collection valueList = (Collection)value;
            Iterable copy = Iterables.filter(new ArrayList(valueList), EObject.class);
            for (EObject targetEObject : copy) {
                if (targetEObject.eResource() != target) continue;
                valueList.remove(targetEObject);
            }
        }
    }

    protected void makeCrossReference(Resource source, Resource target, String sourceNamePrefix, String targetNamePrefix) {
        EObject sourceObject = this.findObject(source, sourceNamePrefix);
        EObject targetObject = this.findObject(target, targetNamePrefix);
        Assert.assertTrue((boolean)(sourceObject instanceof EClass));
        Assert.assertTrue((boolean)(targetObject instanceof EClass));
        ((EClass)sourceObject).getESuperTypes().add((Object)((EClass)targetObject));
    }

    protected void unload(Resource ... resources) {
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            resource.getContents().clear();
            resource.unload();
            ++n2;
        }
    }

    protected void reload(Resource ... resources) throws IOException {
        Resource resource;
        this.unload(resources);
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            resource = resourceArray[n2];
            resource.load(Collections.emptyMap());
            ++n2;
        }
        resourceArray = resources;
        n = resources.length;
        n2 = 0;
        while (n2 < n) {
            resource = resourceArray[n2];
            EcoreUtil.resolveAll((Resource)resource);
            ++n2;
        }
    }

    protected void save(ResourceSet resourceSet) throws IOException, CoreException {
        IProject prj;
        for (Resource resource : resourceSet.getResources()) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("SAVE_ONLY_IF_CHANGED", "FILE_BUFFER");
            resource.save(options);
        }
        if (this.project != null && (prj = this.project.getProject()) != null) {
            prj.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected void save(Resource ... resources) throws IOException, CoreException {
        IProject prj;
        Resource[] resourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("SAVE_ONLY_IF_CHANGED", "FILE_BUFFER");
            resource.save(options);
            ++n2;
        }
        if (this.project != null && (prj = this.project.getProject()) != null) {
            prj.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    protected static void copyFile(File source, File dest) throws IOException {
        FileChannel sourceChannel = null;
        FileChannel destChannel = null;
        FileInputStream fileInputStream = new FileInputStream(source);
        sourceChannel = fileInputStream.getChannel();
        FileOutputStream fileOutputStream = new FileOutputStream(dest);
        destChannel = fileOutputStream.getChannel();
        destChannel.transferFrom(sourceChannel, 0L, sourceChannel.size());
        sourceChannel.close();
        destChannel.close();
        fileInputStream.close();
        fileOutputStream.close();
    }

    protected static void assertContainsExclusively(StorageTraversal traversal, IFile ... files) {
        Set storages = traversal.getStorages();
        Assert.assertEquals((long)files.length, (long)storages.size());
        IFile[] iFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            Assert.assertTrue((boolean)storages.contains(file));
            ++n2;
        }
    }
}

