/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.tests.unit;

import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.EMFModelProvider;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.CrossReferenceResolutionScope;
import org.eclipse.emf.compare.ide.ui.tests.unit.LogicalModelGraphTest;
import org.eclipse.emf.compare.ide.ui.tests.workspace.TestProject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ModelResolverLocalTest
extends LogicalModelGraphTest {
    private static final String PROJECT2_NAME = "Project-2";
    private static final String FILE1_NAME = "file1.ecore";
    private static final String FILE2_NAME = "file2.ecore";
    private static final String FILE3_NAME = "file3.ecore";
    private static final String FILE4_NAME = "file4.ecore";
    private static final String FILE1_SUFFIX = "_file1";
    private static final String FILE2_SUFFIX = "_file2";
    private static final String FILE3_SUFFIX = "_file3";
    private static final String FILE4_SUFFIX = "_file4";
    private TestProject project2;
    private IFile iFile1;
    private IFile iFile2;
    private IFile iFile3;
    private IFile iFile4;
    private CrossReferenceResolutionScope originalResolutionScope;

    @Override
    @Before
    public void setUp() throws Exception {
        IPreferenceStore store = EMFCompareIDEUIPlugin.getDefault().getPreferenceStore();
        String stringValue = store.getString("org.eclipse.emf.compare.ide.ui.preference.resolutionScope");
        this.originalResolutionScope = CrossReferenceResolutionScope.valueOf((String)stringValue);
        this.project2 = new TestProject(PROJECT2_NAME);
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        EMFModelProvider emfModelProvider = (EMFModelProvider)ModelProvider.getModelProviderDescriptor((String)"org.eclipse.emf.compare.model.provider").getModelProvider();
        emfModelProvider.clear();
        this.setResolutionScope(this.originalResolutionScope);
        this.iFile1 = null;
        this.iFile2 = null;
        this.project2.dispose();
        super.tearDown();
    }

    private List<IFile> setUpCase1() throws Exception {
        IProject iProject = this.project.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject, FILE1_NAME);
        File file2 = this.project.getOrCreateFile(iProject, FILE2_NAME);
        this.iFile1 = this.project.getIFile(iProject, file1);
        this.iFile2 = this.project.getIFile(iProject, file2);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        this.save((ResourceSet)resourceSet);
        this.breakModel(this.iFile2);
        return Arrays.asList(this.iFile1, this.iFile2);
    }

    @Test
    public void test_case1_workspace_project_container() throws Exception {
        List<IFile> files = this.setUpCase1();
        Assert.assertEquals((long)2L, (long)files.size());
        ImmutableSet expectedGraph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1}), ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile1Traversal, 4);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile2Traversal, 4);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.WORKSPACE, CrossReferenceResolutionScope.PROJECT, CrossReferenceResolutionScope.CONTAINER)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result);
        }
    }

    @Test
    public void test_case1_outgoing_self() throws Exception {
        List<IFile> files = this.setUpCase1();
        Assert.assertEquals((long)2L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 4);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.OUTGOING, CrossReferenceResolutionScope.SELF)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result);
        }
    }

    private List<IFile> setUpCase2() throws Exception {
        IProject iProject = this.project.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject, FILE1_NAME);
        File file2 = this.project.getOrCreateFile(iProject, FILE2_NAME);
        this.iFile1 = this.project.getIFile(iProject, file1);
        this.iFile2 = this.project.getIFile(iProject, file2);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        this.makeCrossReference(resource1, resource2);
        this.save((ResourceSet)resourceSet);
        this.breakModel(this.iFile2);
        return Arrays.asList(this.iFile1, this.iFile2);
    }

    @Test
    public void test_case2_workspace_project_container() throws Exception {
        List<IFile> files = this.setUpCase2();
        Assert.assertEquals((long)2L, (long)files.size());
        ImmutableSet expectedGraph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}));
        Set<IStorage> expectedTraversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        ExpectedResult expectedResult = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedTraversal, 4);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.WORKSPACE, CrossReferenceResolutionScope.PROJECT, CrossReferenceResolutionScope.CONTAINER)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(files, expectedResult, expectedResult);
        }
    }

    @Test
    public void test_case2_outgoing() throws Exception {
        List<IFile> files = this.setUpCase2();
        Assert.assertEquals((long)2L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 4);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 4);
        this.setResolutionScope(CrossReferenceResolutionScope.OUTGOING);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result);
    }

    @Test
    public void test_case2_self() throws Exception {
        List<IFile> files = this.setUpCase2();
        Assert.assertEquals((long)2L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 4);
        this.setResolutionScope(CrossReferenceResolutionScope.SELF);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result);
    }

    private List<IFile> setUpCase3() throws Exception {
        IProject iProject = this.project.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject, FILE1_NAME);
        File file2 = this.project.getOrCreateFile(iProject, FILE2_NAME);
        this.iFile1 = this.project.getIFile(iProject, file1);
        this.iFile2 = this.project.getIFile(iProject, file2);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        this.save((ResourceSet)resourceSet);
        return Arrays.asList(this.iFile1, this.iFile2);
    }

    @Test
    public void test_case3_workspace_project_container() throws Exception {
        List<IFile> files = this.setUpCase3();
        Assert.assertEquals((long)2L, (long)files.size());
        ImmutableSet expectedGraph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1}), ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile2Traversal, 0);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.WORKSPACE, CrossReferenceResolutionScope.PROJECT, CrossReferenceResolutionScope.CONTAINER)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result);
        }
    }

    @Test
    public void test_case3_outgoing_self() throws Exception {
        List<IFile> files = this.setUpCase3();
        Assert.assertEquals((long)2L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.OUTGOING, CrossReferenceResolutionScope.SELF)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result);
        }
    }

    private List<IFile> setUpCase4() throws Exception {
        IProject iProject = this.project.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject, FILE1_NAME);
        File file2 = this.project.getOrCreateFile(iProject, FILE2_NAME);
        this.iFile1 = this.project.getIFile(iProject, file1);
        this.iFile2 = this.project.getIFile(iProject, file2);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        this.makeCrossReference(resource1, resource2);
        this.save((ResourceSet)resourceSet);
        return Arrays.asList(this.iFile1, this.iFile2);
    }

    @Test
    public void test_case4_workspace_project_container() throws Exception {
        List<IFile> files = this.setUpCase4();
        Assert.assertEquals((long)2L, (long)files.size());
        ImmutableSet expectedGraph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}));
        Set<IStorage> expectedTraversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        ExpectedResult expectedResult = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedTraversal, 0);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.WORKSPACE, CrossReferenceResolutionScope.PROJECT, CrossReferenceResolutionScope.CONTAINER)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(files, expectedResult, expectedResult);
        }
    }

    @Test
    public void test_case4_outgoing() throws Exception {
        List<IFile> files = this.setUpCase4();
        Assert.assertEquals((long)2L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        this.setResolutionScope(CrossReferenceResolutionScope.OUTGOING);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result);
    }

    @Test
    public void test_case4_self() throws Exception {
        List<IFile> files = this.setUpCase4();
        Assert.assertEquals((long)2L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        this.setResolutionScope(CrossReferenceResolutionScope.SELF);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result);
    }

    private List<IFile> setUpCase5() throws Exception {
        IProject iProject1 = this.project.getProject();
        IProject iProject2 = this.project2.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject1, FILE1_NAME);
        File file2 = this.project.getOrCreateFile(iProject2, FILE2_NAME);
        this.iFile1 = this.project.getIFile(iProject1, file1);
        this.iFile2 = this.project2.getIFile(iProject2, file2);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        this.save((ResourceSet)resourceSet);
        this.breakModel(this.iFile2);
        return Arrays.asList(this.iFile1, this.iFile2);
    }

    @Test
    public void test_case5_workspace() throws Exception {
        List<IFile> files = this.setUpCase5();
        Assert.assertEquals((long)2L, (long)files.size());
        ImmutableSet expectedGraph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1}), ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile1Traversal, 4);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile2Traversal, 4);
        this.setResolutionScope(CrossReferenceResolutionScope.WORKSPACE);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result);
    }

    @Test
    public void test_case5_project_container_outgoing_self() throws Exception {
        List<IFile> files = this.setUpCase5();
        Assert.assertEquals((long)2L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 4);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.PROJECT, CrossReferenceResolutionScope.CONTAINER, CrossReferenceResolutionScope.OUTGOING, CrossReferenceResolutionScope.SELF)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result);
        }
    }

    private List<IFile> setUpCase6() throws Exception {
        IProject iProject1 = this.project.getProject();
        IProject iProject2 = this.project2.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject1, FILE1_NAME);
        File file2 = this.project.getOrCreateFile(iProject2, FILE2_NAME);
        this.iFile1 = this.project.getIFile(iProject1, file1);
        this.iFile2 = this.project2.getIFile(iProject2, file2);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        this.makeCrossReference(resource1, resource2);
        this.save((ResourceSet)resourceSet);
        this.breakModel(this.iFile2);
        return Arrays.asList(this.iFile1, this.iFile2);
    }

    @Test
    public void test_case6_workspace() throws Exception {
        List<IFile> files = this.setUpCase6();
        Assert.assertEquals((long)2L, (long)files.size());
        ImmutableSet expectedGraph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}));
        Set<IStorage> expectedTraversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        ExpectedResult expectedResult = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedTraversal, 4);
        this.setResolutionScope(CrossReferenceResolutionScope.WORKSPACE);
        this.resolveAndCheckResult(files, expectedResult, expectedResult);
    }

    @Test
    public void test_case6_project_container_self() throws Exception {
        List<IFile> files = this.setUpCase6();
        Assert.assertEquals((long)2L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 4);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.PROJECT, CrossReferenceResolutionScope.CONTAINER, CrossReferenceResolutionScope.SELF)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result);
        }
    }

    @Test
    public void test_case6_outgoing() throws Exception {
        List<IFile> files = this.setUpCase6();
        Assert.assertEquals((long)2L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 4);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 4);
        this.setResolutionScope(CrossReferenceResolutionScope.OUTGOING);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result);
    }

    private List<IFile> setUpCase7() throws Exception {
        IProject iProject1 = this.project.getProject();
        IProject iProject2 = this.project2.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject1, FILE1_NAME);
        File file2 = this.project.getOrCreateFile(iProject2, FILE2_NAME);
        this.iFile1 = this.project.getIFile(iProject1, file1);
        this.iFile2 = this.project2.getIFile(iProject2, file2);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        this.save((ResourceSet)resourceSet);
        return Arrays.asList(this.iFile1, this.iFile2);
    }

    @Test
    public void test_case7_workspace() throws Exception {
        List<IFile> files = this.setUpCase7();
        Assert.assertEquals((long)2L, (long)files.size());
        ImmutableSet expectedGraph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1}), ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile2Traversal, 0);
        this.setResolutionScope(CrossReferenceResolutionScope.WORKSPACE);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result);
    }

    @Test
    public void test_case7_project_container_outgoing_self() throws Exception {
        List<IFile> files = this.setUpCase7();
        Assert.assertEquals((long)2L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.PROJECT, CrossReferenceResolutionScope.CONTAINER, CrossReferenceResolutionScope.OUTGOING, CrossReferenceResolutionScope.SELF)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result);
        }
    }

    private List<IFile> setUpCase8() throws Exception {
        IProject iProject1 = this.project.getProject();
        IProject iProject2 = this.project2.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject1, FILE1_NAME);
        File file2 = this.project.getOrCreateFile(iProject2, FILE2_NAME);
        this.iFile1 = this.project.getIFile(iProject1, file1);
        this.iFile2 = this.project2.getIFile(iProject2, file2);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        this.makeCrossReference(resource1, resource2);
        this.save((ResourceSet)resourceSet);
        return Arrays.asList(this.iFile1, this.iFile2);
    }

    @Test
    public void test_case8_workspace() throws Exception {
        List<IFile> files = this.setUpCase8();
        Assert.assertEquals((long)2L, (long)files.size());
        ImmutableSet expectedGraph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}));
        Set<IStorage> expectedTraversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        ExpectedResult expectedResult = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedTraversal, 0);
        this.setResolutionScope(CrossReferenceResolutionScope.WORKSPACE);
        this.resolveAndCheckResult(files, expectedResult, expectedResult);
    }

    @Test
    public void test_case8_project_container_self() throws Exception {
        List<IFile> files = this.setUpCase8();
        Assert.assertEquals((long)2L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 4);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.PROJECT, CrossReferenceResolutionScope.CONTAINER, CrossReferenceResolutionScope.SELF)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result);
        }
    }

    @Test
    public void test_case8_outgoing() throws Exception {
        List<IFile> files = this.setUpCase8();
        Assert.assertEquals((long)2L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        this.setResolutionScope(CrossReferenceResolutionScope.OUTGOING);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result);
    }

    private List<IFile> setUpCase9() throws Exception {
        IProject iProject1 = this.project.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject1, FILE1_NAME);
        File file2 = this.project.getOrCreateFile(iProject1, FILE2_NAME);
        File file3 = this.project.getOrCreateFile(iProject1, FILE3_NAME);
        this.iFile1 = this.project.getIFile(iProject1, file1);
        this.iFile2 = this.project.getIFile(iProject1, file2);
        this.iFile3 = this.project.getIFile(iProject1, file3);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        Resource resource3 = this.connectResource(this.iFile3, (ResourceSet)resourceSet);
        resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        resource3.getContents().add((Object)this.createBasicModel(FILE3_SUFFIX));
        this.makeCrossReference(resource1, resource2);
        this.save((ResourceSet)resourceSet);
        this.breakModel(this.iFile3);
        return Arrays.asList(this.iFile1, this.iFile2, this.iFile3);
    }

    @Test
    public void test_case9_workspace_project_container() throws Exception {
        List<IFile> files = this.setUpCase9();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedGraph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}), ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        Set<IStorage> expectedFile1Or2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        ExpectedResult expectedFile1Or2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile1Or2Traversal, 4);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile3Traversal, 4);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.WORKSPACE, CrossReferenceResolutionScope.PROJECT, CrossReferenceResolutionScope.CONTAINER)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(files, expectedFile1Or2Result, expectedFile1Or2Result, expectedFile3Result);
        }
    }

    @Test
    public void test_case9_outgoing() throws Exception {
        List<IFile> files = this.setUpCase9();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 4);
        this.setResolutionScope(CrossReferenceResolutionScope.OUTGOING);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result);
    }

    @Test
    public void test_case9_self() throws Exception {
        List<IFile> files = this.setUpCase9();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 4);
        this.setResolutionScope(CrossReferenceResolutionScope.SELF);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result);
    }

    private List<IFile> setUpCase10() throws Exception {
        IProject iProject1 = this.project.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject1, FILE1_NAME);
        File file2 = this.project.getOrCreateFile(iProject1, FILE2_NAME);
        File file3 = this.project.getOrCreateFile(iProject1, FILE3_NAME);
        this.iFile1 = this.project.getIFile(iProject1, file1);
        this.iFile2 = this.project.getIFile(iProject1, file2);
        this.iFile3 = this.project.getIFile(iProject1, file3);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        Resource resource3 = this.connectResource(this.iFile3, (ResourceSet)resourceSet);
        resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        resource3.getContents().add((Object)this.createBasicModel(FILE3_SUFFIX));
        this.makeCrossReference(resource1, resource2);
        this.makeCrossReference(resource2, resource3);
        this.save((ResourceSet)resourceSet);
        this.breakModel(this.iFile3);
        return Arrays.asList(this.iFile1, this.iFile2, this.iFile3);
    }

    @Test
    public void test_case10_workspace_project_container() throws Exception {
        List<IFile> files = this.setUpCase10();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedGraph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2, this.iFile3}));
        Set<IStorage> expectedTraversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2, this.iFile3});
        ExpectedResult expectedResult = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedTraversal, 4);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.WORKSPACE, CrossReferenceResolutionScope.PROJECT, CrossReferenceResolutionScope.CONTAINER)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(files, expectedResult, expectedResult, expectedResult);
        }
    }

    @Test
    public void test_case10_outgoing() throws Exception {
        List<IFile> files = this.setUpCase10();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2, this.iFile3}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2, this.iFile3}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2, this.iFile3});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2, this.iFile3});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 4);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 4);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 4);
        this.setResolutionScope(CrossReferenceResolutionScope.OUTGOING);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result);
    }

    @Test
    public void test_case10_self() throws Exception {
        List<IFile> files = this.setUpCase10();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 4);
        this.setResolutionScope(CrossReferenceResolutionScope.SELF);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result);
    }

    private List<IFile> setUpCase11() throws Exception {
        IProject iProject1 = this.project.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject1, FILE1_NAME);
        File file2 = this.project.getOrCreateFile(iProject1, FILE2_NAME);
        File file3 = this.project.getOrCreateFile(iProject1, FILE3_NAME);
        this.iFile1 = this.project.getIFile(iProject1, file1);
        this.iFile2 = this.project.getIFile(iProject1, file2);
        this.iFile3 = this.project.getIFile(iProject1, file3);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        Resource resource3 = this.connectResource(this.iFile3, (ResourceSet)resourceSet);
        resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        resource3.getContents().add((Object)this.createBasicModel(FILE3_SUFFIX));
        this.makeCrossReference(resource1, resource2);
        this.save((ResourceSet)resourceSet);
        return Arrays.asList(this.iFile1, this.iFile2, this.iFile3);
    }

    @Test
    public void test_case11_workspace_project_container() throws Exception {
        List<IFile> files = this.setUpCase11();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedGraph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}), ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        Set<IStorage> expectedFile1Or2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        ExpectedResult expectedFile1Or2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile1Or2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile3Traversal, 0);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.WORKSPACE, CrossReferenceResolutionScope.PROJECT, CrossReferenceResolutionScope.CONTAINER)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(files, expectedFile1Or2Result, expectedFile1Or2Result, expectedFile3Result);
        }
    }

    @Test
    public void test_case11_outgoing() throws Exception {
        List<IFile> files = this.setUpCase11();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 0);
        this.setResolutionScope(CrossReferenceResolutionScope.OUTGOING);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result);
    }

    @Test
    public void test_case11_self() throws Exception {
        List<IFile> files = this.setUpCase11();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 0);
        this.setResolutionScope(CrossReferenceResolutionScope.SELF);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result);
    }

    private List<IFile> setUpCase12() throws Exception {
        IProject iProject1 = this.project.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject1, FILE1_NAME);
        File file2 = this.project.getOrCreateFile(iProject1, FILE2_NAME);
        File file3 = this.project.getOrCreateFile(iProject1, FILE3_NAME);
        File file4 = this.project.getOrCreateFile(iProject1, FILE4_NAME);
        this.iFile1 = this.project.getIFile(iProject1, file1);
        this.iFile2 = this.project.getIFile(iProject1, file2);
        this.iFile3 = this.project.getIFile(iProject1, file3);
        this.iFile4 = this.project.getIFile(iProject1, file4);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        Resource resource3 = this.connectResource(this.iFile3, (ResourceSet)resourceSet);
        Resource resource4 = this.connectResource(this.iFile4, (ResourceSet)resourceSet);
        resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        resource3.getContents().add((Object)this.createBasicModel(FILE3_SUFFIX));
        resource4.getContents().add((Object)this.createBasicModel(FILE4_SUFFIX));
        this.makeCrossReference(resource1, resource2);
        this.makeCrossReference(resource3, resource4);
        this.save((ResourceSet)resourceSet);
        this.breakModel(this.iFile4);
        return Arrays.asList(this.iFile1, this.iFile2, this.iFile3, this.iFile4);
    }

    @Test
    public void test_case12_workspace_project_container() throws Exception {
        List<IFile> files = this.setUpCase12();
        Assert.assertEquals((long)4L, (long)files.size());
        ImmutableSet expectedGraph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}), ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3, this.iFile4}));
        Set<IStorage> expectedFile1Or2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        Set<IStorage> expectedFile3Or4Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3, this.iFile4});
        ExpectedResult expectedFile1Or2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile1Or2Traversal, 4);
        ExpectedResult expectedFile3Or4Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile3Or4Traversal, 4);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.WORKSPACE, CrossReferenceResolutionScope.PROJECT, CrossReferenceResolutionScope.CONTAINER)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(files, expectedFile1Or2Result, expectedFile1Or2Result, expectedFile3Or4Result, expectedFile3Or4Result);
        }
    }

    @Test
    public void test_case12_outgoing() throws Exception {
        List<IFile> files = this.setUpCase12();
        Assert.assertEquals((long)4L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3, this.iFile4}));
        ImmutableSet expectedFile4Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile4}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3, this.iFile4});
        Set<IStorage> expectedFile4Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile4});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 4);
        ExpectedResult expectedFile4Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile4Graph, expectedFile4Traversal, 4);
        this.setResolutionScope(CrossReferenceResolutionScope.OUTGOING);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result, expectedFile4Result);
    }

    @Test
    public void test_case12_self() throws Exception {
        List<IFile> files = this.setUpCase12();
        Assert.assertEquals((long)4L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        ImmutableSet expectedFile4Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile4}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        Set<IStorage> expectedFile4Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile4});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 0);
        ExpectedResult expectedFile4Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile4Graph, expectedFile4Traversal, 4);
        this.setResolutionScope(CrossReferenceResolutionScope.SELF);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result, expectedFile4Result);
    }

    private List<IFile> setUpCase13() throws Exception {
        IProject iProject1 = this.project.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject1, FILE1_NAME);
        File file2 = this.project.getOrCreateFile(iProject1, FILE2_NAME);
        File file3 = this.project.getOrCreateFile(iProject1, FILE3_NAME);
        File file4 = this.project.getOrCreateFile(iProject1, FILE4_NAME);
        this.iFile1 = this.project.getIFile(iProject1, file1);
        this.iFile2 = this.project.getIFile(iProject1, file2);
        this.iFile3 = this.project.getIFile(iProject1, file3);
        this.iFile4 = this.project.getIFile(iProject1, file4);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        Resource resource3 = this.connectResource(this.iFile3, (ResourceSet)resourceSet);
        Resource resource4 = this.connectResource(this.iFile4, (ResourceSet)resourceSet);
        resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        resource3.getContents().add((Object)this.createBasicModel(FILE3_SUFFIX));
        resource4.getContents().add((Object)this.createBasicModel(FILE4_SUFFIX));
        this.makeCrossReference(resource1, resource2);
        this.makeCrossReference(resource3, resource4);
        this.save((ResourceSet)resourceSet);
        return Arrays.asList(this.iFile1, this.iFile2, this.iFile3, this.iFile4);
    }

    @Test
    public void test_case13_workspace_project_container() throws Exception {
        List<IFile> files = this.setUpCase13();
        Assert.assertEquals((long)4L, (long)files.size());
        ImmutableSet expectedGraph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}), ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3, this.iFile4}));
        Set<IStorage> expectedFile1Or2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        Set<IStorage> expectedFile3Or4Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3, this.iFile4});
        ExpectedResult expectedFile1Or2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile1Or2Traversal, 0);
        ExpectedResult expectedFile3Or4Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile3Or4Traversal, 0);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.WORKSPACE, CrossReferenceResolutionScope.PROJECT, CrossReferenceResolutionScope.CONTAINER)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(files, expectedFile1Or2Result, expectedFile1Or2Result, expectedFile3Or4Result, expectedFile3Or4Result);
        }
    }

    @Test
    public void test_case13_outgoing() throws Exception {
        List<IFile> files = this.setUpCase13();
        Assert.assertEquals((long)4L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3, this.iFile4}));
        ImmutableSet expectedFile4Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile4}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3, this.iFile4});
        Set<IStorage> expectedFile4Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile4});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 0);
        ExpectedResult expectedFile4Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile4Graph, expectedFile4Traversal, 0);
        this.setResolutionScope(CrossReferenceResolutionScope.OUTGOING);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result, expectedFile4Result);
    }

    @Test
    public void test_case13_self() throws Exception {
        List<IFile> files = this.setUpCase13();
        Assert.assertEquals((long)4L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        ImmutableSet expectedFile4Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile4}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        Set<IStorage> expectedFile4Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile4});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 0);
        ExpectedResult expectedFile4Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile4Graph, expectedFile4Traversal, 0);
        this.setResolutionScope(CrossReferenceResolutionScope.SELF);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result, expectedFile4Result);
    }

    private List<IFile> setUpCase14() throws Exception {
        IProject iProject1 = this.project.getProject();
        IProject iProject2 = this.project2.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject1, FILE1_NAME);
        File file2 = this.project.getOrCreateFile(iProject1, FILE2_NAME);
        File file3 = this.project.getOrCreateFile(iProject2, FILE3_NAME);
        this.iFile1 = this.project.getIFile(iProject1, file1);
        this.iFile2 = this.project.getIFile(iProject1, file2);
        this.iFile3 = this.project.getIFile(iProject2, file3);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        Resource resource3 = this.connectResource(this.iFile3, (ResourceSet)resourceSet);
        resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        resource3.getContents().add((Object)this.createBasicModel(FILE3_SUFFIX));
        this.makeCrossReference(resource1, resource2);
        this.save((ResourceSet)resourceSet);
        this.breakModel(this.iFile3);
        return Arrays.asList(this.iFile1, this.iFile2, this.iFile3);
    }

    @Test
    public void test_case14_workspace() throws Exception {
        List<IFile> files = this.setUpCase14();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedGraph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}), ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        Set<IStorage> expectedFile1Or2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        ExpectedResult expectedFile1Or2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile1Or2Traversal, 4);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile3Traversal, 4);
        this.setResolutionScope(CrossReferenceResolutionScope.WORKSPACE);
        this.resolveAndCheckResult(files, expectedFile1Or2Result, expectedFile1Or2Result, expectedFile3Result);
    }

    @Test
    public void test_case14_project_container() throws Exception {
        List<IFile> files = this.setUpCase14();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedFile1Or2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        Set<IStorage> expectedFile1Or2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        ExpectedResult expectedFile1Or2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Or2Graph, expectedFile1Or2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 4);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.PROJECT, CrossReferenceResolutionScope.CONTAINER)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(files, expectedFile1Or2Result, expectedFile1Or2Result, expectedFile3Result);
        }
    }

    @Test
    public void test_case14_outgoing() throws Exception {
        List<IFile> files = this.setUpCase14();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 4);
        this.setResolutionScope(CrossReferenceResolutionScope.OUTGOING);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result);
    }

    @Test
    public void test_case14_self() throws Exception {
        List<IFile> files = this.setUpCase14();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 4);
        this.setResolutionScope(CrossReferenceResolutionScope.SELF);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result);
    }

    private List<IFile> setUpCase15() throws Exception {
        IProject iProject1 = this.project.getProject();
        IProject iProject2 = this.project2.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject1, FILE1_NAME);
        File file2 = this.project.getOrCreateFile(iProject1, FILE2_NAME);
        File file3 = this.project.getOrCreateFile(iProject2, FILE3_NAME);
        this.iFile1 = this.project.getIFile(iProject1, file1);
        this.iFile2 = this.project.getIFile(iProject1, file2);
        this.iFile3 = this.project.getIFile(iProject2, file3);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        Resource resource3 = this.connectResource(this.iFile3, (ResourceSet)resourceSet);
        resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        resource3.getContents().add((Object)this.createBasicModel(FILE3_SUFFIX));
        this.makeCrossReference(resource1, resource2);
        this.makeCrossReference(resource2, resource3);
        this.save((ResourceSet)resourceSet);
        this.breakModel(this.iFile3);
        return Arrays.asList(this.iFile1, this.iFile2, this.iFile3);
    }

    @Test
    public void test_case15_workspace() throws Exception {
        List<IFile> files = this.setUpCase15();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedGraph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2, this.iFile3}));
        Set<IStorage> expectedTraversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2, this.iFile3});
        ExpectedResult expectedResult = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedTraversal, 4);
        this.setResolutionScope(CrossReferenceResolutionScope.WORKSPACE);
        this.resolveAndCheckResult(files, expectedResult, expectedResult, expectedResult);
    }

    @Test
    public void test_case15_project_container() throws Exception {
        List<IFile> files = this.setUpCase15();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedFile1Or2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        Set<IStorage> expectedFile1Or2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        ExpectedResult expectedFile1Or2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Or2Graph, expectedFile1Or2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 4);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.PROJECT, CrossReferenceResolutionScope.CONTAINER)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(files, expectedFile1Or2Result, expectedFile1Or2Result, expectedFile3Result);
        }
    }

    @Test
    public void test_case15_outgoing() throws Exception {
        List<IFile> files = this.setUpCase15();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2, this.iFile3}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2, this.iFile3}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2, this.iFile3});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2, this.iFile3});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 4);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 4);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 4);
        this.setResolutionScope(CrossReferenceResolutionScope.OUTGOING);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result);
    }

    @Test
    public void test_case15_self() throws Exception {
        List<IFile> files = this.setUpCase15();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 4);
        this.setResolutionScope(CrossReferenceResolutionScope.SELF);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result);
    }

    private List<IFile> setUpCase16() throws Exception {
        IProject iProject1 = this.project.getProject();
        IProject iProject2 = this.project2.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject1, FILE1_NAME);
        File file2 = this.project.getOrCreateFile(iProject1, FILE2_NAME);
        File file3 = this.project.getOrCreateFile(iProject2, FILE3_NAME);
        this.iFile1 = this.project.getIFile(iProject1, file1);
        this.iFile2 = this.project.getIFile(iProject1, file2);
        this.iFile3 = this.project.getIFile(iProject2, file3);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        Resource resource3 = this.connectResource(this.iFile3, (ResourceSet)resourceSet);
        resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        resource3.getContents().add((Object)this.createBasicModel(FILE3_SUFFIX));
        this.makeCrossReference(resource1, resource2);
        this.save((ResourceSet)resourceSet);
        return Arrays.asList(this.iFile1, this.iFile2, this.iFile3);
    }

    @Test
    public void test_case16_workspace() throws Exception {
        List<IFile> files = this.setUpCase16();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedGraph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}), ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        Set<IStorage> expectedFile1Or2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        ExpectedResult expectedFile1Or2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile1Or2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile3Traversal, 0);
        this.setResolutionScope(CrossReferenceResolutionScope.WORKSPACE);
        this.resolveAndCheckResult(files, expectedFile1Or2Result, expectedFile1Or2Result, expectedFile3Result);
    }

    @Test
    public void test_case16_project_container() throws Exception {
        List<IFile> files = this.setUpCase16();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedFile1Or2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        Set<IStorage> expectedFile1Or2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        ExpectedResult expectedFile1Or2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Or2Graph, expectedFile1Or2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 0);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.PROJECT, CrossReferenceResolutionScope.CONTAINER)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(files, expectedFile1Or2Result, expectedFile1Or2Result, expectedFile3Result);
        }
    }

    @Test
    public void test_case16_outgoing() throws Exception {
        List<IFile> files = this.setUpCase16();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 0);
        this.setResolutionScope(CrossReferenceResolutionScope.OUTGOING);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result);
    }

    @Test
    public void test_case16_self() throws Exception {
        List<IFile> files = this.setUpCase16();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 0);
        this.setResolutionScope(CrossReferenceResolutionScope.SELF);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result);
    }

    private List<IFile> setUpCase17() throws Exception {
        IProject iProject1 = this.project.getProject();
        IProject iProject2 = this.project2.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject1, FILE1_NAME);
        File file2 = this.project.getOrCreateFile(iProject2, FILE2_NAME);
        File file3 = this.project.getOrCreateFile(iProject1, FILE3_NAME);
        File file4 = this.project.getOrCreateFile(iProject2, FILE4_NAME);
        this.iFile1 = this.project.getIFile(iProject1, file1);
        this.iFile2 = this.project.getIFile(iProject2, file2);
        this.iFile3 = this.project.getIFile(iProject1, file3);
        this.iFile4 = this.project.getIFile(iProject2, file4);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        Resource resource3 = this.connectResource(this.iFile3, (ResourceSet)resourceSet);
        Resource resource4 = this.connectResource(this.iFile4, (ResourceSet)resourceSet);
        resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        resource3.getContents().add((Object)this.createBasicModel(FILE3_SUFFIX));
        resource4.getContents().add((Object)this.createBasicModel(FILE4_SUFFIX));
        this.makeCrossReference(resource1, resource2);
        this.makeCrossReference(resource3, resource4);
        this.save((ResourceSet)resourceSet);
        this.breakModel(this.iFile4);
        return Arrays.asList(this.iFile1, this.iFile2, this.iFile3, this.iFile4);
    }

    @Test
    public void test_case17_workspace() throws Exception {
        List<IFile> files = this.setUpCase17();
        Assert.assertEquals((long)4L, (long)files.size());
        ImmutableSet expectedGraph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}), ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3, this.iFile4}));
        Set<IStorage> expectedFile1Or2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        Set<IStorage> expectedFile3Or4Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3, this.iFile4});
        ExpectedResult expectedFile1Or2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile1Or2Traversal, 4);
        ExpectedResult expectedFile3Or4Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile3Or4Traversal, 4);
        this.setResolutionScope(CrossReferenceResolutionScope.WORKSPACE);
        this.resolveAndCheckResult(files, expectedFile1Or2Result, expectedFile1Or2Result, expectedFile3Or4Result, expectedFile3Or4Result);
    }

    @Test
    public void test_case17_project_container() throws Exception {
        List<IFile> files = this.setUpCase17();
        Assert.assertEquals((long)4L, (long)files.size());
        ImmutableSet expectedFile1Or2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile3}));
        ImmutableSet expectedFile3Or4Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2, this.iFile4}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        Set<IStorage> expectedFile4Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile4});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Or2Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Or2Graph, expectedFile2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Or4Graph, expectedFile3Traversal, 4);
        ExpectedResult expectedFile4Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Or4Graph, expectedFile4Traversal, 4);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.PROJECT, CrossReferenceResolutionScope.CONTAINER)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result, expectedFile4Result);
        }
    }

    @Test
    public void test_case17_outgoing() throws Exception {
        List<IFile> files = this.setUpCase17();
        Assert.assertEquals((long)4L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3, this.iFile4}));
        ImmutableSet expectedFile4Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile4}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3, this.iFile4});
        Set<IStorage> expectedFile4Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile4});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 4);
        ExpectedResult expectedFile4Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile4Graph, expectedFile4Traversal, 4);
        this.setResolutionScope(CrossReferenceResolutionScope.OUTGOING);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result, expectedFile4Result);
    }

    @Test
    public void test_case17_self() throws Exception {
        List<IFile> files = this.setUpCase17();
        Assert.assertEquals((long)4L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        ImmutableSet expectedFile4Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile4}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        Set<IStorage> expectedFile4Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile4});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 0);
        ExpectedResult expectedFile4Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile4Graph, expectedFile4Traversal, 4);
        this.setResolutionScope(CrossReferenceResolutionScope.SELF);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result, expectedFile4Result);
    }

    private List<IFile> setUpCase18() throws Exception {
        IProject iProject1 = this.project.getProject();
        IProject iProject2 = this.project2.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject1, FILE1_NAME);
        File file2 = this.project.getOrCreateFile(iProject2, FILE2_NAME);
        File file3 = this.project.getOrCreateFile(iProject1, FILE3_NAME);
        File file4 = this.project.getOrCreateFile(iProject2, FILE4_NAME);
        this.iFile1 = this.project.getIFile(iProject1, file1);
        this.iFile2 = this.project.getIFile(iProject2, file2);
        this.iFile3 = this.project.getIFile(iProject1, file3);
        this.iFile4 = this.project.getIFile(iProject2, file4);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        Resource resource3 = this.connectResource(this.iFile3, (ResourceSet)resourceSet);
        Resource resource4 = this.connectResource(this.iFile4, (ResourceSet)resourceSet);
        resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        resource3.getContents().add((Object)this.createBasicModel(FILE3_SUFFIX));
        resource4.getContents().add((Object)this.createBasicModel(FILE4_SUFFIX));
        this.makeCrossReference(resource1, resource2);
        this.makeCrossReference(resource3, resource4);
        this.save((ResourceSet)resourceSet);
        return Arrays.asList(this.iFile1, this.iFile2, this.iFile3, this.iFile4);
    }

    @Test
    public void test_case18_workspace() throws Exception {
        List<IFile> files = this.setUpCase18();
        Assert.assertEquals((long)4L, (long)files.size());
        ImmutableSet expectedGraph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}), ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3, this.iFile4}));
        Set<IStorage> expectedFile1Or2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        Set<IStorage> expectedFile3Or4Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3, this.iFile4});
        ExpectedResult expectedFile1Or2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile1Or2Traversal, 0);
        ExpectedResult expectedFile3Or4Result = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedFile3Or4Traversal, 0);
        this.setResolutionScope(CrossReferenceResolutionScope.WORKSPACE);
        this.resolveAndCheckResult(files, expectedFile1Or2Result, expectedFile1Or2Result, expectedFile3Or4Result, expectedFile3Or4Result);
    }

    @Test
    public void test_case18_project_container() throws Exception {
        List<IFile> files = this.setUpCase18();
        Assert.assertEquals((long)4L, (long)files.size());
        ImmutableSet expectedFile1Or2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile3}));
        ImmutableSet expectedFile3Or4Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2, this.iFile4}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        Set<IStorage> expectedFile4Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile4});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Or2Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Or2Graph, expectedFile2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Or4Graph, expectedFile3Traversal, 0);
        ExpectedResult expectedFile4Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Or4Graph, expectedFile4Traversal, 0);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.PROJECT, CrossReferenceResolutionScope.CONTAINER)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result, expectedFile4Result);
        }
    }

    @Test
    public void test_case18_outgoing() throws Exception {
        List<IFile> files = this.setUpCase18();
        Assert.assertEquals((long)4L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3, this.iFile4}));
        ImmutableSet expectedFile4Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile4}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3, this.iFile4});
        Set<IStorage> expectedFile4Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile4});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 0);
        ExpectedResult expectedFile4Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile4Graph, expectedFile4Traversal, 0);
        this.setResolutionScope(CrossReferenceResolutionScope.OUTGOING);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result, expectedFile4Result);
    }

    @Test
    public void test_case18_self() throws Exception {
        List<IFile> files = this.setUpCase18();
        Assert.assertEquals((long)4L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        ImmutableSet expectedFile4Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile4}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        Set<IStorage> expectedFile4Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile4});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 0);
        ExpectedResult expectedFile4Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile4Graph, expectedFile4Traversal, 0);
        this.setResolutionScope(CrossReferenceResolutionScope.SELF);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result, expectedFile4Result);
    }

    private List<IFile> setUpCase19() throws Exception {
        IProject iProject1 = this.project.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject1, FILE1_NAME);
        File file2 = this.project.getOrCreateFile(iProject1, FILE2_NAME);
        File file3 = this.project.getOrCreateFile(iProject1, FILE3_NAME);
        this.iFile1 = this.project.getIFile(iProject1, file1);
        this.iFile2 = this.project.getIFile(iProject1, file2);
        this.iFile3 = this.project.getIFile(iProject1, file3);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        Resource resource3 = this.connectResource(this.iFile3, (ResourceSet)resourceSet);
        resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        resource3.getContents().add((Object)this.createBasicModel(FILE3_SUFFIX));
        this.makeCrossReference(resource1, resource3);
        this.makeCrossReference(resource2, resource3);
        this.save((ResourceSet)resourceSet);
        return Arrays.asList(this.iFile1, this.iFile2, this.iFile3);
    }

    @Test
    public void test_case19_workspace_project_container() throws Exception {
        List<IFile> files = this.setUpCase19();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedGraph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2, this.iFile3}));
        Set<IStorage> expectedTraversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2, this.iFile3});
        ExpectedResult expectedResult = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedTraversal, 0);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.WORKSPACE, CrossReferenceResolutionScope.PROJECT, CrossReferenceResolutionScope.CONTAINER)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(files, expectedResult, expectedResult, expectedResult);
        }
    }

    @Test
    public void test_case19_outgoing() throws Exception {
        List<IFile> files = this.setUpCase19();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile3}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2, this.iFile3}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile3});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2, this.iFile3});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 0);
        this.setResolutionScope(CrossReferenceResolutionScope.OUTGOING);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result);
    }

    @Test
    public void test_case19_self() throws Exception {
        List<IFile> files = this.setUpCase19();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 0);
        this.setResolutionScope(CrossReferenceResolutionScope.SELF);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result);
    }

    private List<IFile> setUpCase20() throws Exception {
        IProject iProject1 = this.project.getProject();
        IProject iProject2 = this.project2.getProject();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        File file1 = this.project.getOrCreateFile(iProject1, FILE1_NAME);
        File file2 = this.project.getOrCreateFile(iProject2, FILE2_NAME);
        File file3 = this.project.getOrCreateFile(iProject1, FILE3_NAME);
        this.iFile1 = this.project.getIFile(iProject1, file1);
        this.iFile2 = this.project.getIFile(iProject2, file2);
        this.iFile3 = this.project.getIFile(iProject1, file3);
        Resource resource1 = this.connectResource(this.iFile1, (ResourceSet)resourceSet);
        Resource resource2 = this.connectResource(this.iFile2, (ResourceSet)resourceSet);
        Resource resource3 = this.connectResource(this.iFile3, (ResourceSet)resourceSet);
        resource1.getContents().add((Object)this.createBasicModel(FILE1_SUFFIX));
        resource2.getContents().add((Object)this.createBasicModel(FILE2_SUFFIX));
        resource3.getContents().add((Object)this.createBasicModel(FILE3_SUFFIX));
        this.makeCrossReference(resource1, resource2);
        this.makeCrossReference(resource2, resource3);
        this.save((ResourceSet)resourceSet);
        return Arrays.asList(this.iFile1, this.iFile2, this.iFile3);
    }

    @Test
    public void test_case20_outgoing() throws Exception {
        List<IFile> files = this.setUpCase20();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2, this.iFile3}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2, this.iFile3}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2, this.iFile3});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2, this.iFile3});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 0);
        this.setResolutionScope(CrossReferenceResolutionScope.OUTGOING);
        this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result);
    }

    @Test
    public void test_case20_project_container_self() throws Exception {
        List<IFile> files = this.setUpCase20();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedFile1Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1}));
        ImmutableSet expectedFile2Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile2}));
        ImmutableSet expectedFile3Graph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile3}));
        Set<IStorage> expectedFile1Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1});
        Set<IStorage> expectedFile2Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile2});
        Set<IStorage> expectedFile3Traversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile3});
        ExpectedResult expectedFile1Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile1Graph, expectedFile1Traversal, 0);
        ExpectedResult expectedFile2Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile2Graph, expectedFile2Traversal, 0);
        ExpectedResult expectedFile3Result = new ExpectedResult((Set<? extends Set<URI>>)expectedFile3Graph, expectedFile3Traversal, 0);
        for (CrossReferenceResolutionScope scope : Arrays.asList(CrossReferenceResolutionScope.PROJECT, CrossReferenceResolutionScope.CONTAINER, CrossReferenceResolutionScope.SELF)) {
            this.setResolutionScope(scope);
            this.resolveAndCheckResult(files, expectedFile1Result, expectedFile2Result, expectedFile3Result);
        }
    }

    @Test
    public void test_case20_workspace() throws Exception {
        List<IFile> files = this.setUpCase20();
        Assert.assertEquals((long)3L, (long)files.size());
        ImmutableSet expectedGraph = ImmutableSet.of(ModelResolverLocalTest.uriSet(new IStorage[]{this.iFile1, this.iFile2, this.iFile3}));
        Set<IStorage> expectedTraversal = ModelResolverLocalTest.storageSet(new IStorage[]{this.iFile1, this.iFile2, this.iFile3});
        ExpectedResult expectedResult = new ExpectedResult((Set<? extends Set<URI>>)expectedGraph, expectedTraversal, 0);
        this.setResolutionScope(CrossReferenceResolutionScope.WORKSPACE);
        this.resolveAndCheckResult(files, expectedResult, expectedResult, expectedResult);
    }

    private void resolveAndCheckResult(List<IFile> files, ExpectedResult ... expected) throws Exception {
        int i = 0;
        while (i < files.size()) {
            LogicalModelGraphTest.ResolvingResult resolutionResult = this.resolveTraversalOf(files.get(i));
            this.assertResultMatches(expected[i], resolutionResult);
            ++i;
        }
    }

    private void assertResultMatches(ExpectedResult expected, LogicalModelGraphTest.ResolvingResult actual) {
        Assert.assertEquals((long)expected.getDiagnosticSeverity(), (long)actual.getTraversal().getDiagnostic().getSeverity());
        Set actualStorages = actual.getTraversal().getStorages();
        Set<? extends IStorage> expectedStorages = expected.getStoragesInModel();
        Assert.assertEquals((long)expectedStorages.size(), (long)actualStorages.size());
        Assert.assertTrue((boolean)actualStorages.containsAll(expectedStorages));
        Set<Set<URI>> actualGraph = actual.getSubGraphs();
        Set<? extends Set<URI>> expectedGraph = expected.getSubGraphs();
        Assert.assertEquals((long)expectedGraph.size(), (long)actualGraph.size());
        Assert.assertTrue((boolean)actualGraph.containsAll(expectedGraph));
    }

    private void breakModel(IFile file) throws Exception {
        Scanner scanner = null;
        InputStream outputSource = null;
        try {
            scanner = new Scanner(file.getContents()).useDelimiter("\\A");
            String fileContent = "";
            if (scanner.hasNext()) {
                fileContent = scanner.next();
            }
            String brokenModelContent = fileContent.replaceFirst("EClass", "BrokenEClass");
            outputSource = new ByteArrayInputStream(brokenModelContent.getBytes());
            file.setContents(outputSource, 2, (IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
            if (outputSource != null) {
                outputSource.close();
            }
        }
    }

    private static class ExpectedResult {
        private final Set<? extends Set<URI>> subGraphs;
        private final int diagnosticSeverity;
        private final Set<? extends IStorage> storagesInModel;

        public ExpectedResult(Set<? extends Set<URI>> subGraphs, Set<? extends IStorage> storagesInModel, int diagnosticSeverity) {
            this.subGraphs = subGraphs;
            this.storagesInModel = storagesInModel;
            this.diagnosticSeverity = diagnosticSeverity;
        }

        public Set<? extends Set<URI>> getSubGraphs() {
            return this.subGraphs;
        }

        public int getDiagnosticSeverity() {
            return this.diagnosticSeverity;
        }

        public Set<? extends IStorage> getStoragesInModel() {
            return this.storagesInModel;
        }
    }
}

