/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.ide.ui.tests.comparison.tooltip;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.eventbus.EventBus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.tests.structuremergeviewer.actions.MockMergeAction;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.provider.TooltipLabelAdapterFactory;
import org.eclipse.emf.compare.provider.spec.CompareItemProviderAdapterFactorySpec;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.StructureMergeViewerFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.DefaultGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.TreeItemProviderAdapterFactorySpec;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.provider.TreeNodeItemProviderSpec;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.uml2.ide.ui.tests.comparison.tooltip.data.UMLTooltipProviderInputData;
import org.eclipse.emf.compare.uml2.internal.AssociationChange;
import org.eclipse.emf.compare.uml2.internal.EMFCompareUML2EditMessages;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLInputData;
import org.eclipse.emf.compare.uml2.tests.AbstractUMLTest;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.tree.TreeFactory;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class UMLTooltipProviderTest
extends AbstractUMLTest {
    private static AdapterFactory composedAdapterFactory;
    private UMLTooltipProviderInputData input = new UMLTooltipProviderInputData();
    private IMerger.Registry mergerRegistry;
    private ICompareEditingDomain editingDomain;
    private static TreeNodeItemProviderSpec itemProvider;
    private TreeNode moveEdge;
    private EventBus eventBus;
    public static Predicate<Object> matchTreeNode;

    static {
        matchTreeNode = new Predicate<Object>(){

            public boolean apply(Object object) {
                EObject data;
                return object instanceof TreeNode && (data = ((TreeNode)object).getData()) instanceof Match;
            }
        };
    }

    @BeforeClass
    public static void setupClass() {
        UMLTooltipProviderTest.fillRegistries();
    }

    @AfterClass
    public static void teardownClass() {
        UMLTooltipProviderTest.resetRegistries();
    }

    public void setup_001() throws Exception {
        this.eventBus = new EventBus();
        TreeItemProviderAdapterFactorySpec treeItemProviderAdapterFactorySpec = new TreeItemProviderAdapterFactorySpec(new StructureMergeViewerFilter(this.eventBus));
        ArrayList factories = Lists.newArrayList();
        factories.add(new CompareItemProviderAdapterFactorySpec());
        factories.add(treeItemProviderAdapterFactorySpec);
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        factories.add(new TooltipLabelAdapterFactory());
        composedAdapterFactory = new ComposedAdapterFactory((Collection)factories);
        itemProvider = (TreeNodeItemProviderSpec)treeItemProviderAdapterFactorySpec.createTreeNodeAdapter();
        this.mergerRegistry = EMFCompareRCPPlugin.getDefault().getMergerRegistry();
        Resource origin = this.input.getOrigin();
        Resource left = this.input.getLeft();
        Resource right = this.input.getRight();
        this.editingDomain = EMFCompareEditingDomain.create((Notifier)left, (Notifier)right, (Notifier)origin);
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)left, (Notifier)right, (Notifier)origin);
        Comparison comparison = this.emfCompare.compare((IComparisonScope)scope);
        EList differences = comparison.getDifferences();
        Assert.assertNotEquals((long)0L, (long)differences.size());
        Iterator iterator = Iterables.filter((Iterable)differences, AssociationChange.class).iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        final AssociationChange diff = (AssociationChange)iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Iterable<TreeNode> nodeRootMatchs = UMLTooltipProviderTest.getNodeRootMatch(comparison);
        Predicate<EObject> predicate = new Predicate<EObject>(){

            public boolean apply(EObject object) {
                TreeNode node;
                return object instanceof TreeNode && (node = (TreeNode)object).getData() == diff;
            }
        };
        for (TreeNode nodeRootMatch : nodeRootMatchs) {
            UnmodifiableIterator treeNode = Iterators.filter((Iterator)nodeRootMatch.eAllContents(), (Predicate)predicate);
            if (treeNode == null || !treeNode.hasNext()) continue;
            this.moveEdge = (TreeNode)treeNode.next();
            break;
        }
    }

    @Test
    public void testReject() throws Exception {
        this.setup_001();
        MergeMode accept = MergeMode.REJECT;
        boolean leftEditable = true;
        boolean rightEditable = false;
        IEMFCompareConfiguration emfCC = this.createConfiguration(true, false);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, accept, null);
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.moveEdge));
        String toolTipText = action.getToolTipText();
        String tooltipBody = EMFCompareUML2EditMessages.getString((String)"reject.change.tooltip");
        Assert.assertEquals((Object)tooltipBody, (Object)toolTipText);
    }

    @Test
    public void testAccept() throws Exception {
        this.setup_001();
        MergeMode accept = MergeMode.ACCEPT;
        boolean leftEditable = true;
        boolean rightEditable = false;
        IEMFCompareConfiguration emfCC = this.createConfiguration(true, false);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, accept, null);
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.moveEdge));
        String toolTipText = action.getToolTipText();
        String tooltipBody = EMFCompareUML2EditMessages.getString((String)"accept.change.tooltip");
        Assert.assertEquals((Object)tooltipBody, (Object)toolTipText);
    }

    @Test
    public void testLeft2Right() throws Exception {
        this.setup_001();
        MergeMode accept = MergeMode.LEFT_TO_RIGHT;
        boolean leftEditable = true;
        boolean rightEditable = true;
        IEMFCompareConfiguration emfCC = this.createConfiguration(true, true);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, accept, null);
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.moveEdge));
        String toolTipText = action.getToolTipText();
        String tooltipBody = EMFCompareUML2EditMessages.getString((String)"merged.to.right.tooltip");
        Assert.assertEquals((Object)tooltipBody, (Object)toolTipText);
    }

    @Test
    public void testRight2Left() throws Exception {
        this.setup_001();
        MergeMode accept = MergeMode.RIGHT_TO_LEFT;
        boolean leftEditable = true;
        boolean rightEditable = true;
        IEMFCompareConfiguration emfCC = this.createConfiguration(true, true);
        MockMergeAction action = new MockMergeAction(emfCC, this.mergerRegistry, accept, null);
        action.updateSelection((IStructuredSelection)new StructuredSelection((Object)this.moveEdge));
        String toolTipText = action.getToolTipText();
        String tooltipBody = EMFCompareUML2EditMessages.getString((String)"merged.to.left.tooltip");
        Assert.assertEquals((Object)tooltipBody, (Object)toolTipText);
    }

    protected AbstractUMLInputData getInput() {
        return this.input;
    }

    private static Iterable<TreeNode> getNodeRootMatch(Comparison comparison) throws IOException {
        TreeNode treeNode = TreeFactory.eINSTANCE.createTreeNode();
        treeNode.setData((EObject)comparison);
        treeNode.eAdapters().add((Object)new DefaultGroupProvider());
        Collection children = itemProvider.getChildren((Object)treeNode);
        Iterable matches = Iterables.filter((Iterable)children, matchTreeNode);
        return matches;
    }

    private IEMFCompareConfiguration createConfiguration(boolean leftEditable, boolean rightEditable) {
        CompareConfiguration cc = new CompareConfiguration();
        cc.setLeftEditable(leftEditable);
        cc.setRightEditable(rightEditable);
        EMFCompareConfiguration emfCC = new EMFCompareConfiguration(cc);
        emfCC.setEditingDomain(this.editingDomain);
        emfCC.setAdapterFactory(composedAdapterFactory);
        return emfCC;
    }
}

