/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.tests.fullcomparison;

import java.io.IOException;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.merge.BatchMerger;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.tests.fullcomparison.data.dynamic.DynamicInstancesInputData;
import org.eclipse.emf.compare.tests.suite.AllTests;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DynamicInstanceComparisonTest {
    DynamicInstancesInputData data = new DynamicInstancesInputData();
    Resource left;
    Resource right;
    Resource origin;
    final IMerger.Registry mergerRegistry = IMerger.RegistryImpl.createStandaloneInstance();

    @Before
    public void setUp() throws Exception {
        AllTests.fillEMFRegistries();
        this.left = this.data.getCompareLeft();
        this.right = this.data.getCompareRight();
        this.origin = this.data.getCompareRight();
    }

    @Test
    public void compare2Ways() throws IOException {
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.left, (Notifier)this.right, null);
        Comparison result = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((String)"We are supposed to have one difference (ADD/REMOVE of an instance)", (long)1L, (long)result.getDifferences().size());
    }

    @Test
    public void compare3Ways() throws IOException {
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.left, (Notifier)this.right, (Notifier)this.origin);
        Comparison result = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((String)"We are supposed to have one difference (ADD/REMOVE of an instance)", (long)1L, (long)result.getDifferences().size());
    }

    @Test
    public void copyLeftToRight() throws IOException {
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.left, (Notifier)this.right, null);
        Comparison result = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((String)"We are supposed to have one difference (ADD/REMOVE of an instance)", (long)1L, (long)result.getDifferences().size());
        BatchMerger merger = new BatchMerger(this.mergerRegistry);
        merger.copyAllLeftToRight((Iterable)result.getDifferences(), (Monitor)new BasicMonitor());
        Assert.assertEquals((String)"We are supposed to have no difference as we merged everything", (long)0L, (long)EMFCompare.builder().build().compare((IComparisonScope)scope).getDifferences().size());
    }

    @Test
    public void copyRightToLeft() throws IOException {
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)this.left, (Notifier)this.right, null);
        Comparison result = EMFCompare.builder().build().compare((IComparisonScope)scope);
        Assert.assertEquals((String)"We are supposed to have one difference (ADD/REMOVE of an instance)", (long)1L, (long)result.getDifferences().size());
        BatchMerger merger = new BatchMerger(this.mergerRegistry);
        merger.copyAllRightToLeft((Iterable)result.getDifferences(), (Monitor)new BasicMonitor());
        Assert.assertEquals((String)"We are supposed to have no difference as we merged everything", (long)0L, (long)EMFCompare.builder().build().compare((IComparisonScope)scope).getDifferences().size());
    }
}

