/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.tests;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.examples.extlibrary.EXTLibraryFactory;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.query.conditions.Condition;
import org.eclipse.emf.query.conditions.ObjectInstanceCondition;
import org.eclipse.emf.query.conditions.eobjects.EObjectCondition;
import org.eclipse.emf.query.conditions.eobjects.EObjectInstanceCondition;
import org.eclipse.emf.query.conditions.eobjects.structuralfeatures.EObjectAttributeValueCondition;
import org.eclipse.emf.query.conditions.eobjects.structuralfeatures.EObjectReferenceValueCondition;
import org.eclipse.emf.query.statements.FROM;
import org.eclipse.emf.query.statements.SELECT;
import org.eclipse.emf.query.statements.WHERE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EObjectStructuralFeatureValueConditionTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run((Test)EObjectStructuralFeatureValueConditionTest.suite());
    }

    public static Test suite() {
        return new TestSuite(EObjectStructuralFeatureValueConditionTest.class, "Feature value condition tests");
    }

    public EObjectStructuralFeatureValueConditionTest(String name) {
        super(name);
    }

    public void test_searchForNullValue_184011() {
        HashSet<Library> objects = new HashSet<Library>();
        Library a = EXTLibraryFactory.eINSTANCE.createLibrary();
        objects.add(a);
        Library b = EXTLibraryFactory.eINSTANCE.createLibrary();
        objects.add(b);
        Library c = EXTLibraryFactory.eINSTANCE.createLibrary();
        objects.add(c);
        a.setName("A");
        b.setName(null);
        c.setName("C");
        c.getBranches().add((Object)a);
        c.getBranches().add((Object)b);
        EObjectAttributeValueCondition cond = new EObjectAttributeValueCondition(EXTLibraryPackage.Literals.LIBRARY__NAME, (Condition)ObjectInstanceCondition.IS_NULL);
        Collection<EObject> results = this.query(objects, (EObjectCondition)cond);
        EObjectStructuralFeatureValueConditionTest.assertEquals(Collections.singleton(b), results);
        cond = new EObjectReferenceValueCondition(EXTLibraryPackage.Literals.LIBRARY__PARENT_BRANCH, (EObjectCondition)EObjectInstanceCondition.IS_NULL);
        results = this.query(objects, (EObjectCondition)cond);
        EObjectStructuralFeatureValueConditionTest.assertEquals(Collections.singleton(c), results);
    }

    Collection<EObject> query(Collection<? extends EObject> source, EObjectCondition cond) {
        return new SELECT(new FROM(source), new WHERE(cond)).execute();
    }
}

