/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.tests;

import java.io.File;
import java.util.Collections;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.ChangeFactory;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionChangeDescription;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class ChangeDescriptionTest
extends TestCase {
    private File tempFile;
    private ResourceSet resourceSet;
    private Resource resource;
    private EPackage rootEPackage1;

    public static Test suite() {
        return new TestSuite(ChangeDescriptionTest.class, "Change Description Tests");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.resourceSet = new ResourceSetImpl();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        this.tempFile = File.createTempFile("test", ".ecore");
        URI uri = URI.createFileURI((String)this.tempFile.getCanonicalPath());
        this.resource = this.resourceSet.createResource(uri);
        this.rootEPackage1 = EcoreFactory.eINSTANCE.createEPackage();
        this.resource.getContents().add((Object)this.rootEPackage1);
    }

    public void testChangeDescriptionInNonEMFTEditingDomain1() {
        this.testChangeDescriptionInNonEMFTEditingDomain(this.rootEPackage1);
    }

    public void testChangeDescriptionInNonEMFTEditingDomain2() {
        EPackage rootEPackage2 = EcoreFactory.eINSTANCE.createEPackage();
        this.resource.getContents().add((Object)rootEPackage2);
        this.testChangeDescriptionInNonEMFTEditingDomain(rootEPackage2);
    }

    private void testChangeDescriptionInNonEMFTEditingDomain(EPackage targetOfSecondEClass) {
        ComposedAdapterFactory.Descriptor.Registry registry = EMFEditPlugin.getComposedAdapterFactoryDescriptorRegistry();
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(registry);
        BasicCommandStack commandStack = new BasicCommandStack();
        AdapterFactoryEditingDomain domain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, this.resourceSet);
        ChangeRecorder changeRecorder = new ChangeRecorder(this.resourceSet);
        ChangeDescription changeDescription = ChangeFactory.eINSTANCE.createChangeDescription();
        changeRecorder.beginRecording(changeDescription, Collections.singleton(this.resourceSet));
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        Command addCmd = AddCommand.create((EditingDomain)domain, (Object)this.rootEPackage1, (Object)EcorePackage.Literals.EPACKAGE__ECLASSIFIERS, (Object)eClass);
        addCmd = addCmd.chain(AddCommand.create((EditingDomain)domain, (Object)targetOfSecondEClass, (Object)EcorePackage.Literals.EPACKAGE__ECLASSIFIERS, (Object)EcoreFactory.eINSTANCE.createEClass()));
        domain.getCommandStack().execute(addCmd);
        changeRecorder.endRecording();
        ChangeDescriptionTest.assertEquals((int)(targetOfSecondEClass != this.rootEPackage1 ? 2 : 1), (int)changeDescription.getObjectChanges().size());
        ChangeDescriptionTest.assertEquals((int)2, (int)changeDescription.getObjectsToDetach().size());
        changeRecorder.dispose();
    }

    public void testChangeDescriptionInEMFTEditingDomain1() {
        this.testChangeDescriptionInEMFTEditingDomain(this.rootEPackage1);
    }

    public void testChangeDescriptionInEMFTEditingDomain2() {
        EPackage rootEPackage2 = EcoreFactory.eINSTANCE.createEPackage();
        this.resource.getContents().add((Object)rootEPackage2);
        this.testChangeDescriptionInEMFTEditingDomain(rootEPackage2);
    }

    private void testChangeDescriptionInEMFTEditingDomain(EPackage targetOfPrecommit) {
        TransactionalEditingDomain domain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(this.resourceSet);
        ChangeRecorder changeRecorder = new ChangeRecorder(this.resourceSet);
        ChangeDescription changeDescription = ChangeFactory.eINSTANCE.createChangeDescription();
        changeRecorder.beginRecording(changeDescription, Collections.singleton(this.resourceSet));
        EClassAdder eClassAdder = new EClassAdder(targetOfPrecommit);
        domain.addResourceSetListener((ResourceSetListener)eClassAdder);
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        eClass.setName("EClassFromCommand");
        Command addCmd = AddCommand.create((EditingDomain)domain, (Object)this.rootEPackage1, (Object)EcorePackage.Literals.EPACKAGE__ECLASSIFIERS, (Object)eClass);
        domain.getCommandStack().execute(addCmd);
        changeRecorder.endRecording();
        ChangeDescriptionTest.assertEquals((int)(targetOfPrecommit != this.rootEPackage1 ? 2 : 1), (int)changeDescription.getObjectChanges().size());
        ChangeDescriptionTest.assertEquals((int)2, (int)changeDescription.getObjectsToDetach().size());
        changeRecorder.dispose();
    }

    protected void tearDown() throws Exception {
        this.rootEPackage1 = null;
        this.resource = null;
        this.resourceSet = null;
        this.tempFile.delete();
        this.tempFile = null;
        super.tearDown();
    }

    private static class EClassAdder
    extends ResourceSetListenerImpl {
        private EPackage rootEPackage;
        private boolean added;

        public EClassAdder(EPackage rootEPackage) {
            this.rootEPackage = rootEPackage;
        }

        public boolean isAggregatePrecommitListener() {
            return true;
        }

        public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
            if (!this.added) {
                this.added = true;
                EClass eClass = EcoreFactory.eINSTANCE.createEClass();
                eClass.setName("EClassFromPrecommit");
                return AddCommand.create((EditingDomain)this.getTarget(), (Object)this.rootEPackage, (Object)EcorePackage.Literals.EPACKAGE__ECLASSIFIERS, (Object)eClass);
            }
            return null;
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            super.resourceSetChanged(event);
            TransactionChangeDescription changeDescription = event.getTransaction().getChangeDescription();
            EList objectsToDetach = changeDescription.getObjectsToDetach();
            ChangeDescriptionTest.assertEquals((int)2, (int)objectsToDetach.size());
            changeDescription = null;
        }
    }
}

