/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.test.EclipseTestRunner;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.testing.ITestHarness;
import org.eclipse.ui.testing.TestableObject;
import org.junit.jupiter.api.Assertions;

public class UITestApplication
implements ITestHarness,
IApplication {
    private static final String DEFAULT_APP_3_0 = "org.eclipse.ui.ide.workbench";
    private TestableObject fTestableObject;
    int fTestRunnerResult = -1;
    private IApplicationContext appContext;

    public Object run(Object args) throws Exception {
        Object application = this.getApplication((String[])args);
        Assertions.assertNotNull((Object)application);
        this.fTestableObject = PlatformUI.getTestableObject();
        this.fTestableObject.setTestHarness((ITestHarness)this);
        ((IApplication)application).start(this.appContext);
        return this.fTestRunnerResult;
    }

    private Object getApplication(String[] args) throws CoreException {
        Object runnable;
        IConfigurationElement[] runs;
        IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.runtime", "applications", this.getApplicationToRun(args));
        Assertions.assertNotNull((Object)extension);
        IConfigurationElement[] elements = extension.getConfigurationElements();
        if (elements.length > 0 && (runs = elements[0].getChildren("run")).length > 0 && (runnable = runs[0].createExecutableExtension("class")) instanceof IApplication) {
            return runnable;
        }
        return null;
    }

    private String getApplicationToRun(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-testApplication") && i < args.length - 1) {
                return args[i + 1];
            }
            ++i;
        }
        return DEFAULT_APP_3_0;
    }

    public void runTests() {
        this.fTestableObject.testingStarting();
        this.fTestableObject.runTest(() -> {
            try {
                this.fTestRunnerResult = EclipseTestRunner.run(Platform.getCommandLineArgs());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        this.fTestableObject.testingFinished();
    }

    public Object start(IApplicationContext context) throws Exception {
        this.appContext = context;
        String[] args = (String[])this.appContext.getArguments().get("application.args");
        if (args == null) {
            args = new String[]{};
        }
        return this.run(args);
    }

    public void stop() {
    }
}

